/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.AbstractDrawable;
import com.arsdigita.toolbox.rebop.GenericDrawable;
import java.awt.Color;
import java.awt.Graphics;

public class BevelBox
extends AbstractDrawable
implements GenericDrawable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/rebop/BevelBox.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final int STANDARD_BEVEL = 2;
    private Color m_fillColor = Color.gray;
    private Color m_lightEdge = Color.lightGray;
    private Color m_darkEdge = Color.darkGray;
    private int m_bevelWidth = 2;
    private boolean m_in = false;

    public BevelBox() {
    }

    public BevelBox(Color fillColor) {
        this(fillColor, 2, false);
    }

    public BevelBox(Color fillColor, int bevelWidth, boolean in) {
        Color dark = null;
        Color light = null;
        if (null != fillColor) {
            light = fillColor.brighter().brighter();
            dark = fillColor.darker().darker();
        }
        this.init(fillColor, light, dark, bevelWidth, in);
    }

    public BevelBox(Color fillColor, Color lightEdge, Color darkEdge, int bevelWidth, boolean in) {
        this.init(fillColor, lightEdge, darkEdge, bevelWidth, in);
    }

    private void init(Color fillColor, Color lightEdge, Color darkEdge, int bevelWidth, boolean in) {
        this.m_fillColor = fillColor;
        this.m_lightEdge = lightEdge;
        this.m_darkEdge = darkEdge;
        this.m_bevelWidth = bevelWidth;
        this.m_in = in;
    }

    public void setIn(boolean in) {
        this.m_in = in;
    }

    public void toggleIn() {
        this.m_in = !this.m_in;
    }

    public boolean getIn() {
        return this.m_in;
    }

    public void draw(Graphics g, int x, int y, int width, int height) {
        int i;
        if (null != this.m_fillColor) {
            g.setColor(this.m_fillColor);
            g.fillRect(x, y, width, height);
        }
        Color tlEdgeColor = this.m_lightEdge;
        Color brEdgeColor = this.m_darkEdge;
        if (this.m_in) {
            tlEdgeColor = this.m_darkEdge;
            brEdgeColor = this.m_lightEdge;
        }
        int currentX = x;
        int currentY = y;
        int currentLineWidth = width - 1;
        if (null != tlEdgeColor) {
            g.setColor(tlEdgeColor);
            for (i = 0; i < this.m_bevelWidth; ++i) {
                g.drawLine(currentX, currentY, currentX + currentLineWidth, currentY);
                ++currentX;
                ++currentY;
                currentLineWidth -= 2;
            }
            currentX = x;
            currentY = y;
            currentLineWidth = height - 1;
            for (i = 0; i < this.m_bevelWidth; ++i) {
                g.drawLine(currentX, currentY, currentX, currentY + currentLineWidth);
                ++currentX;
                ++currentY;
                currentLineWidth -= 2;
            }
        }
        if (null != brEdgeColor) {
            g.setColor(brEdgeColor);
            currentX = x;
            currentY = height - 1;
            currentLineWidth = width - 1;
            for (i = 0; i < this.m_bevelWidth; ++i) {
                g.drawLine(currentX, currentY, currentX + currentLineWidth, currentY);
                ++currentX;
                --currentY;
                currentLineWidth -= 2;
            }
            currentX = width - 1;
            currentY = y;
            currentLineWidth = height - 1;
            for (i = 0; i < this.m_bevelWidth; ++i) {
                g.drawLine(currentX, currentY, currentX, currentY + currentLineWidth);
                --currentX;
                ++currentY;
                currentLineWidth -= 2;
            }
        }
    }
}

