/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.templating;

import com.arsdigita.templating.ApplicationPatternGenerator;
import com.arsdigita.templating.HostPatternGenerator;
import com.arsdigita.templating.LocalePatternGenerator;
import com.arsdigita.templating.OutputTypePatternGenerator;
import com.arsdigita.templating.PatternGenerator;
import com.arsdigita.templating.PrefixPatternGenerator;
import com.arsdigita.templating.StylesheetResolver;
import com.arsdigita.templating.Templating;
import com.arsdigita.templating.URLPatternGenerator;
import com.arsdigita.templating.WebAppPatternGenerator;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class PatternStylesheetResolver
implements StylesheetResolver {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$templating$PatternStylesheetResolver == null ? (class$com$arsdigita$templating$PatternStylesheetResolver = PatternStylesheetResolver.class$("com.arsdigita.templating.PatternStylesheetResolver")) : class$com$arsdigita$templating$PatternStylesheetResolver));
    private static final HashMap s_generators = new HashMap();
    private String m_path = null;
    private List m_paths = null;
    static /* synthetic */ Class class$com$arsdigita$templating$PatternStylesheetResolver;

    public static void registerPatternGenerator(String key, PatternGenerator gen) {
        s_generators.put(key, gen);
    }

    private void loadPaths(String path) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Loading paths from " + path));
        }
        this.m_path = path;
        try {
            String line;
            ClassLoader cload = Thread.currentThread().getContextClassLoader();
            InputStream stream = cload.getResourceAsStream(path.substring(1));
            this.m_paths = new ArrayList();
            LineNumberReader file = new LineNumberReader(new InputStreamReader(stream));
            while ((line = file.readLine()) != null) {
                int lineNum = file.getLineNumber();
                if ("".equals(line = line.trim()) || line.startsWith("#") || line.startsWith("!") || line.startsWith("//")) continue;
                List list = StringUtils.splitUp(line, "/::\\w+::/");
                this.m_paths.add(list);
            }
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot read XSLT paths from " + path, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL resolve(HttpServletRequest request) {
        String[] bits;
        PatternStylesheetResolver patternStylesheetResolver = this;
        synchronized (patternStylesheetResolver) {
            if (this.m_paths == null) {
                this.loadPaths(Templating.getConfig().getStylesheetPaths());
            }
        }
        HashMap values = new HashMap();
        ArrayList paths = new ArrayList();
        Iterator it = this.m_paths.iterator();
        while (it.hasNext()) {
            List pathList = (List)it.next();
            bits = pathList.toArray(new String[pathList.size()]);
            this.expandPlaceholders(bits, paths, values, request);
        }
        Iterator files = paths.iterator();
        while (files.hasNext()) {
            URL xfrmedURL;
            bits = (String[])files.next();
            String resource = StringUtils.join(bits, "");
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Looking to see if resource " + resource + " exists"));
            }
            URL origURL = null;
            try {
                origURL = new URL(resource);
            }
            catch (MalformedURLException ex) {
                throw new UncheckedWrapperException("malformed URL " + resource, ex);
            }
            URL uRL = xfrmedURL = origURL == null ? null : Templating.transformURL(origURL);
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Transformed resource is " + xfrmedURL));
            }
            try {
                InputStream is = null;
                if (xfrmedURL != null) {
                    is = xfrmedURL.openStream();
                }
                if (is == null) continue;
                is.close();
                return origURL;
            }
            catch (FileNotFoundException ex) {
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("File not found " + resource), (Throwable)ex);
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("cannot open stream " + resource, ex);
            }
        }
        throw new RuntimeException("no path to XSL stylesheet found; try modifying " + this.m_path);
    }

    private void expandPlaceholders(String[] inBits, ArrayList paths, HashMap values, HttpServletRequest request) {
        LinkedList<String[]> queue = new LinkedList<String[]>();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Queue initial entry " + StringUtils.join(inBits, "")));
        }
        queue.add(inBits);
        while (!queue.isEmpty()) {
            String[] bits = (String[])queue.removeFirst();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Process queue entry " + StringUtils.join(bits, "")));
            }
            boolean clean = true;
            for (int i = 0; i < bits.length && clean; ++i) {
                if (!bits[i].startsWith("::") || !bits[i].endsWith("::")) continue;
                clean = false;
                String[] vals = this.getValues(bits[i].substring(2, bits[i].length() - 2), values, request);
                if (vals == null) continue;
                for (int k = 0; k < vals.length; ++k) {
                    String[] newBits = new String[bits.length];
                    for (int j = 0; j < bits.length; ++j) {
                        newBits[j] = j == i ? vals[k] : bits[j];
                    }
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Requeue " + StringUtils.join(newBits, "")));
                    }
                    queue.add(newBits);
                }
            }
            if (!clean) continue;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Finished expanding placeholders in " + StringUtils.join(bits, "")));
            }
            paths.add(bits);
        }
    }

    private String[] getValues(String key, HashMap values, HttpServletRequest request) {
        String[] vals;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Lookup placeholder keys for " + key));
        }
        if ((vals = (String[])values.get(key)) == null) {
            PatternGenerator gen = (PatternGenerator)s_generators.get(key);
            if (gen == null) {
                return new String[0];
            }
            vals = gen.generateValues(key, request);
            values.put(key, vals);
        }
        return vals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PatternStylesheetResolver.registerPatternGenerator("locale", new LocalePatternGenerator());
        PatternStylesheetResolver.registerPatternGenerator("url", new URLPatternGenerator());
        PatternStylesheetResolver.registerPatternGenerator("application", new ApplicationPatternGenerator());
        PatternStylesheetResolver.registerPatternGenerator("outputtype", new OutputTypePatternGenerator());
        PatternStylesheetResolver.registerPatternGenerator("prefix", new PrefixPatternGenerator());
        PatternStylesheetResolver.registerPatternGenerator("webapps", new WebAppPatternGenerator());
        PatternStylesheetResolver.registerPatternGenerator("host", new HostPatternGenerator());
    }
}

