/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.search.MetadataProvider;
import com.arsdigita.search.MetadataProviderRegistry;
import com.arsdigita.search.intermedia.ContentChangeTime;
import com.arsdigita.search.intermedia.SearchContent;
import com.arsdigita.search.intermedia.SearchIndexHelp;
import com.arsdigita.search.intermedia.Searchable;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DocumentObserver
implements com.arsdigita.search.DocumentObserver {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$intermedia$DocumentObserver == null ? (class$com$arsdigita$search$intermedia$DocumentObserver = DocumentObserver.class$("com.arsdigita.search.intermedia.DocumentObserver")) : class$com$arsdigita$search$intermedia$DocumentObserver));
    static /* synthetic */ Class class$com$arsdigita$search$intermedia$DocumentObserver;

    public void onSave(DomainObject dobj) {
        MetadataProvider adapter = MetadataProviderRegistry.findAdapter(dobj.getObjectType());
        if (adapter != null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Processing object " + dobj.getOID() + " using new adapters"));
            }
            ContentProvider[] xmlContent = adapter.getContent(dobj, ContentType.XML);
            ContentProvider[] rawContent = adapter.getContent(dobj, ContentType.RAW);
            byte[] xml = xmlContent.length > 0 ? xmlContent[0].getBytes() : null;
            byte[] raw = rawContent.length > 0 ? rawContent[0].getBytes() : null;
            Locale locale = adapter.getLocale(dobj);
            this.doOnSave(dobj.getOID(), adapter.getTitle(dobj), adapter.getSummary(dobj), locale == null ? "en" : locale.getLanguage(), xml == null ? null : new String(xml), raw);
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Processing object " + dobj.getOID() + " using old adapters"));
            }
            Searchable searchable = (Searchable)((Object)dobj);
            String xml = searchable.getSearchXMLContent();
            byte[] raw = searchable.getSearchRawContent();
            if (!(xml != null && xml.length() != 0 || raw != null && raw.length != 0)) {
                this.doOnDelete(dobj.getOID());
            } else {
                boolean help_raw;
                String helpKeyword = "use_SearchIndexHelp";
                boolean help_xml = xml != null && xml.equalsIgnoreCase("use_SearchIndexHelp");
                boolean bl = help_raw = raw != null && raw.length == "use_SearchIndexHelp".length() && "use_SearchIndexHelp".equalsIgnoreCase(new String(raw));
                if (help_xml || help_raw) {
                    SearchIndexHelp sh = new SearchIndexHelp();
                    sh.retrieveContent(dobj);
                    if (help_xml) {
                        xml = sh.xmlContent();
                    }
                    if (help_raw) {
                        raw = sh.rawContent();
                    }
                }
                this.doOnSave(dobj.getOID(), searchable.getSearchLinkText(), searchable.getSearchSummary(), searchable.getSearchLanguage(), xml, raw);
            }
        }
    }

    public void onDelete(DomainObject dobj) {
        this.doOnDelete(dobj.getOID());
    }

    private void doOnSave(OID oid, String title, String summary, String language, String xml, byte[] raw) {
        SearchContent sc = SearchContent.retrieveForObject(oid);
        if (sc == null) {
            sc = new SearchContent();
            BigDecimal id = (BigDecimal)oid.get("id");
            sc.setObjectId(id);
            sc.setContentObjectType(oid.getObjectType().getQualifiedName());
        } else if (this.stringMatch(sc.getSummary(), summary) && this.stringMatch(sc.getLinkText(), title) && this.stringMatch(sc.getXMLContent(), xml) && this.byteMatch(sc.getRawContent(), raw) && this.stringMatch(sc.getLanguage(), language)) {
            return;
        }
        sc.setSummary(summary);
        sc.setLinkText(title);
        sc.setXMLContent(xml);
        sc.setRawContent(raw);
        sc.setLanguage(language);
        sc.save();
        ContentChangeTime.flagChange();
    }

    private void doOnDelete(OID oid) {
        SearchContent sc = SearchContent.retrieveForObject(oid);
        if (sc != null) {
            sc.delete();
            ContentChangeTime.flagChange();
        }
    }

    private boolean stringMatch(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private boolean byteMatch(byte[] a, byte[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

