/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.search.BaseDocument;
import com.arsdigita.search.IndexerType;
import com.arsdigita.search.ResultSet;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

class DataQueryResultSet
implements ResultSet {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$intermedia$DataQueryResultSet == null ? (class$com$arsdigita$search$intermedia$DataQueryResultSet = DataQueryResultSet.class$("com.arsdigita.search.intermedia.DataQueryResultSet")) : class$com$arsdigita$search$intermedia$DataQueryResultSet));
    private DataQuery m_query;
    private long m_count;
    private long m_queryTime;
    static /* synthetic */ Class class$com$arsdigita$search$intermedia$DataQueryResultSet;

    public DataQueryResultSet(DataQuery query) {
        this.m_query = query;
        Date start = new Date();
        this.m_count = query.size();
        Date end = new Date();
        this.m_queryTime = end.getTime() - start.getTime();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Result set count is " + this.m_count + ", query duration " + this.m_queryTime));
        }
    }

    public Iterator getDocuments(long offset, long count) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Paginating at offset " + offset + " for " + count + " rows"));
        }
        if (count == 0L) {
            return Collections.EMPTY_LIST.iterator();
        }
        this.m_query.setRange(new Integer((int)offset + 1), new Integer((int)(offset + count + 1L)));
        return new DataQueryIterator(this.m_query);
    }

    public String getEngine() {
        return IndexerType.INTERMEDIA.getKey();
    }

    public long getCount() {
        return this.m_count;
    }

    public long getQueryTime() {
        return this.m_queryTime;
    }

    public void close() {
        this.m_query.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DataQueryIterator
    implements Iterator {
        private DataQuery m_query;
        private BaseDocument m_current;
        private boolean m_hasNext;

        public DataQueryIterator(DataQuery query) {
            this.m_query = query;
            this.peekNext();
        }

        public boolean hasNext() {
            return this.m_hasNext;
        }

        public Object next() {
            Assert.truth(this.m_hasNext, "hasNext");
            BaseDocument result = this.m_current;
            this.peekNext();
            return result;
        }

        private void peekNext() {
            this.m_hasNext = this.m_query.next();
            this.m_current = this.m_hasNext ? new BaseDocument(new OID((String)this.m_query.get("object_type"), (Object)((BigDecimal)this.m_query.get("object_id"))), new Locale((String)this.m_query.get("language"), "us"), (String)this.m_query.get("link_text"), (String)this.m_query.get("summary"), null, null, null, null, (BigDecimal)this.m_query.get("score")) : null;
        }

        public void remove() {
            throw new UnsupportedOperationException("cannot remove items");
        }
    }
}

