/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.populate.apps;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.populate.apps.PopulateAppPair;
import com.arsdigita.populate.apps.PopulateAppPairCollection;
import com.arsdigita.populate.apps.PopulateApps;
import com.arsdigita.util.Assert;
import java.util.List;
import org.apache.log4j.Logger;

public class Initializer
extends BaseInitializer {
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$populate$apps$Initializer == null ? (class$com$arsdigita$populate$apps$Initializer = Initializer.class$("com.arsdigita.populate.apps.Initializer")) : class$com$arsdigita$populate$apps$Initializer).getName());
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$populate$apps$Initializer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$List;

    public Configuration getConfiguration() {
        this.m_conf.initParameter("baseStringSeed", "The base string seed to use for generating String names.", class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String, null);
        this.m_conf.initParameter("numApps", "the number of instances to create for each application", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.m_conf.initParameter("PopulateAppPair", "A list pair, consisting of the PopulateApp class with which to populate andthe arguments for that class", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
        return this.m_conf;
    }

    protected void doStartup() {
        String sBaseStringSeed = (String)this.m_conf.getParameter("baseStringSeed");
        int iApps = (Integer)this.m_conf.getParameter("numApps");
        List popAppsList = (List)this.m_conf.getParameter("PopulateAppPair");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("iApps: " + iApps));
            s_log.debug((Object)("popAppsList: " + popAppsList));
            s_log.debug((Object)("Using BaseStringSeed " + sBaseStringSeed));
        }
        PopulateAppPairCollection popAppsColl = new PopulateAppPairCollection();
        int iSize = popAppsList.size();
        for (int i = 0; i < iSize; ++i) {
            PopulateApp popApp;
            List popAppParam = (List)popAppsList.get(i);
            Assert.assertTrue(popAppParam.size() == 2);
            String sPopApp = (String)popAppParam.get(0);
            s_log.debug((Object)("PopulateApp is " + sPopApp));
            try {
                popApp = (PopulateApp)Class.forName(sPopApp).newInstance();
            }
            catch (Exception e) {
                throw new InitializationException(e.getMessage());
            }
            List args = (List)popAppParam.get(1);
            s_log.debug((Object)("args are" + args));
            PopulateAppPair popAppPair = new PopulateAppPair(popApp, args);
            popAppsColl.addPopulateApp(popAppPair);
        }
        s_log.info((Object)"Begin populating applications");
        PopulateApps popApps = new PopulateApps(popAppsColl);
        popApps.setBaseStringSeed(sBaseStringSeed);
        popApps.populate(iApps);
        s_log.info((Object)"End populating applications");
    }

    protected void doShutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

