/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.CompoundFilterImpl;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.FilterFactoryImpl;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.metadata.CompoundType;
import com.arsdigita.util.Assert;
import com.redhat.persistence.Cursor;
import com.redhat.persistence.DataSet;
import com.redhat.persistence.ProtoException;
import com.redhat.persistence.Signature;
import com.redhat.persistence.common.ParseException;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.common.SQLParser;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.oql.All;
import com.redhat.persistence.oql.Define;
import com.redhat.persistence.oql.Equals;
import com.redhat.persistence.oql.Exists;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.LeftJoin;
import com.redhat.persistence.oql.Limit;
import com.redhat.persistence.oql.Literal;
import com.redhat.persistence.oql.Offset;
import com.redhat.persistence.oql.Sort;
import com.redhat.persistence.oql.Static;
import com.redhat.persistence.oql.Variable;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class DataQueryImpl
implements DataQuery {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/DataQueryImpl.java#41 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$persistence$DataQueryImpl == null ? (class$com$arsdigita$persistence$DataQueryImpl = DataQueryImpl.class$("com.arsdigita.persistence.DataQueryImpl")) : class$com$arsdigita$persistence$DataQueryImpl));
    private static final String s_unalias = "com.arsdigita.persistence.DataQueryImpl.unalias";
    private static final String s_mapAndAddPath = "com.arsdigita.persistence.DataQueryImpl.mapAndAddPath";
    private Session m_ssn;
    private com.redhat.persistence.Session m_pssn;
    private HashMap m_bindings = new HashMap();
    final Signature m_originalSig;
    private Signature m_signature;
    private final Expression m_originalExpr;
    private Expression m_expr;
    Cursor m_cursor = null;
    private CompoundFilterImpl m_filter;
    private ArrayList m_orders = new ArrayList();
    private Integer m_offset = null;
    private Integer m_limit = null;
    private int m_lowerBound = 0;
    private int m_upperBound = Integer.MAX_VALUE;
    private final List m_aliases = new ArrayList();
    private HashMap m_joins = new HashMap();
    private final FilterFactory m_factory;
    private int m_order = 0;
    private SQLParser.Mapper m_mapper = new AddPathMapper();
    private SQLParser.Mapper m_unaliaser = new UnaliasMapper();
    static /* synthetic */ Class class$com$arsdigita$persistence$DataQueryImpl;

    private SQLParser getParser(String key, Reader reader, SQLParser.Mapper mapper) {
        TransactionContext ctx = this.m_ssn.getTransactionContext();
        SQLParser p = (SQLParser)ctx.getAttribute(key);
        if (p == null) {
            p = new SQLParser(reader, mapper);
            ctx.setAttribute(key, p);
        } else {
            p.initialize(reader, mapper);
        }
        return p;
    }

    DataQueryImpl(Session ssn, DataSet ds) {
        this(ssn, ds.getSignature(), ds.getExpression());
    }

    DataQueryImpl(Session ssn, Signature sig, Expression expr) {
        this.m_ssn = ssn;
        this.m_pssn = ssn.getProtoSession();
        this.m_originalSig = sig;
        this.m_originalExpr = expr;
        this.m_factory = new FilterFactoryImpl(ssn);
        this.reset();
    }

    Session getSession() {
        return this.m_ssn;
    }

    ObjectType getTypeInternal() {
        return this.m_originalSig.getObjectType();
    }

    public CompoundType getType() {
        throw new Error("not implemented");
    }

    public boolean hasProperty(String propertyName) {
        Path p = this.unalias(Path.get(propertyName));
        return this.hasProperty(p);
    }

    boolean hasProperty(Path p) {
        return this.getTypeInternal().getProperty(p) != null;
    }

    public void reset() {
        this.close();
        this.m_cursor = null;
        this.clearOrder();
        this.clearFilter();
        this.m_lowerBound = 0;
        this.m_upperBound = Integer.MAX_VALUE;
        this.m_offset = null;
        this.m_limit = null;
        this.m_signature = new Signature(this.m_originalSig);
        this.m_joins.clear();
        this.m_bindings.clear();
        this.m_expr = this.getClass().equals(class$com$arsdigita$persistence$DataQueryImpl == null ? (class$com$arsdigita$persistence$DataQueryImpl = DataQueryImpl.class$("com.arsdigita.persistence.DataQueryImpl")) : class$com$arsdigita$persistence$DataQueryImpl) ? new Define(new Static(this.getTypeInternal().getQualifiedName(), this.m_bindings), "this") : new Define(this.m_originalExpr, "this");
        this.m_signature = new Signature();
        this.m_signature.addSignature(this.m_originalSig, Path.get("this"));
        this.m_joins.put(null, "this");
    }

    public boolean first() {
        throw new Error("not implemented");
    }

    public boolean isEmpty() {
        try {
            if (this.m_cursor == null) {
                return new DataSet(this.m_pssn, this.m_signature, this.makeExpr()).isEmpty();
            }
            return this.m_cursor.getDataSet().isEmpty();
        }
        catch (ProtoException e) {
            throw PersistenceException.newInstance(e);
        }
    }

    public boolean isBeforeFirst() {
        this.checkCursor();
        return this.m_cursor.isBeforeFirst();
    }

    public boolean isFirst() {
        this.checkCursor();
        return this.m_cursor.isFirst();
    }

    public boolean isLast() {
        throw new Error("not implemented");
    }

    public boolean isAfterLast() {
        this.checkCursor();
        return this.m_cursor.isAfterLast();
    }

    public boolean last() {
        throw new Error("not implemented");
    }

    public boolean previous() {
        throw new Error("not implemented");
    }

    public void addPath(String path) {
        Path p = this.unalias(Path.get(path));
        this.addPath(p, true);
    }

    private void addPath(Path path, boolean requiresFetching) {
        if (this.m_cursor != null) {
            throw new PersistenceException("Paths cannot be added on an active data query.");
        }
        this.addJoin(path);
        path = this.resolvePath(path);
        if (requiresFetching) {
            this.m_signature.addPath(path);
        } else {
            Assert.truth(this.m_signature.exists(path));
        }
    }

    protected Path resolvePath(Path path) {
        Path base;
        if (this.m_joins.size() == 0) {
            return path;
        }
        for (base = path; base != null && !this.m_joins.containsKey(base); base = base.getParent()) {
        }
        Path candidate = Path.add((String)this.m_joins.get(base), Path.relative(base, path));
        if (this.m_signature.exists(candidate)) {
            return candidate;
        }
        return path;
    }

    private void addJoin(Path path) {
        ArrayList<String> elts = new ArrayList<String>();
        for (Path p = path; p != null; p = p.getParent()) {
            elts.add(p.getName());
        }
        ObjectType type = this.getTypeInternal();
        Path coll = null;
        Path prev = null;
        boolean collectionFound = false;
        for (int i = elts.size() - 1; i >= 0; --i) {
            String propName = (String)elts.get(i);
            Property prop = type.getProperty(propName);
            type = prop.getType();
            coll = Path.add(coll, propName);
            if (prop.isCollection()) {
                Define prevColl;
                collectionFound = true;
                String alias = coll.getPath().replace('.', '_');
                if (this.m_joins.containsKey(coll)) {
                    prev = coll;
                    continue;
                }
                this.m_joins.put(coll, alias);
                if (prev == null) {
                    prevColl = new Define(Expression.valueOf(Path.add("this", coll)), "target");
                } else {
                    Path p = Path.add((String)this.m_joins.get(prev), Path.relative(prev, coll));
                    prevColl = new Define(Expression.valueOf(p), "target");
                }
                Exists cond = new Exists(new com.redhat.persistence.oql.Filter(prevColl, new Equals(new Variable(alias), new Variable("target"))));
                this.m_expr = new LeftJoin(this.m_expr, new Define(new All(type.getQualifiedName()), alias), cond);
                this.m_signature.addSource(type, Path.get(alias));
                prev = coll;
            }
            if (!propName.endsWith("@link")) continue;
            Object rel = null;
            String assocName = propName.substring(0, propName.length() - "@link".length());
            Path assoc = Path.add(coll.getParent(), assocName);
            this.addJoin(assoc);
            Path pathThroughLink = Path.add(this.resolvePath(coll), assocName);
            this.m_expr = new com.redhat.persistence.oql.Filter(this.m_expr, new Equals(Expression.valueOf(pathThroughLink), Expression.valueOf(this.resolvePath(assoc))));
        }
    }

    public Filter setFilter(String conditions) {
        this.clearFilter();
        return this.addFilter(conditions);
    }

    public Filter addFilter(String conditions) {
        if (this.m_cursor != null) {
            throw new PersistenceException("The filter cannot be set on an active data query. Data query must be rewound.");
        }
        return this.m_filter.addFilter(conditions);
    }

    public Filter addFilter(Filter filter) {
        if (this.m_cursor != null) {
            throw new PersistenceException("The filter cannot be set on an active data query. Data query must be rewound.");
        }
        return this.m_filter.addFilter(filter);
    }

    public boolean removeFilter(Filter filter) {
        if (this.m_cursor != null) {
            throw new PersistenceException("The filter cannot be removed on an active data query. Data query must be rewound.");
        }
        return this.m_filter.removeFilter(filter);
    }

    public Filter addInSubqueryFilter(String propertyName, String subqueryName) {
        return this.addFilter(this.getFilterFactory().in(propertyName, subqueryName));
    }

    public Filter addInSubqueryFilter(String propertyName, String subQueryProperty, String queryName) {
        return this.addFilter(this.getFilterFactory().in(propertyName, subQueryProperty, queryName));
    }

    public Filter addNotInSubqueryFilter(String propertyName, String subqueryName) {
        return this.addFilter(this.getFilterFactory().notIn(propertyName, subqueryName));
    }

    public Filter addEqualsFilter(String attribute, Object value) {
        return this.addFilter(this.getFilterFactory().equals(attribute, value));
    }

    public Filter addNotEqualsFilter(String attribute, Object value) {
        return this.addFilter(this.getFilterFactory().notEquals(attribute, value));
    }

    public void clearFilter() {
        if (this.m_cursor != null) {
            throw new PersistenceException("Cannot clear the filter on an active data query. Data query must be rewound.");
        }
        this.m_filter = (CompoundFilterImpl)this.getFilterFactory().and();
    }

    public FilterFactory getFilterFactory() {
        return this.m_factory;
    }

    public void setOrder(String order) {
        this.clearOrder();
        this.addOrder(order);
    }

    public void addOrder(String order) {
        if (this.m_cursor != null) {
            throw new PersistenceException("Cannot order an active data query. Data query must be rewound.");
        }
        order = this.unalias(order);
        this.m_orders.add(order);
    }

    public void addOrderWithNull(String orderOne, Object orderTwo, boolean isAscending) {
        Path two;
        String suffix = null;
        suffix = isAscending ? "asc" : "desc";
        Object secondElement = orderTwo;
        if (orderTwo instanceof String && orderTwo != null && !this.hasProperty(two = this.unalias(Path.get((String)orderTwo)))) {
            String var = "order" + this.m_order++;
            secondElement = ":" + var;
            this.setParameter(var, orderTwo);
            if (orderOne != null) {
                Root root = this.getSession().getRoot();
                ObjectType typeOne = this.getTypeInternal().getProperty(this.unalias(Path.get(orderOne))).getType();
                if (!root.getObjectType("global.String").equals(typeOne)) {
                    throw new PersistenceException("type mismatch");
                }
            }
        }
        this.addOrder("case when (" + orderOne + " is null) then " + secondElement + " else " + orderOne + " end " + suffix);
    }

    public void clearOrder() {
        this.m_orders.clear();
        this.m_order = 0;
    }

    public void setParameter(String parameterName, Object value) {
        this.m_bindings.put(parameterName, value);
    }

    public Object getParameter(String parameterName) {
        return this.m_bindings.get(parameterName);
    }

    public void setRange(Integer beginIndex) {
        this.setRange(beginIndex, null);
    }

    public void setRange(Integer beginIndex, Integer endIndex) {
        if (endIndex != null && endIndex.compareTo(beginIndex) <= 0) {
            throw new PersistenceException("The beginIndex [" + beginIndex + "] must be strictly less " + "than the endIndex [" + endIndex + "]");
        }
        this.m_offset = new Integer(beginIndex - 1);
        if (endIndex != null) {
            this.m_limit = new Integer(endIndex - beginIndex);
        }
    }

    public Map getPropertyValues() {
        throw new Error("not implemented");
    }

    public void setReturnsUpperBound(int upperBound) {
        this.m_upperBound = upperBound;
    }

    public void setReturnsLowerBound(int lowerBound) {
        if (lowerBound > 1 || lowerBound < 0) {
            throw new PersistenceException("The lower bound for a given query must be 0 or 1.");
        }
        this.m_lowerBound = lowerBound;
    }

    public void alias(String fromPrefix, String toPrefix) {
        this.m_aliases.add(new Alias(fromPrefix, toPrefix));
    }

    public void close() {
        if (this.m_cursor != null) {
            this.m_cursor.close();
        }
    }

    public void rewind() {
        if (this.m_cursor != null) {
            this.m_cursor.rewind();
        }
    }

    public Object get(String propertyName) {
        Path path = this.resolvePath(this.unalias(Path.get(propertyName)));
        try {
            return this.m_cursor.get(path);
        }
        catch (ProtoException e) {
            throw PersistenceException.newInstance(e);
        }
    }

    public int getPosition() {
        this.checkCursor();
        return (int)this.m_cursor.getPosition();
    }

    Path mapAndAddPath(Path p) {
        return this.m_mapper.map(p);
    }

    String mapAndAddPaths(String s) {
        StringReader reader = new StringReader(s);
        SQLParser p = this.getParser(s_mapAndAddPath, reader, this.m_mapper);
        try {
            p.sql();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return p.getSQL().toString();
    }

    private Expression makeExpr() {
        String[] orders = new String[this.m_orders.size()];
        for (int i = this.m_orders.size() - 1; i >= 0; --i) {
            String order = (String)this.m_orders.get(i);
            orders[i] = this.mapAndAddPaths(order);
        }
        Expression filter = this.m_filter.makeExpression(this, this.m_bindings);
        Expression expr = this.m_expr;
        if (filter != null) {
            expr = new com.redhat.persistence.oql.Filter(expr, filter);
        }
        for (int i = orders.length - 1; i >= 0; --i) {
            expr = new Sort(expr, new Static(orders[i], this.m_bindings));
        }
        if (this.m_offset != null) {
            expr = new Offset(expr, new Literal(this.m_offset));
        }
        if (this.m_limit != null) {
            expr = new Limit(expr, new Literal(this.m_limit));
        }
        return expr;
    }

    private void checkCursor() {
        if (this.m_cursor == null) {
            try {
                this.m_cursor = this.execute(this.m_signature, this.makeExpr());
            }
            catch (ProtoException e) {
                throw PersistenceException.newInstance(e);
            }
        }
    }

    protected Cursor execute(Signature sig, Expression expr) {
        return new DataSet(this.m_pssn, sig, expr).getCursor();
    }

    public boolean next() {
        boolean result;
        this.checkCursor();
        if (this.m_cursor.isClosed()) {
            return false;
        }
        int pre = this.getPosition();
        try {
            result = this.m_cursor.next();
        }
        catch (ProtoException e) {
            throw PersistenceException.newInstance(e);
        }
        if (result) {
            if (this.getPosition() == this.m_upperBound && this.m_cursor.next()) {
                throw new PersistenceException("cursor exceeded upper bound");
            }
        } else if (pre < this.m_lowerBound) {
            throw new PersistenceException("cursor failed to meet lower bound");
        }
        return result;
    }

    public long size() {
        try {
            if (this.m_cursor == null) {
                return new DataSet(this.m_pssn, this.m_signature, this.makeExpr()).size();
            }
            return this.m_cursor.getDataSet().size();
        }
        catch (ProtoException e) {
            throw PersistenceException.newInstance(e);
        }
    }

    String unalias(String expr) {
        if (expr == null) {
            return null;
        }
        StringReader reader = new StringReader(expr);
        SQLParser p = this.getParser(s_unalias, reader, this.m_unaliaser);
        try {
            p.sql();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return p.getSQL().toString();
    }

    Path unalias(Path path) {
        String str;
        int index;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("External Path: " + path));
            s_log.debug((Object)("Aliases: " + this.m_aliases.toString()));
        }
        if ((index = (str = path.getPath()).indexOf(".link.")) != -1) {
            str = str.substring(0, index) + "@link" + "." + str.substring(index + 6);
        }
        Path result = path = Path.get(str);
        Iterator it = this.m_aliases.iterator();
        while (it.hasNext()) {
            Alias alias = (Alias)it.next();
            if (alias.isMatch(path)) {
                Path candidate;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("matched " + alias));
                }
                if (this.hasProperty(candidate = alias.unalias(path))) {
                    result = candidate;
                    break;
                }
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("Candidate " + candidate + " doesn't exist."));
                continue;
            }
            if (!s_log.isDebugEnabled()) continue;
            s_log.debug((Object)("didn't match " + alias));
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Internal Path: " + result));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Alias {
        private Path m_from;
        private Path m_to;

        public Alias(String from, String to) {
            Assert.assertNotEmpty(from, "from");
            Assert.assertNotEmpty(to, "to");
            this.m_from = Path.get(from);
            this.m_to = Path.get(to);
        }

        private static final boolean isWildcard(Path path) {
            return path.getParent() == null && path.getName().equals("*");
        }

        public boolean isMatch(Path path) {
            if (Alias.isWildcard(this.m_from)) {
                return true;
            }
            if (this.m_from.getParent() == null) {
                return this.m_from.equals(path);
            }
            while (path.getParent() != null) {
                path = path.getParent();
            }
            return this.m_from.getParent().equals(path);
        }

        public Path unalias(Path path) {
            if (Alias.isWildcard(this.m_from) && Alias.isWildcard(this.m_to)) {
                return path;
            }
            if (Alias.isWildcard(this.m_from) && !Alias.isWildcard(this.m_to)) {
                if (this.m_to.getParent() != null) {
                    return Path.add(this.m_to.getParent(), path);
                }
                throw new IllegalStateException(this + " " + path);
            }
            if (!Alias.isWildcard(this.m_from) && Alias.isWildcard(this.m_to)) {
                return path.getRelative(this.m_from);
            }
            try {
                return Path.add(this.m_to, path.getRelative(this.m_from));
            }
            catch (RuntimeException e) {
                throw new PersistenceException(this + " " + path, e);
            }
        }

        public String toString() {
            return this.m_from + " --> " + this.m_to;
        }
    }

    private class UnaliasMapper
    implements SQLParser.Mapper {
        private UnaliasMapper() {
        }

        public Path map(Path path) {
            return DataQueryImpl.this.unalias(path);
        }
    }

    private class AddPathMapper
    implements SQLParser.Mapper {
        private AddPathMapper() {
        }

        public Path map(Path path) {
            Path p = DataQueryImpl.this.unalias(path);
            if (DataQueryImpl.this.getTypeInternal().getProperty(p) != null) {
                DataQueryImpl.this.addPath(p, false);
            }
            return DataQueryImpl.this.resolvePath(p);
        }
    }
}

