/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.Check;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.util.Classes;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.XML;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class Checklist {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Checklist.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final int SCHEMA = 0;
    public static final int DATA = 1;
    public static final int STARTUP = 2;
    private List m_groups = new ArrayList();
    private static final String CHECKS = "checks";
    private static final String TYPE = "type";
    private static final String CHECK = "check";
    private static final String CLASS = "class";
    static /* synthetic */ Class class$com$arsdigita$packaging$Checklist;

    public static Checklist get(String pkg) {
        ClassLoader ldr = (class$com$arsdigita$packaging$Checklist == null ? (class$com$arsdigita$packaging$Checklist = Checklist.class$("com.arsdigita.packaging.Checklist")) : class$com$arsdigita$packaging$Checklist).getClassLoader();
        InputStream is = ldr.getResourceAsStream(pkg + ".checklist");
        if (is == null) {
            return null;
        }
        Checklist list = new Checklist(is);
        try {
            is.close();
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
        return list;
    }

    public Checklist(InputStream is) {
        XML.parse(is, new ChecklistHandler());
    }

    public boolean run(int type, ScriptContext ctx) {
        boolean result = true;
        Iterator it = this.m_groups.iterator();
        while (it.hasNext()) {
            Group group = (Group)it.next();
            if (group.getType() != type) continue;
            result &= group.run(ctx);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ChecklistHandler
    extends DefaultHandler {
        private Group m_group = null;

        private ChecklistHandler() {
        }

        public void startElement(String uri, String name, String qn, Attributes attrs) {
            if (name.equals(Checklist.CHECKS)) {
                String type = attrs.getValue(uri, Checklist.TYPE);
                if (type == null) {
                    throw new IllegalStateException("checks requires a type attribute");
                }
                if (type.equals("schema")) {
                    this.m_group = new Group(0);
                } else if (type.equals("data")) {
                    this.m_group = new Group(1);
                } else if (type.equals("startup")) {
                    this.m_group = new Group(2);
                } else {
                    throw new IllegalStateException("unrecognized value for type attribute: " + type);
                }
            }
            if (name.equals(Checklist.CHECK)) {
                if (this.m_group == null) {
                    throw new IllegalStateException("check element cannot appear outside of a checks group");
                }
                String klass = attrs.getValue(uri, Checklist.CLASS);
                if (klass == null) {
                    throw new IllegalStateException("check element requires a class attribute");
                }
                this.m_group.addCheck((Check)Classes.newInstance(klass));
            }
        }

        public void endElement(String uri, String name, String qn) {
            if (name.equals(Checklist.CHECKS)) {
                Checklist.this.m_groups.add(this.m_group);
                this.m_group = null;
            }
        }
    }

    private class Group {
        private int m_type;
        private List m_checks;

        public Group(int type) {
            this.m_type = type;
            this.m_checks = new ArrayList();
        }

        public int getType() {
            return this.m_type;
        }

        void addCheck(Check check) {
            this.m_checks.add(check);
        }

        public List getChecks() {
            return this.m_checks;
        }

        public boolean run(ScriptContext ctx) {
            Iterator it = this.m_checks.iterator();
            while (it.hasNext()) {
                Check check = (Check)it.next();
                check.run(ctx);
                Check.Status status = check.getStatus();
                if (status == null) {
                    throw new IllegalStateException(check.getClass().getName() + ": check failed to " + "report exit status");
                }
                if (!status.equals(Check.FAIL)) continue;
                return false;
            }
            return true;
        }
    }
}

