/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.notification;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.StringUtils;
import org.apache.log4j.Logger;

public abstract class BaseSubscription
extends ACSObject {
    private static final String GROUP = "group";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$notification$BaseSubscription == null ? (class$com$arsdigita$notification$BaseSubscription = BaseSubscription.class$("com.arsdigita.notification.BaseSubscription")) : class$com$arsdigita$notification$BaseSubscription));
    private Group m_group = null;
    protected static final String SEPARATOR = BaseSubscription.getSeparator();
    protected static final String ALERT_BLURB = "This is an automated alert from the Discussion Forum system. ";
    protected static final String REPLY_BLURB = "Replying to this email will add a post to the forum. It will not send email directly to the person who posted this message.\n\n";
    static /* synthetic */ Class class$com$arsdigita$notification$BaseSubscription;

    public BaseSubscription(String objectType) {
        super(objectType);
        this.setupSubscriptionGroup();
    }

    protected void setupSubscriptionGroup() {
        Group group = new Group();
        group.setName("Bboard subscription group");
        this.setGroup(group);
    }

    public BaseSubscription(DataObject dataObj) {
        super(dataObj);
    }

    public BaseSubscription(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Group getGroup() {
        DataObject groupData;
        if (this.m_group == null && (groupData = (DataObject)this.get(GROUP)) != null) {
            this.m_group = new Group(groupData);
        }
        return this.m_group;
    }

    protected void setGroup(Group group) {
        this.m_group = group;
        this.setAssociation(GROUP, group);
    }

    public void setGroupName(String name) {
        this.getGroup().setName(name);
    }

    public final void subscribe(Party party) {
        this.getGroup().addMemberOrSubgroup(party);
    }

    public final void unsubscribe(Party party) {
        this.getGroup().removeMemberOrSubgroup(party);
    }

    public final boolean isSubscribed(Party party) {
        return this.getGroup().hasMember(party);
    }

    public void sendNotification(ThreadedMessage post) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Sending nofication to: " + this.getGroup().getName()));
        }
        Notification note = new Notification(this.getGroup(), post);
        note.setExpandGroup(new Boolean(true));
        note.setHeader(this.getHeader(post));
        note.setSignature(this.getSignature(post));
        note.save();
    }

    public abstract String getHeader(ThreadedMessage var1);

    public String getSignature(ThreadedMessage post) {
        return SEPARATOR + ALERT_BLURB;
    }

    private static String getSeparator() {
        return "\n\n" + StringUtils.repeat('-', 20) + "\n\n";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

