/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.ui;

import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.DataQueryTreeNode;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.Iterator;

public class DataQueryTreeIterator
implements Iterator {
    protected DataQuery m_nodes;

    public DataQueryTreeIterator(DataQueryTreeNode node, String getSubCategories) {
        Session session = SessionManager.getSession();
        this.m_nodes = session.retrieveQuery(getSubCategories);
        this.m_nodes.setParameter("objectID", node.getID());
    }

    public void filterQuery(String propertyName, PrivilegeDescriptor privilege, OID userOID) {
        PermissionService.filterQuery(this.m_nodes, propertyName, privilege, userOID);
    }

    public void setParameter(String parameterName, Object parameterValue) {
        this.m_nodes.setParameter(parameterName, parameterValue);
    }

    public void addOrder(String parameterName) {
        this.m_nodes.addOrder(parameterName);
    }

    public Object next() {
        BigDecimal id = (BigDecimal)this.m_nodes.get("id");
        String name = (String)this.m_nodes.get("name");
        BigDecimal count = (BigDecimal)this.m_nodes.get("nchild");
        return new DataQueryTreeNode(id, name, count.intValue() > 0);
    }

    public void remove() {
        throw new UnsupportedOperationException("cannot remove categories via iterator");
    }

    public boolean hasNext() {
        return this.m_nodes.next();
    }
}

