/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.dispatcher.RedirectException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.AccountNotFoundException;
import com.arsdigita.kernel.security.CredentialNotFoundException;
import com.arsdigita.kernel.security.CredentialParsingException;
import com.arsdigita.kernel.security.HTTPRequestCallback;
import com.arsdigita.kernel.security.HTTPResponseCallback;
import com.arsdigita.kernel.security.LifetimeCallback;
import com.arsdigita.kernel.security.LoginContext;
import com.arsdigita.kernel.security.PartyPrincipal;
import com.arsdigita.kernel.security.RecoveryLoginModule;
import com.arsdigita.kernel.security.SecurityLogger;
import com.arsdigita.kernel.security.SessionContext;
import com.arsdigita.kernel.security.Util;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class UserContext {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/UserContext.java#21 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$security$UserContext == null ? (class$com$arsdigita$kernel$security$UserContext = UserContext.class$("com.arsdigita.kernel.security.UserContext")) : class$com$arsdigita$kernel$security$UserContext));
    public static final String REQUEST_LOGIN_CONTEXT = "Request";
    public static final String REGISTER_LOGIN_CONTEXT = "Register";
    private HttpServletRequest m_req;
    private HttpServletResponse m_res;
    private User m_user;
    private BigDecimal m_userID;
    private boolean m_recovering;
    private Set m_params;
    private SessionContext m_session;
    public static final String RETURN_URL_PARAM_NAME = "return_url";
    static /* synthetic */ Class class$com$arsdigita$kernel$security$UserContext;
    static /* synthetic */ Class class$com$arsdigita$bebop$parameters$ParameterData;
    static /* synthetic */ Class class$com$arsdigita$bebop$parameters$ParameterModel;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$PartyPrincipal;

    private void clearValues() {
        this.m_user = null;
        this.m_userID = null;
        this.m_recovering = false;
        this.m_params = new HashSet();
    }

    private void loadValues(Subject subject) throws LoginException {
        this.m_userID = this.getUserID(subject);
        s_log.debug((Object)("userID == " + this.m_userID));
        this.m_recovering = RecoveryLoginModule.isRecovering(subject);
        s_log.debug((Object)("recovering == " + this.m_recovering));
        this.m_params = subject.getPublicCredentials(class$com$arsdigita$bebop$parameters$ParameterData == null ? (class$com$arsdigita$bebop$parameters$ParameterData = UserContext.class$("com.arsdigita.bebop.parameters.ParameterData")) : class$com$arsdigita$bebop$parameters$ParameterData);
        s_log.debug((Object)("params.size == " + this.m_params.size()));
    }

    public UserContext(HttpServletRequest req, HttpServletResponse res) throws RedirectException {
        this.m_req = req;
        this.m_res = res;
        this.m_session = new SessionContext(req, res);
        this.login();
    }

    public void login(String username) throws LoginException {
        s_log.debug((Object)"START login(username)");
        try {
            this.login(UserAuthentication.retrieveForLoginName(username).getUser());
            s_log.debug((Object)"SUCCESS login(username)");
        }
        catch (DataObjectNotFoundException e) {
            throw new AccountNotFoundException("user " + username + " does not exist", e);
        }
    }

    public void login(BigDecimal userID) throws LoginException {
        s_log.debug((Object)"START login(userID)");
        try {
            this.login(User.retrieve(userID));
            s_log.debug((Object)"SUCCESS login(userID)");
        }
        catch (DataObjectNotFoundException e) {
            throw new AccountNotFoundException("user " + userID + " does not exist", e);
        }
    }

    public void login(User target) throws LoginException {
        s_log.debug((Object)"START login(User)");
        if (!this.isLoggedIn()) {
            s_log.debug((Object)"FAILURE login(User): not logged in");
            throw new FailedLoginException("not logged in");
        }
        User user = this.getUser();
        if (user == null) {
            s_log.debug((Object)"FAILURE login(User): current user doesn't exist");
            throw new FailedLoginException("current user doesn't exist");
        }
        PermissionDescriptor superuser = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, target, user);
        if (!PermissionService.checkPermission(superuser)) {
            s_log.debug((Object)"FAILURE login(User): insufficient privileges");
            SecurityLogger.warn("user " + user.getID() + " failed to log in as user " + target.getID() + " due to insufficient privileges");
            throw new FailedLoginException("insufficient privileges to become target user");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new PartyPrincipal(target.getID()));
        RequestCallbackHandler handler = new RequestCallbackHandler();
        LoginContext context = new LoginContext(REQUEST_LOGIN_CONTEXT, subject, handler);
        this.clearValues();
        context.login();
        this.loadValues(context.getSubject());
        this.m_session.loadSessionID(handler);
        s_log.debug((Object)"SUCCESS login(User)");
    }

    public SessionContext getSessionContext() {
        return this.m_session;
    }

    public boolean isLoggedIn() {
        return this.m_userID != null;
    }

    public boolean isRecovering() {
        return this.m_recovering;
    }

    Set getParams() {
        return Collections.unmodifiableSet(this.m_params);
    }

    static Set getModels() {
        try {
            LoginContext context = new LoginContext(REQUEST_LOGIN_CONTEXT);
            return Collections.unmodifiableSet(context.getSubject().getPublicCredentials(class$com$arsdigita$bebop$parameters$ParameterModel == null ? (class$com$arsdigita$bebop$parameters$ParameterModel = UserContext.class$("com.arsdigita.bebop.parameters.ParameterModel")) : class$com$arsdigita$bebop$parameters$ParameterModel));
        }
        catch (LoginException e) {
            throw new UncheckedWrapperException("Could not load context", e);
        }
    }

    public BigDecimal getUserID() {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("user is not logged in");
        }
        return this.m_userID;
    }

    public User getUser() {
        if (this.m_user == null) {
            try {
                this.m_user = User.retrieve(this.getUserID());
            }
            catch (DataObjectNotFoundException e) {
                this.m_user = null;
            }
            if (this.m_user != null) {
                this.m_user.disconnect();
            }
        }
        return this.m_user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void login() throws RedirectException {
        RequestCallbackHandler handler;
        block15: {
            block16: {
                s_log.debug((Object)"START login()");
                handler = new RequestCallbackHandler();
                boolean success = false;
                try {
                    try {
                        LoginContext context = new LoginContext(REQUEST_LOGIN_CONTEXT, handler);
                        this.clearValues();
                        context.login();
                        this.loadValues(context.getSubject());
                        s_log.debug((Object)"SUCCESS login()");
                        success = true;
                    }
                    catch (CredentialNotFoundException e) {
                        s_log.debug((Object)"FAIL login(): user does not have credential", (Throwable)e);
                        Object var5_9 = null;
                        if (success) break block15;
                        if (Util.getSecurityHelper().requiresLogin(this.m_req)) {
                            s_log.debug((Object)"This request requires logging in; requesting redirect to login UI");
                            UserContext.redirectToLoginPage(this.m_req);
                            break block15;
                        } else {
                            s_log.debug((Object)"This request does not require logging in");
                        }
                        break block15;
                    }
                    catch (CredentialParsingException e) {
                        s_log.debug((Object)"FAIL login()", (Throwable)e);
                        SecurityLogger.warn("login credential tampered with");
                        Object var5_10 = null;
                        if (success) break block15;
                        if (Util.getSecurityHelper().requiresLogin(this.m_req)) {
                            s_log.debug((Object)"This request requires logging in; requesting redirect to login UI");
                            UserContext.redirectToLoginPage(this.m_req);
                            break block15;
                        } else {
                            s_log.debug((Object)"This request does not require logging in");
                        }
                        break block15;
                    }
                    catch (LoginException e) {
                        s_log.debug((Object)"FAIL login()", (Throwable)e);
                        Object var5_11 = null;
                        if (success) break block15;
                        if (Util.getSecurityHelper().requiresLogin(this.m_req)) {
                            s_log.debug((Object)"This request requires logging in; requesting redirect to login UI");
                            UserContext.redirectToLoginPage(this.m_req);
                            break block15;
                        } else {
                            s_log.debug((Object)"This request does not require logging in");
                        }
                        break block15;
                    }
                    Object var5_8 = null;
                    if (success) break block15;
                    if (!Util.getSecurityHelper().requiresLogin(this.m_req)) break block16;
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    if (success) throw throwable;
                    if (Util.getSecurityHelper().requiresLogin(this.m_req)) {
                        s_log.debug((Object)"This request requires logging in; requesting redirect to login UI");
                        UserContext.redirectToLoginPage(this.m_req);
                        throw throwable;
                    }
                    s_log.debug((Object)"This request does not require logging in");
                    throw throwable;
                }
                s_log.debug((Object)"This request requires logging in; requesting redirect to login UI");
                UserContext.redirectToLoginPage(this.m_req);
                break block15;
            }
            s_log.debug((Object)"This request does not require logging in");
        }
        try {
            this.m_session.loadSessionID(handler);
            return;
        }
        catch (LoginException e) {
            s_log.debug((Object)"FAIL login()", (Throwable)e);
            UserContext.redirectToLoginPage(this.m_req);
        }
    }

    public static void redirectToLoginPage(HttpServletRequest req) {
        throw new LoginSignal(req);
    }

    public static String encodeReturnURL(HttpServletRequest req) {
        StringBuffer returnURL = new StringBuffer(100);
        returnURL.append(Web.getContext().getRequestURL().getRequestURI());
        returnURL.append('?');
        Enumeration params = req.getParameterNames();
        boolean first = true;
        while (params.hasMoreElements()) {
            String key = (String)params.nextElement();
            String[] vals = req.getParameterValues(key);
            for (int i = 0; i < vals.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    returnURL.append('&');
                }
                returnURL.append(key);
                returnURL.append('=');
                returnURL.append(URLEncoder.encode(vals[i]));
            }
        }
        return URLEncoder.encode(returnURL.toString());
    }

    public void login(String username, char[] password, boolean forever) throws LoginException {
        s_log.debug((Object)"START login(username, password, forever)");
        try {
            LoginCallbackHandler handler = new LoginCallbackHandler(username, password, forever);
            LoginContext context = new LoginContext(REGISTER_LOGIN_CONTEXT, handler);
            this.clearValues();
            context.login();
            this.loadValues(context.getSubject());
            this.m_session.loadSessionID(handler);
            s_log.debug((Object)"SUCCESS login(username, password, forever)");
        }
        catch (LoginException e) {
            SecurityLogger.info("register login failed: ", e);
            throw e;
        }
    }

    private BigDecimal getUserID(Subject subject) throws LoginException {
        Iterator principals = subject.getPrincipals(class$com$arsdigita$kernel$security$PartyPrincipal == null ? (class$com$arsdigita$kernel$security$PartyPrincipal = UserContext.class$("com.arsdigita.kernel.security.PartyPrincipal")) : class$com$arsdigita$kernel$security$PartyPrincipal).iterator();
        if (!principals.hasNext()) {
            throw new FailedLoginException("no principal available after login");
        }
        return ((PartyPrincipal)principals.next()).getID();
    }

    public void logout() throws LoginException {
        s_log.debug((Object)"START logout");
        RequestCallbackHandler handler = new RequestCallbackHandler();
        LoginContext context = new LoginContext(REQUEST_LOGIN_CONTEXT, handler);
        context.logout();
        this.clearValues();
        this.m_session.loadSessionID(handler);
        s_log.debug((Object)"SUCCESS logout");
    }

    static void reportUnsupportedCallback(Callback cb) throws UnsupportedCallbackException {
        s_log.error((Object)("Unsupported callback: " + (cb == null ? null : cb.getClass().getName())));
        throw new UnsupportedCallbackException(cb);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LoginCallbackHandler
    implements CallbackHandler {
        private String m_username;
        private char[] m_password;
        private boolean m_forever;

        public LoginCallbackHandler(String username, char[] password, boolean forever) {
            this.m_username = username;
            this.m_password = password;
            this.m_forever = forever;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback cb = callbacks[i];
                if (cb instanceof HTTPRequestCallback) {
                    ((HTTPRequestCallback)cb).setRequest(UserContext.this.m_req);
                    continue;
                }
                if (cb instanceof HTTPResponseCallback) {
                    ((HTTPResponseCallback)cb).setResponse(UserContext.this.m_res);
                    continue;
                }
                if (cb instanceof LifetimeCallback) {
                    ((LifetimeCallback)cb).setForever(this.m_forever);
                    continue;
                }
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.m_username);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    ((PasswordCallback)cb).setPassword(this.m_password);
                    continue;
                }
                UserContext.reportUnsupportedCallback(cb);
            }
        }
    }

    private class RequestCallbackHandler
    implements CallbackHandler {
        String m_username = null;
        char[] m_password = null;

        public RequestCallbackHandler() {
            try {
                String auth = UserContext.this.m_req.getHeader("Authorization");
                if (auth == null || !auth.toUpperCase().startsWith("BASIC")) {
                    return;
                }
                String encoded = auth.substring(6).trim();
                byte[] decoded = new Base64().decode(encoded.getBytes("UTF-8"));
                String userpass = new String(decoded, "UTF-8");
                int colon = userpass.indexOf(58);
                if (colon < 0) {
                    return;
                }
                this.m_username = userpass.substring(0, colon);
                this.m_password = userpass.substring(colon + 1, userpass.length()).toCharArray();
            }
            catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback cb = callbacks[i];
                if (cb instanceof HTTPRequestCallback) {
                    ((HTTPRequestCallback)cb).setRequest(UserContext.this.m_req);
                    continue;
                }
                if (cb instanceof HTTPResponseCallback) {
                    ((HTTPResponseCallback)cb).setResponse(UserContext.this.m_res);
                    continue;
                }
                if (cb instanceof LifetimeCallback) {
                    ((LifetimeCallback)cb).setForever(false);
                    continue;
                }
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.m_username);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    ((PasswordCallback)cb).setPassword(this.m_password);
                    continue;
                }
                UserContext.reportUnsupportedCallback(cb);
            }
        }
    }
}

