/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.initializer.InitializationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class LoginConfig
extends Configuration {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/LoginConfig.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Map m_appConfigs = new HashMap();

    public LoginConfig(List list) throws InitializationException {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String name = this.getString(iter, "application name");
            List entries = this.getList(iter, "module configs");
            this.addAppConfig(name, entries);
        }
    }

    private void addAppConfig(String name, List entries) throws InitializationException {
        AppConfigurationEntry[] array = new AppConfigurationEntry[entries.size()];
        Iterator iter = entries.iterator();
        for (int i = 0; i < array.length; ++i) {
            List entry = this.getList(iter, "{module, flag, options...}");
            array[i] = this.loadAppConfigEntry(entry);
        }
        this.m_appConfigs.put(name, array);
    }

    private AppConfigurationEntry loadAppConfigEntry(List list) throws InitializationException {
        Iterator iter = list.iterator();
        String name = this.getString(iter, "module class name");
        AppConfigurationEntry.LoginModuleControlFlag flag = this.getFlag(this.getString(iter, "control flag"));
        HashMap options = new HashMap();
        while (iter.hasNext()) {
            this.addOption(iter, options);
        }
        return new AppConfigurationEntry(name, flag, options);
    }

    private AppConfigurationEntry.LoginModuleControlFlag getFlag(String flag) throws InitializationException {
        if (flag.equalsIgnoreCase("requisite")) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        if (flag.equalsIgnoreCase("required")) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if (flag.equalsIgnoreCase("sufficient")) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if (flag.equalsIgnoreCase("optional")) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        throw new InitializationException("Control flag must be one of \"required\", \"requisite\", \"sufficient\", or \"optional\", but got: \"" + flag + "\"");
    }

    private void addOption(Iterator iter, Map map) throws InitializationException {
        String option = this.getString(iter, "option");
        int index = option.indexOf(61);
        if (index == -1) {
            throw new InitializationException("Option must be \"key=value\", but got: \"" + option + "\"");
        }
        String key = option.substring(0, index);
        String value = option.substring(index + 1);
        map.put(key, value);
    }

    private String getString(Iterator iter, String name) throws InitializationException {
        Object temp = this.getObject(iter, name);
        if (!(temp instanceof String)) {
            throw new InitializationException("Expected String " + name + ", but got: \"" + temp + "\"");
        }
        return (String)temp;
    }

    private List getList(Iterator iter, String name) throws InitializationException {
        Object temp = this.getObject(iter, name);
        if (!(temp instanceof List)) {
            throw new InitializationException("Expected List " + name + ", but got: \"" + temp + "\"");
        }
        return (List)temp;
    }

    private Object getObject(Iterator iter, String name) throws InitializationException {
        if (!iter.hasNext()) {
            throw new InitializationException("Missing " + name);
        }
        return iter.next();
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return (AppConfigurationEntry[])this.m_appConfigs.get(name);
    }

    public void refresh() {
    }

    void addAppConfig(String name, AppConfigurationEntry[] entries) {
        this.m_appConfigs.put(name, entries);
    }
}

