/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLFinderNotFoundException;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import java.util.HashMap;
import java.util.Map;

public class URLService {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/URLService.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Map s_finders = new HashMap();

    public static String locate(OID oid) throws URLFinderNotFoundException, NoValidURLException {
        return URLService.locate(oid, null);
    }

    public static String locate(OID oid, String context) throws URLFinderNotFoundException, NoValidURLException {
        String url;
        URLFinder f = URLService.getFinder(oid.getObjectType());
        if (f == null) {
            throw new URLFinderNotFoundException("There is no URLFinder registered for data object type " + oid.getObjectType().getQualifiedName());
        }
        String string = url = context == null ? f.find(oid) : f.find(oid, context);
        if (url == null) {
            throw new NoValidURLException("The URLFinder for " + oid.getObjectType().getQualifiedName() + "produced a null URL for " + oid);
        }
        return url;
    }

    public static synchronized URLFinder registerFinder(ObjectType objectType, URLFinder finder) {
        return s_finders.put(objectType, finder);
    }

    public static synchronized URLFinder registerFinder(String objectType, URLFinder finder) {
        MetadataRoot meta = SessionManager.getMetadataRoot();
        return s_finders.put(meta.getObjectType(objectType), finder);
    }

    public static synchronized URLFinder getRegisteredFinder(ObjectType objectType) {
        return (URLFinder)s_finders.get(objectType);
    }

    public static synchronized URLFinder getRegisteredFinder(String objectType) {
        MetadataRoot meta = SessionManager.getMetadataRoot();
        return (URLFinder)s_finders.get(meta.getObjectType(objectType));
    }

    public static synchronized URLFinder getFinder(ObjectType objectType) {
        ObjectType type;
        for (type = objectType; type != null && !s_finders.containsKey(type); type = type.getSupertype()) {
        }
        return (URLFinder)s_finders.get(type);
    }

    public static synchronized URLFinder getFinder(String objectType) {
        MetadataRoot meta = SessionManager.getMetadataRoot();
        return (URLFinder)s_finders.get(meta.getObjectType(objectType));
    }
}

