/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ResourceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ResourceSetup {
    protected Logger m_logger;
    protected String m_title = null;
    protected String m_description = null;
    protected String m_typeName = null;
    protected DomainObjectInstantiator m_instantiator = null;

    public ResourceSetup(Logger logger) {
        this.m_logger = logger;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setResourceObjectType(String typeName) {
        this.m_typeName = typeName;
    }

    public void setInstantiator(DomainObjectInstantiator instantiator) {
        this.m_instantiator = instantiator;
    }

    protected void notice(String message) {
        this.m_logger.info((Object)("ResourceType '" + this.m_title + "' - " + message));
    }

    public ResourceType run() {
        this.notice("Validating setup...");
        List messages = this.validate();
        if (messages.size() > 0) {
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                this.m_logger.error((Object)((String)iter.next()));
            }
            return null;
        }
        this.notice("Done validating.");
        ResourceType resourceType = this.process();
        if (resourceType != null) {
            resourceType.save();
        }
        return resourceType;
    }

    protected List validate() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.m_title == null) {
            messages.add("Title is not set.");
        }
        if (this.m_typeName == null) {
            messages.add("ResourceObjectType is not set.");
        }
        if (this.m_instantiator == null) {
            messages.add("Instantiator is not set.");
        }
        return messages;
    }

    protected ResourceType process() {
        this.notice("Starting Resource setup...");
        ResourceType resourceType = null;
        if (!ResourceType.isInstalled(this.m_typeName)) {
            this.notice("Not installed.  Installing now...");
            this.notice("Using the following properties to perform install.");
            this.notice("  ResourceObjectType: " + this.m_typeName);
            this.notice("  Title: " + this.m_title);
            this.notice("  Description: " + this.m_description);
            this.notice("  Instantiator: " + this.m_instantiator);
            resourceType = ResourceType.createResourceType(this.m_title, this.m_typeName);
            resourceType.setDescription(this.m_description);
            this.notice("Done installing.");
        } else {
            resourceType = ResourceType.retrieveResourceTypeForResource(this.m_typeName);
        }
        DomainObjectFactory.registerInstantiator(this.m_typeName, this.m_instantiator);
        this.notice("Done setting up Resource.");
        return resourceType;
    }
}

