/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Party
extends ACSObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/Party.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private List m_emailList;
    private EmailAddress m_primaryEmail;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.Party";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Party(DataObject partyData) {
        super(partyData);
    }

    public Party() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Party(String typeName) {
        super(typeName);
    }

    public Party(ObjectType type) {
        super(type);
    }

    public Party(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static PartyCollection retrieveAllParties() {
        DataCollection c = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        return new PartyCollection(c);
    }

    public abstract String getName();

    public String getDisplayName() {
        return this.getName();
    }

    public EmailAddress getPrimaryEmail() {
        String email;
        if (this.m_primaryEmail == null && (email = (String)this.get("primaryEmail")) != null) {
            this.m_primaryEmail = new EmailAddress(email);
        }
        return this.m_primaryEmail;
    }

    public void setPrimaryEmail(EmailAddress emailAddress) {
        this.m_primaryEmail = emailAddress;
        if (emailAddress == null) {
            this.set("primaryEmail", null);
        } else {
            this.set("primaryEmail", emailAddress.getEmailAddress());
            this.addEmailAddress(emailAddress);
        }
    }

    public Iterator getEmailAddresses() {
        this.initializeEmails();
        return this.m_emailList.iterator();
    }

    public Iterator getAlternateEmails() {
        Iterator iter = this.getEmailAddresses();
        EmailAddress primaryEmail = this.getPrimaryEmail();
        if (primaryEmail == null) {
            return iter;
        }
        ArrayList alternateEmails = new ArrayList();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (primaryEmail.equals(o)) continue;
            alternateEmails.add(o);
        }
        return alternateEmails.iterator();
    }

    private void initializeEmails() {
        if (this.m_emailList == null) {
            this.m_emailList = new ArrayList();
            if (!this.isNew()) {
                DataAssociationCursor emails = this.getEmailAssociation().cursor();
                while (emails.next()) {
                    this.m_emailList.add(new EmailAddress((String)emails.get("emailAddress")));
                }
            }
        }
    }

    public void addEmailAddress(EmailAddress emailAddress) {
        this.initializeEmails();
        if (!this.m_emailList.contains(emailAddress)) {
            this.m_emailList.add(emailAddress);
            this.getEmailAssociation().add(this.makePartyEmail(emailAddress));
        }
    }

    private DataAssociation getEmailAssociation() {
        DataAssociation assoc = (DataAssociation)this.get("emailAddresses");
        return (DataAssociation)this.get("emailAddresses");
    }

    public void removeEmailAddress(EmailAddress emailAddress) {
        if (emailAddress.equals(this.getPrimaryEmail())) {
            throw new IllegalArgumentException("Cannot remove the primary email address.");
        }
        this.initializeEmails();
        this.getEmailAssociation().remove(this.makePartyEmailOID(emailAddress));
        this.m_emailList.remove(emailAddress);
    }

    private OID makePartyEmailOID(EmailAddress emailAddress) {
        OID oid = new OID("com.arsdigita.kernel.PartyEmail");
        oid.set("partyID", this.getID());
        oid.set("emailAddress", emailAddress.getEmailAddress());
        return oid;
    }

    private DataObject makePartyEmail(EmailAddress emailAddress) {
        DataObject emailData = SessionManager.getSession().create("com.arsdigita.kernel.PartyEmail");
        emailData.set("partyID", this.getID());
        emailData.set("emailAddress", emailAddress.getEmailAddress());
        return emailData;
    }

    public String getURI() {
        return (String)this.get("uri");
    }

    public void setURI(String uri) {
        this.set("uri", uri);
    }
}

