/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.URLParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.actions.RemoteServerPostListener;
import com.arsdigita.formbuilder.ui.editors.ProcessListenerForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;

public class RemoteServerPostForm
extends ProcessListenerForm {
    private static final String REMOTE_URL = "remoteURL";
    private TextField m_remoteURL;

    public RemoteServerPostForm(String name, SingleSelectionModel form, SingleSelectionModel action) {
        super(name, form, action);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_remoteURL = new TextField(new URLParameter(REMOTE_URL));
        this.m_remoteURL.setSize(50);
        this.m_remoteURL.addValidationListener(new NotNullValidationListener());
        this.m_remoteURL.addValidationListener(new StringInRangeValidationListener(1, 160));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.url")), 4);
        section.add(this.m_remoteURL);
    }

    protected PersistentProcessListener getProcessListener() {
        return new RemoteServerPostListener();
    }

    protected PersistentProcessListener getProcessListener(BigDecimal id) throws DataObjectNotFoundException {
        return new RemoteServerPostListener(id);
    }

    protected void initWidgets(FormSectionEvent e, PersistentProcessListener listener) throws FormProcessException {
        super.initWidgets(e, listener);
        RemoteServerPostListener l = (RemoteServerPostListener)listener;
        PageState state = e.getPageState();
        if (l == null) {
            this.m_remoteURL.setValue(state, "");
        } else {
            this.m_remoteURL.setValue(state, l.getRemoteURL());
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentProcessListener listener) throws FormProcessException {
        super.processWidgets(e, listener);
        RemoteServerPostListener l = (RemoteServerPostListener)listener;
        FormData data = e.getFormData();
        l.setRemoteURL((String)data.get(REMOTE_URL));
        l.save();
    }
}

