/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Date;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.util.Traversal;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.xml.Element;
import java.util.Iterator;

public class ComponentTraverse
extends Traversal {
    public static final String FORMBUILDER_FORM_DEFAULTS = "formbuilder:formDefaults";
    public static final String FORMBUILDER_FORM_DEFAULT_VALUE = "formbuilder:formDefaultValue";
    public static final String FORMBUILDER_FORM_ERROR = "formbuilder:formError";
    private final String FORMBUILDER_XML_NS = "http://www.arsdigita.com/formbuilder/1.0";
    public static final String TYPE = "type";
    public static final String PARAMETER_NAME = "parameterName";
    private PageState m_state;
    private FormData m_data;
    private Element m_parent;

    public ComponentTraverse(PageState state, FormData data, Element parent) {
        this.m_state = state;
        this.m_data = data;
        this.m_parent = parent;
    }

    public void act(Component c) {
        block8: {
            try {
                Widget w;
                block10: {
                    String modelName;
                    block9: {
                        Element value;
                        if (!(c instanceof Widget)) break block8;
                        w = (Widget)c;
                        modelName = w.getParameterModel().getName();
                        if (!(c instanceof Date)) break block9;
                        String dayVar = modelName + ".day";
                        String defaultDay = this.m_state.getRequest().getParameter(dayVar);
                        String monthVar = modelName + ".month";
                        String defaultMonth = this.m_state.getRequest().getParameter(monthVar);
                        String yearVar = modelName + ".year";
                        String defaultYear = this.m_state.getRequest().getParameter(yearVar);
                        if (defaultDay == null && defaultMonth == null && defaultYear == null) break block10;
                        Element info = this.createDefaultElement(modelName);
                        if (defaultDay != null) {
                            value = this.createDefaultValueElement(info);
                            value.addAttribute(TYPE, dayVar);
                            value.setText(defaultDay);
                        }
                        if (defaultMonth != null) {
                            value = this.createDefaultValueElement(info);
                            value.addAttribute(TYPE, monthVar);
                            value.setText(defaultMonth);
                        }
                        if (defaultYear == null) break block10;
                        value = this.createDefaultValueElement(info);
                        value.addAttribute(TYPE, yearVar);
                        value.setText(defaultYear);
                        break block10;
                    }
                    String[] defaultValues = this.m_state.getRequest().getParameterValues(modelName);
                    if (defaultValues != null) {
                        Element info = this.createDefaultElement(modelName);
                        for (int i = 0; i < defaultValues.length; ++i) {
                            Element value = this.createDefaultValueElement(info);
                            value.setText(defaultValues[i]);
                        }
                    }
                }
                if (this.m_data != null) {
                    Iterator iter = this.m_data.getErrors(w.getName());
                    while (iter.hasNext()) {
                        Element errors = this.m_parent.newChildElement(FORMBUILDER_FORM_ERROR, "http://www.arsdigita.com/formbuilder/1.0");
                        errors.addAttribute("message", (String)((GlobalizedMessage)iter.next()).localize(this.m_state.getRequest()));
                        errors.addAttribute("id", w.getName());
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private Element createDefaultElement(String modelName) {
        Element element = this.m_parent.newChildElement(FORMBUILDER_FORM_DEFAULTS, "http://www.arsdigita.com/formbuilder/1.0");
        element.addAttribute(PARAMETER_NAME, modelName);
        return element;
    }

    private Element createDefaultValueElement(Element parent) {
        return parent.newChildElement(FORMBUILDER_FORM_DEFAULT_VALUE, "http://www.arsdigita.com/formbuilder/1.0");
    }
}

