/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.AttributeMetaData;
import com.arsdigita.formbuilder.AttributeMetaDataList;
import com.arsdigita.formbuilder.AttributeMetaDataProvider;
import com.arsdigita.formbuilder.ComponentAddObserver;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.PersistentSubmit;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.ui.FormBuildingPage;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SimpleQuestionnaire
implements PersistentComponentFactory,
AttributeMetaDataProvider {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/SimpleQuestionnaire.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$formbuilder$SimpleQuestionnaire == null ? (class$com$arsdigita$formbuilder$SimpleQuestionnaire = SimpleQuestionnaire.class$("com.arsdigita.formbuilder.SimpleQuestionnaire")) : class$com$arsdigita$formbuilder$SimpleQuestionnaire).getName());
    private PersistentForm m_formFactory;
    private boolean m_isAdminEnabled = false;
    private ArrayList m_questionList = new ArrayList();
    private static String s_submitNameDefault = "submit";
    private PersistentSubmit m_submitFactory;
    private boolean m_submitFactoryChanged = false;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$SimpleQuestionnaire;

    public SimpleQuestionnaire() {
        this.m_formFactory = new PersistentForm();
        this.m_formFactory.setDomainClass(this.getClass().getName());
    }

    public SimpleQuestionnaire(String htmlName, String adminName) {
        this.m_formFactory = PersistentForm.create(htmlName);
        this.m_formFactory.setAdminName(adminName);
    }

    public SimpleQuestionnaire(BigDecimal formID) throws DataObjectNotFoundException {
        this.m_formFactory = new PersistentForm(formID);
        this.initializeComponentsFromDatabase();
    }

    public void save() {
        this.m_formFactory.save();
        this.createAndAddSubmitButton();
        if (this.m_submitFactoryChanged) {
            this.m_submitFactory.save();
        }
        this.m_submitFactoryChanged = false;
    }

    public boolean isNew() {
        return this.m_formFactory.isNew();
    }

    public void delete() {
        Iterator componentIter = this.m_formFactory.getComponents().iterator();
        this.m_formFactory.delete();
        while (componentIter.hasNext()) {
            PersistentComponentFactory componentFactory = (PersistentComponentFactory)componentIter.next();
            componentFactory.delete();
        }
    }

    public Component createComponent() {
        if (this.m_submitFactoryChanged) {
            this.m_submitFactory.save();
            this.m_submitFactoryChanged = false;
        }
        Form form = (Form)this.m_formFactory.createComponent();
        return form;
    }

    public void addQuestion(String questionText, PersistentWidget widgetFactory) {
        this.addQuestion(questionText, widgetFactory, this.getNumberOfQuestions() + 1);
    }

    public void addQuestion(String questionText, PersistentWidget widgetFactory, int position) {
        this.assertPositionInAddRange(position);
        PersistentLabel labelFactory = PersistentLabel.create(questionText);
        labelFactory.save();
        this.addQuestion(labelFactory, widgetFactory, position);
    }

    public void removeQuestion(int position) {
        this.removeQuestion(position, true);
    }

    public void moveQuestion(int atPosition, int toPosition) {
        this.assertPositionInCurrentRange(atPosition);
        this.assertPositionInCurrentRange(toPosition);
        Question question = (Question)this.m_questionList.get(atPosition - 1);
        PersistentLabel labelFactory = question.getLabelFactory();
        PersistentWidget widgetFactory = question.getWidgetFactory();
        this.removeQuestion(atPosition, false);
        this.addQuestion(labelFactory, widgetFactory, toPosition);
    }

    public PersistentLabel getQuestionLabel(int questionPosition) {
        this.assertPositionInCurrentRange(questionPosition);
        return ((Question)this.m_questionList.get(questionPosition - 1)).getLabelFactory();
    }

    public PersistentWidget getQuestionWidget(int questionPosition) {
        this.assertPositionInCurrentRange(questionPosition);
        return ((Question)this.m_questionList.get(questionPosition - 1)).getWidgetFactory();
    }

    private void removeQuestion(int position, boolean deleteComponents) {
        this.assertPositionInCurrentRange(position);
        Question question = (Question)this.m_questionList.get(position - 1);
        PersistentLabel labelFactory = question.getLabelFactory();
        PersistentWidget widgetFactory = question.getWidgetFactory();
        this.m_formFactory.removeComponent(labelFactory);
        this.m_formFactory.removeComponent(widgetFactory);
        this.m_questionList.remove(position - 1);
        if (deleteComponents) {
            labelFactory.delete();
            widgetFactory.delete();
        }
    }

    private void createAndAddSubmitButton() {
        if (this.m_submitFactory == null) {
            this.m_submitFactory = PersistentSubmit.create(s_submitNameDefault);
            this.m_submitFactory.save();
            this.m_formFactory.addComponent(this.m_submitFactory);
        }
    }

    private void initializeComponentsFromDatabase() {
        Iterator componentIter = this.m_formFactory.getComponents().iterator();
        while (componentIter.hasNext()) {
            PersistentComponentFactory factory = (PersistentComponentFactory)componentIter.next();
            if (factory instanceof PersistentSubmit) {
                this.m_submitFactory = (PersistentSubmit)factory;
                break;
            }
            PersistentLabel labelFactory = (PersistentLabel)factory;
            PersistentWidget widgetFactory = (PersistentWidget)componentIter.next();
            this.m_questionList.add(new Question(labelFactory, widgetFactory));
        }
    }

    private void addQuestion(PersistentLabel labelFactory, PersistentWidget widgetFactory, int position) {
        this.m_formFactory.addComponent(labelFactory, position * 2 - 1);
        this.m_formFactory.addComponent(widgetFactory, position * 2);
        this.m_questionList.add(position - 1, new Question(labelFactory, widgetFactory));
    }

    private void assertPositionInAddRange(int position) {
        this.assertPositionInRange(position, this.getNumberOfQuestions() + 1);
    }

    private void assertPositionInCurrentRange(int position) {
        this.assertPositionInRange(position, this.getNumberOfQuestions());
    }

    private void assertPositionInRange(int position, int upperLimit) {
        try {
            FormBuilderUtil.assertArgumentInRange(position, 1, upperLimit);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("position " + Integer.toString(position) + "provided to " + this.toString() + " is invalid" + ", should be between 1 and " + Integer.toString(upperLimit));
        }
    }

    private void removeComponentObserver() {
        this.m_formFactory.setComponentAddObserver(null);
    }

    private void addComponentObserver() {
        this.m_formFactory.setComponentAddObserver(new ComponentAddObserver(){
            private int m_questionPosition;
            private BigDecimal m_componentID;

            public void beforeAddingComponent(FormSection formSection, PersistentComponentFactory componentFactory, int componentPosition) {
                this.setQuestionPosition(componentPosition);
                if ((this.isLabel(componentPosition) || this.isSubmit(componentPosition)) && !SimpleQuestionnaire.this.listenerDictatesParameterSet()) {
                    formSection.add(this.getQuestionAddLink(componentPosition), 64);
                }
                if (this.getNumberOfQuestions() == 0 && SimpleQuestionnaire.this.listenerHasMetaData()) {
                    this.addParameterLinks(formSection);
                }
            }

            public void addingComponent(PersistentComponentFactory componentFactory, int componentPosition, Component component) {
                if (this.isLabel(componentPosition) && this.isRequired(componentPosition)) {
                    Label label = (Label)component;
                    label.setLabel(label.getGlobalizedMessage().getKey() + " (required)");
                }
            }

            public void afterAddingComponent(FormSection formSection, PersistentComponentFactory componentFactory, int componentPosition) {
                this.setQuestionPosition(componentPosition);
                this.m_componentID = componentFactory.getID();
                if (this.isWidget(componentPosition)) {
                    formSection.add(this.getEditPanel());
                    if (this.isLastWidget(componentPosition)) {
                        this.addParameterLinks(formSection);
                    }
                }
            }

            private boolean isSubmitComponent(int componentPosition) {
                return SimpleQuestionnaire.this.getNumberOfQuestions() * 2 + 1 == componentPosition;
            }

            private Link getQuestionAddLink(int componentPosition) {
                Link addLink = this.createQuestionLink("Add question here");
                addLink.setVar(FormBuildingPage.instance().m_pageMode.getName(), "add");
                return addLink;
            }

            private void addEditPanelVars(Link link) {
                link.setVar(FormBuildingPage.instance().m_widgetID.getName(), this.m_componentID.toString());
            }

            private boolean isLabel(int componentPosition) {
                if (this.isSubmit(componentPosition)) {
                    return false;
                }
                return componentPosition % 2 != 0;
            }

            private boolean isSubmit(int componentPosition) {
                return this.isLastComponent(componentPosition);
            }

            private boolean isWidget(int componentPosition) {
                return componentPosition % 2 == 0;
            }

            private boolean isLastWidget(int componentPosition) {
                return this.isWidget(componentPosition) && componentPosition == this.getNumberOfComponents() - 1;
            }

            private int getNumberOfQuestions() {
                int numberOfQuestions = SimpleQuestionnaire.this.getNumberOfQuestions();
                return numberOfQuestions;
            }

            private int getNumberOfComponents() {
                return this.getNumberOfQuestions() * 2 + 1;
            }

            private boolean isLastComponent(int componentPosition) {
                return componentPosition == this.getNumberOfQuestions() * 2 + 1;
            }

            private Link createLink(String label) {
                Link link = new Link(label, FormBuildingPage.instance().getRelativeURL());
                link.setVar(FormBuildingPage.instance().m_formID.getName(), SimpleQuestionnaire.this.getID().toString());
                return link;
            }

            private Link createQuestionLink(String label) {
                Link link = this.createLink(label);
                link.setVar(FormBuildingPage.instance().m_questionPosition.getName(), Integer.toString(this.m_questionPosition));
                return link;
            }

            private Link createEditPanelLink(String label, String pageMode) {
                Link link = this.createQuestionLink(pageMode);
                this.addEditPanelVars(link);
                link.setVar(FormBuildingPage.instance().m_pageMode.getName(), pageMode);
                return link;
            }

            private Component getEditPanel() {
                ColumnPanel editPanel = new ColumnPanel(3);
                editPanel.add(this.createEditPanelLink("edit", "edit"));
                editPanel.add(this.createEditPanelLink("move", "move"));
                editPanel.add(this.createEditPanelLink("delete", "delete"));
                return editPanel;
            }

            private void addParameterLinks(FormSection formSection) {
                Iterator parameterIter = SimpleQuestionnaire.this.getParametersWithNoQuestion().iterator();
                while (parameterIter.hasNext()) {
                    AttributeMetaData parameterMetaData = (AttributeMetaData)parameterIter.next();
                    this.addOneParameterLink(formSection, parameterMetaData.getParameterName());
                }
            }

            private void addOneParameterLink(FormSection formSection, String parameterName) {
                Link parameterLink = this.createLink("Add question for parameter " + parameterName);
                parameterLink.setVar(FormBuildingPage.instance().m_pageMode.getName(), "parameter");
                parameterLink.setVar(FormBuildingPage.instance().m_parameterName.getName(), parameterName);
                formSection.add(parameterLink);
                formSection.add(new Label(""));
                formSection.add(new Label(""));
            }

            private int getQuestionPosition(int componentPosition) {
                if (componentPosition % 2 == 0) {
                    return componentPosition / 2;
                }
                return (componentPosition + 1) / 2;
            }

            private void setQuestionPosition(int componentPosition) {
                this.m_questionPosition = this.getQuestionPosition(componentPosition);
            }

            private boolean isRequired(int componentPosition) {
                Question question = (Question)SimpleQuestionnaire.this.m_questionList.get(this.getQuestionPosition(componentPosition) - 1);
                PersistentWidget widget = question.getWidgetFactory();
                return FormBuilderUtil.isRequired(widget);
            }
        });
    }

    public String getHtmlName() {
        return this.m_formFactory.getHTMLName();
    }

    public void setHtmlName(String htmlName) {
        this.m_formFactory.setHTMLName(htmlName);
    }

    public void setAdminEnabled(boolean isAdminEnabled) {
        this.m_isAdminEnabled = isAdminEnabled;
        if (isAdminEnabled) {
            this.addComponentObserver();
            this.m_formFactory.setFormContainer(new ColumnPanel(3));
        } else {
            this.removeComponentObserver();
            this.m_formFactory.setFormContainer(new ColumnPanel(2));
        }
    }

    public int getNumberOfQuestions() {
        return this.m_questionList.size();
    }

    public void setSubmitLabel(String submitLabel) {
        this.getSubmitFactory().setButtonLabel(submitLabel);
        this.m_submitFactoryChanged = true;
    }

    private PersistentSubmit getSubmitFactory() {
        if (this.m_submitFactory == null) {
            this.createAndAddSubmitButton();
        }
        return this.m_submitFactory;
    }

    public String getSubmitLabel() {
        if (this.m_formFactory.isNew() && !this.m_submitFactoryChanged) {
            return "";
        }
        return this.getSubmitFactory().getButtonLabel();
    }

    public void setAdminName(String adminName) {
        this.m_formFactory.setAdminName(adminName);
    }

    public String getAdminName() {
        return this.m_formFactory.getAdminName();
    }

    public void setDescription(String description) {
        this.m_formFactory.setDescription(description);
    }

    public String getDescription() {
        return this.m_formFactory.getDescription();
    }

    public void addProcessListener(PersistentProcessListener processListener) {
        this.m_formFactory.addProcessListener(processListener);
    }

    public Iterator getProcessListeners() {
        return this.m_formFactory.getProcessListeners();
    }

    public void setID(BigDecimal id) {
        this.m_formFactory.setID(id);
    }

    public BigDecimal getID() {
        return this.m_formFactory.getID();
    }

    public AttributeMetaDataList getAttributeMetaData() {
        AttributeMetaDataList list = new AttributeMetaDataList();
        list.add(new AttributeMetaData("adminName", "Administration name", true));
        list.add(new AttributeMetaData("description", "Description"));
        list.add(new AttributeMetaData("htmlName", "HTML name", true));
        list.add(new AttributeMetaData("submitLabel", "Submit button label"));
        return list;
    }

    public boolean listenerDictatesParameterSet() {
        return this.listenerHasMetaData();
    }

    public boolean listenerHasMetaData() {
        AttributeMetaDataList list = this.getListenerMetaData();
        return list != null && list.size() > 0;
    }

    public AttributeMetaDataList getListenerMetaData() {
        Iterator iter = this.getProcessListeners();
        AttributeMetaDataList data = new AttributeMetaDataList();
        while (iter.hasNext()) {
            try {
                AttributeMetaDataProvider provider = (AttributeMetaDataProvider)iter.next();
                AttributeMetaDataList d = provider.getAttributeMetaData();
                while (d.hasNext()) {
                    data.add(d.next());
                }
            }
            catch (Exception exception) {
            }
        }
        return data;
    }

    private Collection getParametersWithNoQuestion() {
        ArrayList<AttributeMetaData> parameterList = new ArrayList<AttributeMetaData>();
        AttributeMetaDataList attributeList = this.getListenerMetaData();
        while (attributeList.hasNext()) {
            AttributeMetaData attributeMetaData = attributeList.next();
            String attributeName = attributeMetaData.getParameterName();
            if (attributeName == null) continue;
            Iterator questionIter = this.m_questionList.iterator();
            boolean parameterHasQuestion = false;
            while (questionIter.hasNext()) {
                Question question = (Question)questionIter.next();
                PersistentWidget widget = question.getWidgetFactory();
                if (widget.getParameterName() == null || !widget.getParameterName().equals(attributeName)) continue;
                parameterHasQuestion = true;
                break;
            }
            if (parameterHasQuestion) continue;
            parameterList.add(attributeMetaData);
        }
        return parameterList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Question {
        private PersistentLabel m_labelFactory;
        private PersistentWidget m_widgetFactory;

        public Question(PersistentLabel labelFactory, PersistentWidget widgetFactory) {
            this.m_labelFactory = labelFactory;
            this.m_widgetFactory = widgetFactory;
        }

        public PersistentLabel getLabelFactory() {
            return this.m_labelFactory;
        }

        public PersistentWidget getWidgetFactory() {
            return this.m_widgetFactory;
        }
    }
}

