/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.auditing.AuditedACSObject;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.util.Attributes;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.AttributeMetaDataList;
import com.arsdigita.formbuilder.AttributeMetaDataProvider;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.util.AttributeHelper;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public abstract class PersistentComponent
extends AuditedACSObject
implements PersistentComponentFactory,
AttributeMetaDataProvider {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentComponent.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$formbuilder$PersistentComponent == null ? (class$com$arsdigita$formbuilder$PersistentComponent = PersistentComponent.class$("com.arsdigita.formbuilder.PersistentComponent")) : class$com$arsdigita$formbuilder$PersistentComponent).getName());
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.Component";
    public static final String ATTRIBUTE_STRING = "attributeString";
    private Attributes m_attributes;
    private boolean m_attributeChanged = false;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentComponent;

    public PersistentComponent(String objectType) {
        super(objectType);
        this.set("defaultDomainClass", this.getClass().getName());
    }

    public PersistentComponent(ObjectType type) {
        super(type);
    }

    public PersistentComponent(OID oID) throws DataObjectNotFoundException {
        super(oID);
    }

    public PersistentComponent(DataObject obj) {
        super(obj);
    }

    protected void beforeSave() {
        if (this.m_attributeChanged) {
            Assert.assertNotNull(this.m_attributes, "Attribute map");
            this.set(ATTRIBUTE_STRING, AttributeHelper.getAttributeString(this.m_attributes));
            this.m_attributeChanged = false;
        }
        super.beforeSave();
    }

    public abstract Component createComponent();

    protected void setDomainClass(String domainClass) {
        this.set("defaultDomainClass", domainClass);
    }

    protected void setComponentAttribute(String name, String value) {
        if (this.m_attributes == null) {
            this.loadAttributes();
        }
        this.m_attributes.setAttribute(name, value);
        if (!this.m_attributeChanged) {
            this.m_attributeChanged = true;
            this.set(ATTRIBUTE_STRING, this.get(ATTRIBUTE_STRING));
        }
    }

    protected String getComponentAttribute(String name) {
        if (this.m_attributes == null) {
            this.loadAttributes();
        }
        return this.m_attributes.getAttribute(name);
    }

    private void loadAttributes() {
        String attrs = (String)this.get(ATTRIBUTE_STRING);
        this.m_attributes = attrs == null ? new Attributes() : new AttributeHelper().getAttributesMap((String)this.get(ATTRIBUTE_STRING));
        this.m_attributeChanged = false;
    }

    public void setAdminName(String adminName) {
        this.set("adminName", adminName);
    }

    public String getAdminName() {
        return (String)this.get("adminName");
    }

    public void setDescription(String description) {
        this.set("description", description);
    }

    public String getDescription() {
        return (String)this.get("description");
    }

    public AttributeMetaDataList getAttributeMetaData() {
        AttributeMetaDataList list = new AttributeMetaDataList();
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

