/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.domain;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectTraversalAdapter;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class DomainObjectTraversal {
    private Set m_visited = new HashSet();
    private static Map s_adapters = new HashMap();
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$domain$DomainObjectTraversal == null ? (class$com$arsdigita$domain$DomainObjectTraversal = DomainObjectTraversal.class$("com.arsdigita.domain.DomainObjectTraversal")) : class$com$arsdigita$domain$DomainObjectTraversal));
    public static final String LINK_NAME = "link";
    static /* synthetic */ Class class$com$arsdigita$domain$DomainObjectTraversal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$persistence$metadata$ObjectType;
    static /* synthetic */ Class class$com$arsdigita$domain$DomainObjectTraversalAdapter;

    public static void registerAdapter(ObjectType type, DomainObjectTraversalAdapter adapter, String context) {
        Assert.assertNotNull(adapter, "The DomainObjectTraversalAdapter is null for context '" + context + "' and object type '" + type);
        Assert.assertNotNull(type, "The ObjectType for context '" + context + "' and adapter '" + adapter + "' is null");
        Assert.exists(context, class$java$lang$String == null ? (class$java$lang$String = DomainObjectTraversal.class$("java.lang.String")) : class$java$lang$String);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Registering adapter " + adapter.getClass() + " for object type " + type.getQualifiedName() + " in context " + context));
        }
        s_adapters.put(new AdapterKey(type, context), adapter);
    }

    public static void unregisterAdapter(ObjectType type, String context) {
        Assert.exists(type, class$com$arsdigita$persistence$metadata$ObjectType == null ? (class$com$arsdigita$persistence$metadata$ObjectType = DomainObjectTraversal.class$("com.arsdigita.persistence.metadata.ObjectType")) : class$com$arsdigita$persistence$metadata$ObjectType);
        Assert.exists(context, class$java$lang$String == null ? (class$java$lang$String = DomainObjectTraversal.class$("java.lang.String")) : class$java$lang$String);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removing adapter  for object type " + type.getQualifiedName() + " in context " + context));
        }
        s_adapters.remove(new AdapterKey(type, context));
    }

    public static void registerAdapter(String type, DomainObjectTraversalAdapter adapter, String context) {
        DomainObjectTraversal.registerAdapter(SessionManager.getMetadataRoot().getObjectType(type), adapter, context);
    }

    public static void unregisterAdapter(String type, String context) {
        DomainObjectTraversal.unregisterAdapter(SessionManager.getMetadataRoot().getObjectType(type), context);
    }

    public static DomainObjectTraversalAdapter lookupAdapter(ObjectType type, String context) {
        Assert.exists(type, class$com$arsdigita$persistence$metadata$ObjectType == null ? (class$com$arsdigita$persistence$metadata$ObjectType = DomainObjectTraversal.class$("com.arsdigita.persistence.metadata.ObjectType")) : class$com$arsdigita$persistence$metadata$ObjectType);
        Assert.exists(context, class$java$lang$String == null ? (class$java$lang$String = DomainObjectTraversal.class$("java.lang.String")) : class$java$lang$String);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("lookupAdapter for type " + type.getQualifiedName() + " in context " + context));
        }
        return (DomainObjectTraversalAdapter)s_adapters.get(new AdapterKey(type, context));
    }

    public static DomainObjectTraversalAdapter findAdapter(ObjectType type, String context) {
        Assert.exists(type, class$com$arsdigita$persistence$metadata$ObjectType == null ? (class$com$arsdigita$persistence$metadata$ObjectType = DomainObjectTraversal.class$("com.arsdigita.persistence.metadata.ObjectType")) : class$com$arsdigita$persistence$metadata$ObjectType);
        Assert.exists(context, class$java$lang$String == null ? (class$java$lang$String = DomainObjectTraversal.class$("java.lang.String")) : class$java$lang$String);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("findAdapter for type " + type.getQualifiedName() + " in context " + context));
        }
        DomainObjectTraversalAdapter adapter = null;
        for (ObjectType tmpType = type; adapter == null && tmpType != null; tmpType = tmpType.getSupertype()) {
            adapter = DomainObjectTraversal.lookupAdapter(tmpType, context);
        }
        if (adapter == null) {
            s_log.warn((Object)("Could not find adapter for object type " + type.getQualifiedName() + " in context " + context));
        }
        return adapter;
    }

    public void walk(DomainObject obj, String context) {
        DomainObjectTraversalAdapter adapter = DomainObjectTraversal.findAdapter(obj.getObjectType(), context);
        if (adapter == null) {
            String errorMsg = "No adapter for object " + obj.getOID() + " in context " + context;
            s_log.error((Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        this.walk(obj, context, adapter);
    }

    protected void walk(DomainObject obj, String context, DomainObjectTraversalAdapter adapter) {
        Assert.exists(adapter, class$com$arsdigita$domain$DomainObjectTraversalAdapter == null ? (class$com$arsdigita$domain$DomainObjectTraversalAdapter = DomainObjectTraversal.class$("com.arsdigita.domain.DomainObjectTraversalAdapter")) : class$com$arsdigita$domain$DomainObjectTraversalAdapter);
        this.walk(adapter, obj, "/object", context, null);
    }

    private void walk(DomainObjectTraversalAdapter adapter, DomainObject obj, String path, String context, DomainObject linkObject) {
        OID oid = obj.getOID();
        if (this.m_visited.contains(oid)) {
            this.revisitObject(obj, path);
            return;
        }
        this.m_visited.add(oid);
        this.beginObject(obj, path);
        if (linkObject != null) {
            this.beginLink(linkObject, path);
            this.walk(adapter, linkObject, this.appendToPath(path, LINK_NAME), context, null);
            this.endLink(linkObject, path);
        }
        ObjectType type = obj.getObjectType();
        Iterator i = type.getProperties();
        while (i.hasNext()) {
            Object propValue;
            Property prop = (Property)i.next();
            String propName = prop.getName();
            if (!adapter.processProperty(obj, this.appendToPath(path, prop.getName()), prop, context) || (propValue = obj.get(propName)) == null) continue;
            if (prop.isAttribute()) {
                this.handleAttribute(obj, path, prop);
                continue;
            }
            if (propValue instanceof DataObject) {
                this.beginRole(obj, path, prop);
                this.walk(adapter, DomainObjectFactory.newInstance((DataObject)propValue), this.appendToPath(path, propName), context, null);
                this.endRole(obj, path, prop);
                continue;
            }
            if (!(propValue instanceof DataAssociation)) continue;
            this.beginAssociation(obj, path, prop);
            DataAssociationCursor daCursor = ((DataAssociation)propValue).getDataAssociationCursor();
            while (daCursor.next()) {
                DataObject link = daCursor.getLink();
                LinkDomainObject linkObj = null;
                if (link != null) {
                    linkObj = new LinkDomainObject(link);
                }
                this.walk(adapter, DomainObjectFactory.newInstance(daCursor.getDataObject()), this.appendToPath(path, propName), context, linkObj);
            }
            this.endAssociation(obj, path, prop);
        }
        this.endObject(obj, path);
    }

    protected abstract void beginObject(DomainObject var1, String var2);

    protected abstract void endObject(DomainObject var1, String var2);

    protected void beginLink(DomainObject obj, String path) {
    }

    protected void endLink(DomainObject obj, String path) {
    }

    protected abstract void revisitObject(DomainObject var1, String var2);

    protected abstract void handleAttribute(DomainObject var1, String var2, Property var3);

    protected abstract void beginRole(DomainObject var1, String var2, Property var3);

    protected abstract void endRole(DomainObject var1, String var2, Property var3);

    protected abstract void beginAssociation(DomainObject var1, String var2, Property var3);

    protected abstract void endAssociation(DomainObject var1, String var2, Property var3);

    protected String appendToPath(String path, String name) {
        if (path.endsWith("/" + name)) {
            path = path + "+";
        } else if (!path.endsWith("/" + name + "+")) {
            path = path + "/" + name;
        }
        return path;
    }

    protected String nameFromPath(String path) {
        int index = path.lastIndexOf("/");
        Assert.truth(index >= 0, "Path starts with /");
        if (path.endsWith("+")) {
            return path.substring(index + 1, path.length() - 1);
        }
        return path.substring(index + 1);
    }

    protected String parentFromPath(String path) {
        int index = path.lastIndexOf("/");
        Assert.truth(index >= 0, "Path starts with /");
        if (index == 0) {
            return null;
        }
        return path.substring(0, index - 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LinkDomainObject
    extends DomainObject {
        LinkDomainObject(DataObject object) {
            super(object);
        }
    }

    protected static class AdapterKey {
        private final ObjectType m_type;
        private final String m_context;

        public AdapterKey(ObjectType type, String context) {
            Assert.exists(type, class$com$arsdigita$persistence$metadata$ObjectType == null ? (class$com$arsdigita$persistence$metadata$ObjectType = DomainObjectTraversal.class$("com.arsdigita.persistence.metadata.ObjectType")) : class$com$arsdigita$persistence$metadata$ObjectType);
            Assert.exists(context, class$java$lang$String == null ? (class$java$lang$String = DomainObjectTraversal.class$("java.lang.String")) : class$java$lang$String);
            this.m_type = type;
            this.m_context = context;
        }

        public boolean equals(Object o) {
            if (o instanceof AdapterKey) {
                AdapterKey k = (AdapterKey)o;
                return k.m_type.equals(this.m_type) && k.m_context.equals(this.m_context);
            }
            return false;
        }

        public int hashCode() {
            return this.m_type.hashCode() + this.m_context.hashCode();
        }
    }
}

