/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dispatcher;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class InitialRequestContext
implements RequestContext {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/InitialRequestContext.java#10 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$dispatcher$InitialRequestContext == null ? (class$com$arsdigita$dispatcher$InitialRequestContext = InitialRequestContext.class$("com.arsdigita.dispatcher.InitialRequestContext")) : class$com$arsdigita$dispatcher$InitialRequestContext));
    private String m_urlSoFar;
    private String m_urlRemainder;
    private String m_originalUrl;
    private ServletContext m_sctx;
    private String m_outputType;
    private Locale m_locale;
    private boolean m_debugging;
    private boolean m_debuggingXML;
    private boolean m_debuggingXSL;
    static /* synthetic */ Class class$com$arsdigita$dispatcher$InitialRequestContext;

    protected InitialRequestContext(RequestContext that) {
        this.m_urlSoFar = that.getProcessedURLPart();
        this.m_urlRemainder = that.getRemainingURLPart();
        this.m_originalUrl = that.getOriginalURL();
        this.m_sctx = that.getServletContext();
        this.m_outputType = that.getOutputType();
        this.m_locale = that.getLocale();
        this.m_debugging = that.getDebugging();
        this.m_debuggingXML = that.getDebuggingXML();
        this.m_debuggingXSL = that.getDebuggingXSL();
    }

    public InitialRequestContext(HttpServletRequest request, ServletContext sctx) {
        this.m_sctx = sctx;
        this.initializeURLFromRequest(request, false);
        String obj = request.getParameter("outputType");
        this.m_outputType = obj != null ? obj : "text/html";
        this.m_locale = request.getLocale();
    }

    void initializeURLFromRequest(HttpServletRequest request, boolean preserveOriginalURL) {
        s_log.debug((Object)"Initializing processed and remaining URL parts.");
        String requestUrl = DispatcherHelper.getCurrentResourcePath(request);
        this.m_urlSoFar = request.getContextPath();
        this.m_urlRemainder = requestUrl;
        if (s_log.isDebugEnabled()) {
            String contextPath = request.getContextPath();
            s_log.debug((Object)("contextPath: " + contextPath));
        }
        if (s_log.isDebugEnabled()) {
            String servletPath = request.getServletPath();
            s_log.debug((Object)("servletPath: " + servletPath));
        }
        if (s_log.isDebugEnabled()) {
            String pathInfo = request.getPathInfo();
            s_log.debug((Object)("pathInfo: " + pathInfo));
        }
        String debugURL = "/debug";
        this.m_debugging = this.m_urlRemainder.startsWith("/debug");
        if (this.m_debugging) {
            this.m_urlSoFar = this.m_urlSoFar + "/debug";
            this.m_urlRemainder = this.m_urlRemainder.substring("/debug".length());
        }
        String debugURLXML = "/xml";
        this.m_debuggingXML = this.m_urlRemainder.startsWith("/xml");
        if (this.m_debuggingXML) {
            this.m_urlSoFar = this.m_urlSoFar + "/xml";
            this.m_urlRemainder = this.m_urlRemainder.substring("/xml".length());
        }
        String debugURLXSL = "/xsl";
        this.m_debuggingXSL = this.m_urlRemainder.startsWith("/xsl");
        if (this.m_debuggingXSL) {
            this.m_urlSoFar = this.m_urlSoFar + "/xsl";
            this.m_urlRemainder = this.m_urlRemainder.substring("/xsl".length());
        }
        if (!preserveOriginalURL) {
            s_log.debug((Object)"Overwriting original URL, since the caller did not ask to preserve it");
            this.m_originalUrl = this.m_urlSoFar + this.m_urlRemainder;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Set processed URL to '" + this.m_urlSoFar + "'"));
            s_log.debug((Object)("Set remaining URL to '" + this.m_urlRemainder + "'"));
        }
    }

    public String getProcessedURLPart() {
        return this.m_urlSoFar;
    }

    public String getRemainingURLPart() {
        return this.m_urlRemainder;
    }

    protected void setRemainingURLPart(String s) {
        this.m_urlRemainder = s;
    }

    protected void setProcessedURLPart(String s) {
        this.m_urlSoFar = s;
    }

    public String getOriginalURL() {
        return this.m_originalUrl;
    }

    public ServletContext getServletContext() {
        return this.m_sctx;
    }

    public String getPageBase() {
        return "/";
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getOutputType() {
        return this.m_outputType;
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }

    public boolean getDebugging() {
        return this.m_debugging;
    }

    public boolean getDebuggingXML() {
        return this.m_debuggingXML;
    }

    public boolean getDebuggingXSL() {
        return this.m_debuggingXSL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

