/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.developersupport;

import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public final class SQLDebugger {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$developersupport$SQLDebugger == null ? (class$com$arsdigita$developersupport$SQLDebugger = SQLDebugger.class$("com.arsdigita.developersupport.SQLDebugger")) : class$com$arsdigita$developersupport$SQLDebugger));
    private static final ThreadLocal s_debug = new ThreadLocal(){

        public Object initialValue() {
            return new SQLDebugger();
        }
    };
    private PrintWriter m_writer;
    static /* synthetic */ Class class$com$arsdigita$developersupport$SQLDebugger;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class class$java$lang$String;

    private SQLDebugger() {
    }

    private void setWriter(PrintWriter writer) {
        Assert.exists(writer, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = SQLDebugger.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
        this.m_writer = writer;
        this.m_writer.println("<?xml version=\"1.0\"?>");
        this.m_writer.println("<debug>");
    }

    private PrintWriter getWriter() {
        Assert.exists(this.m_writer, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = SQLDebugger.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
        return this.m_writer;
    }

    private static SQLDebugger debugger() {
        return (SQLDebugger)s_debug.get();
    }

    private static void setOutputFile(File outputFile) {
        try {
            SQLDebugger.debugger().setWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
        }
        catch (UnsupportedEncodingException ex) {
            throw new UncheckedWrapperException("This can't happen.", ex);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("Error opening '" + outputFile.getAbsolutePath() + "'", ex);
        }
    }

    public static void startNewFile(String prefix) {
        Assert.exists(prefix, class$java$lang$String == null ? (class$java$lang$String = SQLDebugger.class$("java.lang.String")) : class$java$lang$String);
        Assert.truth(prefix.length() > 2, "'" + prefix + "' is at least 3 characters long.");
        if (SQLDebugger.debugger().m_writer != null) {
            SQLDebugger.close();
        }
        try {
            File out = File.createTempFile(prefix, ".xml", SQLDebugger.getTmpDir());
            s_log.debug((Object)("starting new file: " + out.getAbsolutePath()));
            SQLDebugger.setOutputFile(out);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("Error opening a debug file prefixed with " + prefix, ex);
        }
    }

    private static File getTmpDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null || "".equals(tmpDir.trim())) {
            tmpDir = "/tmp";
        }
        File result = new File(tmpDir);
        Assert.truth(result.isDirectory(), tmpDir + " is a directory");
        return result;
    }

    public static void close() {
        SQLDebugger.println("</debug>");
        SQLDebugger.debugger().getWriter().close();
        SQLDebugger.debugger().m_writer = null;
    }

    private static void print(String str) {
        SQLDebugger.debugger().getWriter().print(str);
    }

    private static void println(String str) {
        SQLDebugger.debugger().getWriter().println(str);
    }

    private static void flush() {
        SQLDebugger.debugger().getWriter().flush();
    }

    public static void dumpTable(String debugMsg, String[] columns, String tableName) {
        SQLDebugger.dumpQuery(debugMsg, columns, SQLDebugger.makeQuery(columns, tableName));
    }

    public static void dumpQuery(String debugMsg, String[] columns, String sqlQuery) {
        try {
            int ii;
            Connection conn = SessionManager.getSession().getConnection();
            PreparedStatement st = conn.prepareStatement(sqlQuery);
            ResultSet rs = st.executeQuery();
            StringBuffer row = new StringBuffer();
            SQLDebugger.println("<queryDump>");
            SQLDebugger.println("  <message>" + debugMsg + "</message>");
            SQLDebugger.println("  <timestamp>" + new Date() + "</timestamp>");
            SQLDebugger.println("  <query>" + sqlQuery + "</query>");
            SQLDebugger.println("  <header>");
            for (ii = 0; ii < columns.length; ++ii) {
                SQLDebugger.println("    <column>" + columns[ii] + "</column>");
            }
            SQLDebugger.println("  </header>");
            while (rs.next()) {
                SQLDebugger.println("  <row>");
                for (ii = 0; ii < columns.length; ++ii) {
                    row = new StringBuffer();
                    String columnName = columns[ii];
                    row.append("    <column>");
                    row.append(rs.getObject(columnName));
                    row.append("</column>");
                    SQLDebugger.println(row.toString());
                }
                SQLDebugger.println("  </row>");
            }
            SQLDebugger.println("</queryDump>");
            SQLDebugger.flush();
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            s_log.error((Object)("debugMsg: '" + debugMsg + "', query='" + sqlQuery + "'"), (Throwable)ex);
        }
    }

    private static String makeQuery(String[] columns, String tableName) {
        StringBuffer query = new StringBuffer();
        query.append("select\n  ");
        for (int ii = 0; ii < columns.length; ++ii) {
            query.append(columns[ii]);
            if (ii >= columns.length - 1) continue;
            query.append(", ");
        }
        query.append("\nfrom ").append(tableName);
        return query.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

