/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.table;

import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultTableColumnModel
implements TableColumnModel {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/table/DefaultTableColumnModel.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String SELECTED_COLUMN = "col";
    private boolean m_locked;
    private ArrayList m_columns = new ArrayList();
    private SingleSelectionModel m_selection;

    public DefaultTableColumnModel() {
        this(new Object[0]);
    }

    public DefaultTableColumnModel(SingleSelectionModel sel) {
        this(new Object[0], sel);
    }

    public DefaultTableColumnModel(Object[] headers) {
        this(headers, new ParameterSingleSelectionModel(new IntegerParameter(SELECTED_COLUMN)));
    }

    public DefaultTableColumnModel(Object[] headers, SingleSelectionModel sel) {
        this.m_selection = sel;
        for (int i = 0; i < headers.length; ++i) {
            this.add(new TableColumn(i, headers[i], new Integer(i)));
        }
    }

    public void add(TableColumn column) {
        Assert.assertNotLocked(this);
        this.m_columns.add(column);
    }

    public void add(int columnIndex, TableColumn column) {
        Assert.assertNotLocked(this);
        this.m_columns.add(columnIndex, column);
    }

    public TableColumn get(int columnIndex) {
        return (TableColumn)this.m_columns.get(columnIndex);
    }

    public void set(int columnIndex, TableColumn v) {
        this.m_columns.set(columnIndex, v);
    }

    public int size() {
        return this.m_columns.size();
    }

    public int getIndex(Object key) {
        if (key == null) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            TableColumn t = this.get(i);
            if (!key.equals(t.getHeaderKey())) continue;
            return i;
        }
        return -1;
    }

    public Iterator columns() {
        return this.m_columns.iterator();
    }

    public void remove(TableColumn column) {
        Assert.assertNotLocked(this);
        this.m_columns.remove(column);
    }

    public final SingleSelectionModel getSelectionModel() {
        return this.m_selection;
    }

    public void setSelectionModel(SingleSelectionModel model) {
        Assert.assertNotLocked(this);
        this.m_selection = model;
    }

    public final void lock() {
        this.m_locked = true;
    }

    public final boolean isLocked() {
        return this.m_locked;
    }
}

