/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.util.Assert;

public class StringLengthValidationListener
implements ParameterListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/StringLengthValidationListener.java#9 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private final int m_maxLength;
    private final String m_errHead;
    public static final StringLengthValidationListener FOUR_K = new StringLengthValidationListener(4000);

    public StringLengthValidationListener(int maxLength) {
        Assert.truth(maxLength > 0, "Max length must be greater than 0");
        this.m_maxLength = maxLength;
        this.m_errHead = "The following strings are longer than " + maxLength + " characters: ";
    }

    public void validate(ParameterEvent e) throws FormProcessException {
        ParameterData data = e.getParameterData();
        Object obj = data.getValue();
        if (obj == null) {
            return;
        }
        boolean isValid = true;
        String value = "";
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            for (int i = 0; i < values.length && isValid; ++i) {
                value = values[i];
                isValid = this.isValid(value);
            }
        } else {
            try {
                value = (String)obj;
                isValid = this.isValid(value);
            }
            catch (ClassCastException cce) {
                throw new FormProcessException(cce.getMessage(), cce);
            }
        }
        if (!isValid) {
            StringBuffer msg = new StringBuffer(this.m_errHead);
            msg.append("'").append(value).append("' ");
            data.addError(msg.toString());
        }
    }

    private boolean isValid(String value) {
        int length = value.length();
        return length <= this.m_maxLength;
    }
}

