/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class OptionGroup
extends Widget
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/OptionGroup.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    protected String m_xmlElement;
    private ArrayList m_selected;
    private ArrayList m_options;
    private RequestLocal m_requestOptions = new RequestLocal(){

        public Object initialValue(PageState ps) {
            return new ArrayList();
        }
    };
    private static final String TOO_MANY_OPTIONS_SELECTED = "Only one option may be selected by default on this option group.";

    public final boolean isCompound() {
        return true;
    }

    protected OptionGroup(ParameterModel model) {
        super(model);
        this.m_options = new ArrayList();
        this.m_selected = new ArrayList();
    }

    public Iterator getOptions() {
        return this.m_options.iterator();
    }

    public Iterator getOptions(PageState ps) {
        ArrayList allOptions = new ArrayList();
        allOptions.addAll(this.m_options);
        ArrayList requestOptions = (ArrayList)this.m_requestOptions.get(ps);
        Iterator i = requestOptions.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (allOptions.contains(obj)) continue;
            allOptions.add(obj);
        }
        return allOptions.iterator();
    }

    public void clearOptions() {
        Assert.assertNotLocked(this);
        this.m_options = new ArrayList();
    }

    public void addOption(Option opt) {
        this.addOption(opt, null);
    }

    public void removeOption(Option opt) {
        this.removeOption(opt, null);
    }

    public void addOption(Option opt, PageState ps) {
        ArrayList list = this.m_options;
        if (ps == null) {
            Assert.assertNotLocked(this);
        } else {
            list = (ArrayList)this.m_requestOptions.get(ps);
        }
        opt.setGroup(this);
        list.add(opt);
    }

    public void removeOption(Option opt, PageState ps) {
        ArrayList list = this.m_options;
        if (ps == null) {
            Assert.assertNotLocked(this);
        } else {
            list = (ArrayList)this.m_requestOptions.get(ps);
        }
        list.remove(opt);
    }

    public void removeOption(String key) {
        this.removeOption(key, null);
    }

    public void removeOption(String key, PageState ps) {
        ArrayList list = this.m_options;
        if (ps == null) {
            Assert.assertNotLocked(this);
        } else {
            list = (ArrayList)this.m_requestOptions.get(ps);
        }
        Iterator i = list.iterator();
        Option o = null;
        while (i.hasNext()) {
            o = (Option)i.next();
            if (!o.getValue().equals(key)) continue;
            list.remove(o);
            break;
        }
    }

    public void setOptionSelected(String value) {
        Assert.assertNotLocked(this);
        if (!this.isMultiple()) {
            Assert.assertTrue(this.m_selected.size() == 0, TOO_MANY_OPTIONS_SELECTED);
            this.m_selected.add(value);
            this.getParameterModel().setDefaultValue(value);
        } else {
            this.m_selected.add(value);
            this.getParameterModel().setDefaultValue(this.m_selected.toArray());
        }
    }

    public void setOptionSelected(Option option) {
        this.setOptionSelected(option.getValue());
    }

    public Object clone() throws CloneNotSupportedException {
        OptionGroup cloned = (OptionGroup)super.clone();
        cloned.m_options = (ArrayList)this.m_options.clone();
        cloned.m_selected = (ArrayList)this.m_selected.clone();
        return cloned;
    }

    public boolean isMultiple() {
        return true;
    }
}

