/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PropertySheetModel;
import com.arsdigita.bebop.PropertySheetModelBuilder;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.bebop.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.LockableImpl;

public class PropertySheet
extends Table {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/PropertySheet.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private PropertySheetModelBuilder m_builder;
    public static final PropertySheetModel EMPTY_MODEL = new PropertySheetModel(){

        public boolean nextRow() {
            return false;
        }

        public String getLabel() {
            throw new IllegalStateException("The model is empty");
        }

        public GlobalizedMessage getGlobalizedLabel() {
            throw new IllegalStateException((String)GlobalizationUtil.globalize("bebop.the_model_is_empty").localize());
        }

        public String getValue() {
            throw new IllegalStateException("The model is empty");
        }
    };

    public PropertySheet(PropertySheetModelBuilder modelBuilder) {
        super((TableModelBuilder)new PSTMBAdapter(modelBuilder), new Object[]{"Label", "Value"});
        super.setHeader(null);
        super.getColumn(0).setCellRenderer(new GlobalizedLabelCellRenderer("b"));
        super.getColumn(1).setCellRenderer(new StringLabelCellRenderer(null));
    }

    public PropertySheet(PropertySheetModelBuilder modelBuilder, boolean valueOutputEscape) {
        super((TableModelBuilder)new PSTMBAdapter(modelBuilder), new Object[]{"Label", "Value"});
        super.setHeader(null);
        super.getColumn(0).setCellRenderer(new GlobalizedLabelCellRenderer("b"));
        super.getColumn(1).setCellRenderer(new StringLabelCellRenderer(valueOutputEscape));
    }

    public PropertySheetModelBuilder getPropertySheetModelBuilder() {
        return this.m_builder;
    }

    public static class GlobalizedLabelCellRenderer
    extends StringLabelCellRenderer {
        public GlobalizedLabelCellRenderer(String weight) {
            super(weight);
        }

        public GlobalizedLabelCellRenderer(boolean outputEscape) {
            super(outputEscape);
        }

        protected Label getLabel(Object value) {
            return new Label((GlobalizedMessage)value);
        }
    }

    public static class StringLabelCellRenderer
    implements TableCellRenderer {
        private String m_weight;
        private boolean m_outputEscape = false;

        public StringLabelCellRenderer(String weight) {
            this.m_weight = weight;
        }

        public StringLabelCellRenderer(boolean outputEscape) {
            this.m_outputEscape = outputEscape;
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Label t = this.getLabel(value);
            t.setOutputEscaping(this.m_outputEscape);
            if (this.m_weight != null) {
                t.setFontWeight(this.m_weight);
            }
            return t;
        }

        protected Label getLabel(Object value) {
            return new Label((String)value);
        }
    }

    private static class TableModelAdapter
    implements TableModel {
        private PropertySheetModel m_model;
        private int m_row;

        public TableModelAdapter(PropertySheetModel model) {
            this.m_model = model;
            this.m_row = -1;
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean nextRow() {
            ++this.m_row;
            return this.m_model.nextRow();
        }

        public Object getElementAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_model.getGlobalizedLabel();
            }
            return this.m_model.getValue();
        }

        public Object getKeyAt(int columnIndex) {
            return new Integer(this.m_row);
        }

        public PropertySheetModel getPSModel() {
            return this.m_model;
        }
    }

    private static class PSTMBAdapter
    extends LockableImpl
    implements TableModelBuilder {
        private PropertySheetModelBuilder m_builder;

        public PSTMBAdapter(PropertySheetModelBuilder b) {
            this.m_builder = b;
        }

        public TableModel makeModel(Table t, PageState s) {
            return new TableModelAdapter(this.m_builder.makeModel((PropertySheet)t, s));
        }

        public void lock() {
            this.m_builder.lock();
            super.lock();
        }
    }
}

