/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.xml.Element;
import java.util.Iterator;

public class PageErrorDisplay
extends List {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/PageErrorDisplay.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String COLOR = "color";

    public PageErrorDisplay() {
        this(new PageErrorModelBuilder());
    }

    protected PageErrorDisplay(ListModelBuilder builder) {
        super(builder);
        this.setCellRenderer(new LabelCellRenderer());
        this.setTextColor("red");
        this.setClassAttr("pageErrorDisplay");
    }

    public void setTextColor(String c) {
        this.setAttribute(COLOR, c);
    }

    public String getTextColor() {
        return this.getAttribute(COLOR);
    }

    protected boolean hasErrors(PageState state) {
        return state.getErrors().hasNext();
    }

    public void generateXML(PageState state, Element parent) {
        if (this.hasErrors(state)) {
            super.generateXML(state, parent);
        }
    }

    private static class LabelCellRenderer
    implements ListCellRenderer {
        private LabelCellRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            return new Label((GlobalizedMessage)value);
        }
    }

    protected static class StringIteratorModel
    implements ListModel {
        private Iterator m_iter;
        private GlobalizedMessage m_error;
        private int m_i;

        public StringIteratorModel(Iterator iter) {
            this.m_iter = iter;
            this.m_error = null;
            this.m_i = 0;
        }

        public boolean next() {
            if (!this.m_iter.hasNext()) {
                this.m_i = 0;
                return false;
            }
            this.m_error = (GlobalizedMessage)this.m_iter.next();
            ++this.m_i;
            return true;
        }

        private void checkState() {
            if (this.m_i == 0) {
                throw new IllegalStateException("next() has not been called succesfully");
            }
        }

        public Object getElement() {
            this.checkState();
            return this.m_error;
        }

        public String getKey() {
            this.checkState();
            return Integer.toString(this.m_i);
        }
    }

    private static class PageErrorModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        public ListModel makeModel(List l, PageState state) {
            return new StringIteratorModel(state.getErrors());
        }
    }
}

