/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocs;

public final class Hits {
    private Query query;
    private Searcher searcher;
    private Filter filter = null;
    private int length;
    private Vector hitDocs = new Vector();
    private HitDoc first;
    private HitDoc last;
    private int numDocs = 0;
    private int maxDocs = 200;

    Hits(Searcher searcher, Query query, Filter filter) throws IOException {
        this.query = query;
        this.searcher = searcher;
        this.filter = filter;
        this.getMoreDocs(50);
    }

    private final void getMoreDocs(int n) throws IOException {
        if (this.hitDocs.size() > n) {
            n = this.hitDocs.size();
        }
        int n2 = n * 2;
        TopDocs topDocs = this.searcher.search(this.query, this.filter, n2);
        this.length = topDocs.totalHits;
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        float f = 1.0f;
        if (this.length > 0 && scoreDocArray[0].score > 1.0f) {
            f = 1.0f / scoreDocArray[0].score;
        }
        int n3 = scoreDocArray.length < this.length ? scoreDocArray.length : this.length;
        int n4 = this.hitDocs.size();
        while (n4 < n3) {
            this.hitDocs.addElement(new HitDoc(scoreDocArray[n4].score * f, scoreDocArray[n4].doc));
            ++n4;
        }
    }

    public final int length() {
        return this.length;
    }

    public final Document doc(int n) throws IOException {
        HitDoc hitDoc = this.hitDoc(n);
        this.remove(hitDoc);
        this.addToFront(hitDoc);
        if (this.numDocs > this.maxDocs) {
            HitDoc hitDoc2 = this.last;
            this.remove(this.last);
            hitDoc2.doc = null;
        }
        if (hitDoc.doc == null) {
            hitDoc.doc = this.searcher.doc(hitDoc.id);
        }
        return hitDoc.doc;
    }

    public final float score(int n) throws IOException {
        return this.hitDoc((int)n).score;
    }

    private final HitDoc hitDoc(int n) throws IOException {
        if (n >= this.length) {
            throw new IndexOutOfBoundsException("Not a valid hit number: " + n);
        }
        if (n >= this.hitDocs.size()) {
            this.getMoreDocs(n);
        }
        return (HitDoc)this.hitDocs.elementAt(n);
    }

    private final void addToFront(HitDoc hitDoc) {
        if (this.first == null) {
            this.last = hitDoc;
        } else {
            this.first.prev = hitDoc;
        }
        hitDoc.next = this.first;
        this.first = hitDoc;
        hitDoc.prev = null;
        ++this.numDocs;
    }

    private final void remove(HitDoc hitDoc) {
        if (hitDoc.doc == null) {
            return;
        }
        if (hitDoc.next == null) {
            this.last = hitDoc.prev;
        } else {
            hitDoc.next.prev = hitDoc.prev;
        }
        if (hitDoc.prev == null) {
            this.first = hitDoc.next;
        } else {
            hitDoc.prev.next = hitDoc.next;
        }
        --this.numDocs;
    }
}

