/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.parser;

import jd.xml.util.XmlUtil;
import jd.xml.xpath.parser.TokenConstants;
import jd.xml.xpath.parser.XPathParseException;

public class Scanner
implements TokenConstants {
    public int token = 27;
    public String value;
    private String expression_;
    private char[] chars_;
    private int length_;
    private int position_;
    private int mark_;
    private boolean stopAtUnexpectedChar_;
    private static String[] tokenNames_ = new String[28];

    public Scanner(String string) {
        this.expression_ = string;
        this.length_ = string.length();
        this.chars_ = new char[this.length_];
        string.getChars(0, this.length_, this.chars_, 0);
        this.position_ = 0;
        this.mark_ = 0;
    }

    public void stopAtUnexpectedChar() {
        this.stopAtUnexpectedChar_ = true;
    }

    public int nextToken() throws XPathParseException {
        this.token = 27;
        this.value = null;
        this.consumeWhiteSpace();
        if (!this.hasMore()) {
            return 27;
        }
        this.markPosition();
        char c = this.nextCharacter();
        switch (c) {
            case '/': {
                this.token = this.consume('/') ? 10 : 9;
                break;
            }
            case '=': {
                this.token = 11;
                break;
            }
            case '!': {
                if (!this.consume('=')) {
                    throw this.createParseException("expected '='");
                }
                this.token = 12;
                break;
            }
            case '<': {
                this.token = this.consume('=') ? 6 : 5;
                break;
            }
            case '>': {
                this.token = this.consume('=') ? 8 : 7;
                break;
            }
            case '+': {
                this.token = 14;
                break;
            }
            case '-': {
                this.token = 15;
                break;
            }
            case ',': {
                this.token = 26;
                break;
            }
            case '|': {
                this.token = 13;
                break;
            }
            case '(': {
                this.token = 1;
                break;
            }
            case ')': {
                this.token = 2;
                break;
            }
            case '[': {
                this.token = 3;
                break;
            }
            case ']': {
                this.token = 4;
                break;
            }
            case '\"': 
            case '\'': {
                this.token = 24;
                this.value = this.consumeMatch(c);
                if (this.value != null) break;
                throw this.createParseException("expected " + c);
            }
            case '$': {
                this.token = 23;
                this.scanVariableName();
                break;
            }
            case '*': {
                this.token = 16;
                break;
            }
            case '@': {
                this.token = 18;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.consumeDigits();
                if (this.consume('.')) {
                    this.consumeDigits();
                }
                this.value = this.getMarkedString();
                this.token = 25;
                break;
            }
            case '.': {
                if (Character.isDigit(this.character())) {
                    this.consumeDigits();
                    this.value = this.getMarkedString();
                    this.token = 25;
                    break;
                }
                this.token = this.consume('.') ? 20 : 19;
                break;
            }
            default: {
                --this.position_;
                String string = this.scanNCName(this.stopAtUnexpectedChar_);
                if (string != null) {
                    if (this.consumeIgnoreWhiteSpace("::")) {
                        this.token = 21;
                        this.value = string;
                        break;
                    }
                    if (this.consume(':')) {
                        String string2 = this.consume('*') ? "*" : this.scanNCName(false);
                        string = string + ':' + string2;
                    }
                    this.token = 22;
                    this.value = string;
                    break;
                }
                this.token = 27;
            }
        }
        return this.token;
    }

    private void scanVariableName() throws XPathParseException {
        String string = this.scanNCName(false);
        if (this.consume(':')) {
            String string2 = this.scanNCName(false);
            string = string + ':' + string2;
        }
        this.value = string;
    }

    /*
     * Unable to fully structure code
     */
    private String scanNCName(boolean var1_1) throws XPathParseException {
        var2_2 = this.position_;
        this.markPosition();
        if (!this.hasMore()) {
            if (var1_1) {
                return null;
            }
            throw this.createParseException("unexpected end of input");
        }
        var3_3 = this.nextCharacter();
        if (XmlUtil.isNCNameStartChar(var3_3)) ** GOTO lbl14
        if (var1_1) {
            this.gotoPosition(var2_2);
            return null;
        }
        throw this.createParseException("illegal character '" + var3_3 + "'");
lbl-1000:
        // 1 sources

        {
            ++this.position_;
lbl14:
            // 2 sources

            ** while (this.hasMore() && XmlUtil.isNCNameChar((char)this.character()))
        }
lbl15:
        // 1 sources

        return this.getMarkedString();
    }

    public boolean matchToken(int n) {
        return this.token == n;
    }

    public boolean matchToken(int n, String string) {
        return this.token == n && Scanner.equals(this.value, string);
    }

    public boolean consumeToken(int n) throws XPathParseException {
        if (this.matchToken(n)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public boolean consumeToken(int n, String string) throws XPathParseException {
        if (this.matchToken(n, string)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public void consumeExpectedToken(int n) throws XPathParseException {
        if (!this.consumeToken(n)) {
            throw this.createExpectedException(n, null);
        }
    }

    public void consumeExpectedToken(int n, String string) throws XPathParseException {
        if (!this.consumeToken(n, string)) {
            throw this.createExpectedException(n, string);
        }
    }

    public XPathParseException createParseException(String string) {
        return new XPathParseException(this.expression_, this.position_, string);
    }

    private XPathParseException createExpectedException(int n, String string) {
        String string2 = "expected token with type '" + Scanner.getTokenName(n) + "'";
        if (string != null) {
            string2 = string2 + " and value '" + string + "'";
        }
        string2 = string2 + ", current token is " + this.getTokenString();
        return this.createParseException(string2);
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public String getTokenString() {
        String string = "Token[" + this.getTokenName();
        if (this.value != null) {
            string = string + " value=\"" + this.value + '\"';
        }
        return string + ']';
    }

    public String getTokenName() {
        return Scanner.getTokenName(this.token);
    }

    public static String getTokenName(int n) {
        if (n < 0 || n > 27) {
            n = 0;
        }
        return tokenNames_[n];
    }

    public String getExpressionString() {
        return this.expression_;
    }

    public String getRestString() {
        return this.expression_.substring(this.position_);
    }

    public int getPosition() {
        return this.position_;
    }

    private boolean consumeWhiteSpace() {
        int n = this.position_;
        while (this.position_ < this.length_) {
            switch (this.chars_[this.position_]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.position_;
                    break;
                }
                default: {
                    return n < this.position_;
                }
            }
        }
        return n < this.position_;
    }

    private boolean hasMore() {
        return this.position_ < this.length_;
    }

    private char character() {
        return this.position_ < this.length_ ? this.chars_[this.position_] : (char)'\u0000';
    }

    private char nextCharacter() {
        return this.position_ < this.length_ ? this.chars_[this.position_++] : (char)'\u0000';
    }

    private boolean consume(char c) {
        if (this.position_ < this.length_ && this.chars_[this.position_] == c) {
            ++this.position_;
            return true;
        }
        return false;
    }

    private String consumeMatch(char c) {
        int n = this.position_;
        int n2 = this.expression_.indexOf(c, this.position_);
        if (n2 < 0) {
            return null;
        }
        this.position_ = n2 + 1;
        return this.expression_.substring(n, n2);
    }

    private boolean consumeDigits() {
        int n = this.position_;
        while (this.position_ < this.length_) {
            if (!Character.isDigit(this.chars_[this.position_])) break;
            ++this.position_;
        }
        return n < this.position_;
    }

    private boolean consume(String string) {
        int n = this.position_;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            if (n >= this.length_ || this.chars_[n] != string.charAt(n2)) {
                return false;
            }
            ++n;
            ++n2;
        }
        this.position_ = n;
        return true;
    }

    private boolean consumeIgnoreWhiteSpace(String string) {
        int n = this.position_;
        this.consumeWhiteSpace();
        if (this.consume(string)) {
            return true;
        }
        this.position_ = n;
        return false;
    }

    private void markPosition() {
        this.mark_ = this.position_;
    }

    private String getMarkedString() {
        return this.expression_.substring(this.mark_, this.position_);
    }

    private void gotoPosition(int n) {
        if (n < 0 || n >= this.length_) {
            throw new IllegalArgumentException("invalid index " + n);
        }
        this.position_ = n;
    }

    public static void print(String string) throws XPathParseException {
        System.out.println();
        System.out.println("tokens of expression '" + string + "':");
        Scanner scanner = new Scanner(string);
        do {
            scanner.nextToken();
            System.out.print("- ");
            System.out.println(scanner.getTokenString());
        } while (!scanner.matchToken(27));
    }

    static {
        Scanner.tokenNames_[1] = "'('";
        Scanner.tokenNames_[2] = "')'";
        Scanner.tokenNames_[3] = "'['";
        Scanner.tokenNames_[4] = "']'";
        Scanner.tokenNames_[5] = "'<'";
        Scanner.tokenNames_[6] = "'<='";
        Scanner.tokenNames_[7] = "'>'";
        Scanner.tokenNames_[8] = "'>='";
        Scanner.tokenNames_[9] = "'/'";
        Scanner.tokenNames_[10] = "'//'";
        Scanner.tokenNames_[11] = "'='";
        Scanner.tokenNames_[12] = "'!='";
        Scanner.tokenNames_[26] = "','";
        Scanner.tokenNames_[13] = "'|'";
        Scanner.tokenNames_[14] = "'+'";
        Scanner.tokenNames_[15] = "'-'";
        Scanner.tokenNames_[16] = "'*'";
        Scanner.tokenNames_[18] = "'@'";
        Scanner.tokenNames_[19] = "'.'";
        Scanner.tokenNames_[20] = "'..'";
        Scanner.tokenNames_[21] = "AxisName";
        Scanner.tokenNames_[22] = "Name";
        Scanner.tokenNames_[23] = "VariableReference";
        Scanner.tokenNames_[24] = "Literal";
        Scanner.tokenNames_[25] = "Number";
        Scanner.tokenNames_[27] = "EndOfExpression";
        Scanner.tokenNames_[0] = "undefined";
    }
}

