/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model;

import java.io.PrintStream;

public class NamespaceContext {
    private final String prefix_;
    private String uri_;
    private NamespaceContext next_;
    private int index_ = -1;
    private int declarationId_;
    private boolean hasDeclarationId_;

    public static NamespaceContext add(String string, String string2, NamespaceContext namespaceContext) {
        if (string == null) {
            throw new IllegalArgumentException("prefix is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            return namespaceContext;
        }
        if (namespaceContext != null) {
            NamespaceContext namespaceContext2 = namespaceContext;
            while (namespaceContext2 != null) {
                if (namespaceContext2.prefix_.equals(string)) {
                    if (namespaceContext2.uri_.equals(string2)) {
                        return namespaceContext;
                    }
                    namespaceContext = NamespaceContext.copyChain(namespaceContext, namespaceContext2);
                    break;
                }
                namespaceContext2 = namespaceContext2.next_;
            }
        }
        if (string2.length() == 0) {
            if (string.length() != 0) {
                throw new IllegalArgumentException("the namespace for prefix '" + string + "' cannot be undeclared");
            }
            return namespaceContext;
        }
        return new NamespaceContext(string, string2, namespaceContext);
    }

    public static NamespaceContext remove(String string, NamespaceContext namespaceContext) {
        if (namespaceContext != null) {
            NamespaceContext namespaceContext2 = namespaceContext;
            while (namespaceContext2 != null) {
                if (namespaceContext2.prefix_.equals(string)) {
                    return NamespaceContext.copyChain(namespaceContext, namespaceContext2);
                }
                namespaceContext2 = namespaceContext2.next_;
            }
        }
        return namespaceContext;
    }

    private NamespaceContext(String string, String string2, NamespaceContext namespaceContext) {
        this.prefix_ = string;
        this.uri_ = string2;
        this.next_ = namespaceContext;
    }

    private NamespaceContext(NamespaceContext namespaceContext) {
        this.prefix_ = namespaceContext.prefix_;
        this.uri_ = namespaceContext.uri_;
        this.next_ = namespaceContext.next_;
        this.declarationId_ = namespaceContext.declarationId_;
        this.hasDeclarationId_ = namespaceContext.hasDeclarationId_;
    }

    private static NamespaceContext copyChain(NamespaceContext namespaceContext, NamespaceContext namespaceContext2) {
        NamespaceContext namespaceContext3;
        if (namespaceContext == namespaceContext2) {
            return namespaceContext.next_;
        }
        NamespaceContext namespaceContext4 = namespaceContext3 = new NamespaceContext(namespaceContext);
        NamespaceContext namespaceContext5 = namespaceContext.next();
        while (namespaceContext5 != namespaceContext2) {
            NamespaceContext namespaceContext6;
            namespaceContext4.next_ = namespaceContext6 = new NamespaceContext(namespaceContext5);
            namespaceContext4 = namespaceContext6;
            namespaceContext5 = namespaceContext5.next();
        }
        namespaceContext4.next_ = namespaceContext2.next_;
        return namespaceContext3;
    }

    public String getPrefix() {
        return this.prefix_;
    }

    public String getPrefix(String string) {
        if (this.uri_.equals(string)) {
            return this.prefix_;
        }
        if (this.next_ != null) {
            return this.next_.getPrefix(string);
        }
        return null;
    }

    public static String getPrefix(NamespaceContext namespaceContext, String string) {
        return namespaceContext == null ? null : namespaceContext.getPrefix(string);
    }

    public void setUri(String string) {
        this.uri_ = string;
    }

    public String getUri() {
        return this.uri_;
    }

    public String getUri(String string) {
        if (this.prefix_.equals(string)) {
            return this.uri_;
        }
        if (this.next_ != null) {
            return this.next_.getUri(string);
        }
        return null;
    }

    public static String getUri(NamespaceContext namespaceContext, String string) {
        String string2;
        String string3 = string2 = namespaceContext == null ? null : namespaceContext.getUri(string);
        if (string2 == null && string.equals("xml")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
        }
        return string2;
    }

    public void setDeclarationId(int n) {
        this.declarationId_ = n;
        this.hasDeclarationId_ = true;
    }

    public int getDeclarationId() {
        return this.declarationId_;
    }

    public static void setDeclarationIds(NamespaceContext namespaceContext, int n) {
        while (namespaceContext != null && !namespaceContext.hasDeclarationId_) {
            namespaceContext.setDeclarationId(n);
            namespaceContext = namespaceContext.next_;
        }
    }

    public NamespaceContext next() {
        return this.next_;
    }

    public int count() {
        return this.next_ == null ? 1 : 1 + this.next_.count();
    }

    public int getIndex() {
        return this.index_;
    }

    public void setIndex(int n) {
        this.index_ = n;
    }

    public void dump(PrintStream printStream) {
        NamespaceContext namespaceContext = this;
        do {
            printStream.println(namespaceContext);
        } while ((namespaceContext = namespaceContext.next_) != null);
    }

    public String toString() {
        return "NamespaceContext['" + this.prefix_ + "'='" + this.uri_ + "']";
    }
}

