/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.expr.visitor;

import jd.xml.xpath.VariableName;
import jd.xml.xpath.axis.Axis;
import jd.xml.xpath.axis.NodeTest;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.ExpressionVisitor;
import jd.xml.xpath.object.Equality;
import jd.xml.xpath.object.Relation;
import jd.xml.xpath.object.XObject;

public class ExprWriter
implements ExpressionVisitor {
    private boolean rootVisited_;
    private StringBuffer out_ = new StringBuffer();

    public synchronized String print(Expression expression) {
        this.out_.setLength(0);
        this.visit(expression);
        return this.out_.toString();
    }

    private void visit(Expression expression) {
        expression.accept(this);
    }

    public void add(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "+");
    }

    public void and(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "and");
    }

    public void compare(Expression expression, Expression expression2, Equality equality, Expression expression3) {
        this.operator(expression2, expression3, equality.getSymbol());
    }

    public void compare(Expression expression, Expression expression2, Relation relation, Expression expression3) {
        this.operator(expression2, expression3, relation.getSymbol());
    }

    public void composedPath(Expression expression, Expression expression2, Expression expression3) {
        this.rootVisited_ = false;
        this.visit(expression2);
        if (this.rootVisited_) {
            this.rootVisited_ = false;
        } else {
            this.out_.append('/');
        }
        this.visit(expression3);
    }

    public void composedPath(Expression expression, Expression[] expressionArray) {
        this.rootVisited_ = false;
        int n = 0;
        while (n < expressionArray.length) {
            if (n > 0) {
                if (this.rootVisited_) {
                    this.rootVisited_ = false;
                } else {
                    this.out_.append('/');
                }
            }
            this.visit(expressionArray[n]);
            ++n;
        }
    }

    public void constant(Expression expression, XObject xObject) {
        this.out_.append(xObject.toString());
    }

    public void divide(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "div");
    }

    public void function(Expression expression, String string, Expression[] expressionArray) {
        this.out_.append(string);
        this.out_.append('(');
        if (expressionArray != null) {
            int n = 0;
            while (n < expressionArray.length) {
                if (n > 0) {
                    this.out_.append(", ");
                }
                this.visit(expressionArray[n]);
                ++n;
            }
        }
        this.out_.append(')');
    }

    public void invalid(Expression expression, String string, String string2) {
        this.out_.append(string);
    }

    public void locationStep(Expression expression, Axis axis, NodeTest nodeTest) {
        this.out_.append(axis.toString());
        this.out_.append(nodeTest.toString());
    }

    public void locationStep(Expression expression, Axis axis, NodeTest nodeTest, Expression expression2, boolean bl, boolean bl2) {
        this.locationStep(null, axis, nodeTest);
        this.out_.append('[');
        this.visit(expression2);
        this.out_.append(']');
    }

    public void modulo(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "mod");
    }

    public void multiply(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "*");
    }

    public void negate(Expression expression, Expression expression2) {
        this.out_.append("-");
        this.visit(expression2);
    }

    private void operator(Expression expression, Expression expression2, String string) {
        this.visit(expression);
        this.out_.append(' ');
        this.out_.append(string);
        this.out_.append(' ');
        this.visit(expression2);
    }

    public void or(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "or");
    }

    public void parenthesis(Expression expression, Expression expression2) {
        this.out_.append('(');
        this.visit(expression2);
        this.out_.append(')');
    }

    public void predicate(Expression expression, Expression expression2, Expression expression3, boolean bl) {
        this.visit(expression2);
        this.out_.append('[');
        this.visit(expression3);
        this.out_.append(']');
    }

    public void root(Expression expression) {
        this.out_.append('/');
        this.rootVisited_ = true;
    }

    public void subtract(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "-");
    }

    public void union(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "|");
    }

    public void variableReference(Expression expression, VariableName variableName) {
        this.out_.append("$");
        this.out_.append(variableName.getName());
    }
}

