/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl;

import com.arsdigita.util.UncheckedWrapperException;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.JoinFrom;
import com.redhat.persistence.metadata.JoinThrough;
import com.redhat.persistence.metadata.JoinTo;
import com.redhat.persistence.metadata.Mapping;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.Static;
import com.redhat.persistence.metadata.UniqueKey;
import com.redhat.persistence.metadata.Value;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class PDLWriter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/pdl/PDLWriter.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Writer m_out;

    public PDLWriter(Writer out) {
        this.m_out = out;
    }

    private void write(String str) {
        try {
            this.m_out.write(str);
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    public void write(ObjectType type) {
        this.write("object type ");
        this.write(type.getName());
        if (type.getSupertype() != null) {
            this.write(" extends ");
            this.write(type.getSupertype().getQualifiedName());
        }
        if (type.getJavaClass() != null) {
            this.write(" class ");
            this.write(type.getJavaClass().getName());
        }
        this.write(" {");
        Iterator it = type.getDeclaredProperties().iterator();
        while (it.hasNext()) {
            Role rev;
            Role role;
            Property prop = (Property)it.next();
            if (!(prop instanceof Role) || (role = (Role)prop).getName().startsWith("~") || (rev = role.getReverse()) != null && !rev.getName().startsWith("~")) continue;
            this.write("\n");
            this.write(prop);
        }
        ObjectMap om = null;
        Root root = type.getRoot();
        if (root != null) {
            om = root.getObjectMap(type);
        }
        if (type.getSupertype() == null && type.isKeyed()) {
            this.write("\n\n    object key (");
            Iterator it2 = type.getKeyProperties().iterator();
            while (it2.hasNext()) {
                Property prop = (Property)it2.next();
                this.write(prop.getName());
                if (!it2.hasNext()) continue;
                this.write(", ");
            }
            this.write(");");
        } else if (om != null && om.getTable() != null) {
            this.write("\n\n    reference key (");
            UniqueKey uk = om.getTable().getPrimaryKey();
            this.write(uk.getColumns());
            this.write(");");
        }
        this.write("\n}");
    }

    private void write(Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            this.write(cols[i]);
            if (i >= cols.length - 1) continue;
            this.write(", ");
        }
    }

    private void write(Column col) {
        this.write(col.getTable().getName());
        this.write(".");
        this.write(col.getName());
    }

    private void write(Property prop) {
        this.write("    ");
        if (prop.isComponent()) {
            this.write("component ");
        } else if (prop.isComposite()) {
            this.write("composite ");
        }
        ObjectType type = prop.getType();
        if (type.getModel() == null || type.getModel().getName().equals("global")) {
            this.write(type.getName());
        } else {
            this.write(type.getQualifiedName());
        }
        if (prop.isCollection()) {
            this.write("[0..n] ");
        } else if (prop.isNullable()) {
            this.write("[0..1] ");
        } else {
            this.write("[1..1] ");
        }
        this.write(prop.getName());
        this.write(" = ");
        ObjectMap om = null;
        Root root = prop.getRoot();
        if (root != null) {
            om = root.getObjectMap(prop.getContainer());
        }
        Mapping m = null;
        if (om != null) {
            m = om.getMapping(Path.get(prop.getName()));
        }
        if (m == null) {
            this.write("<no mapping for " + prop.getName() + " in " + prop.getContainer().getName() + ">");
        } else {
            m.dispatch(new Mapping.Switch(){

                public void onValue(Value v) {
                    Column col = v.getColumn();
                    PDLWriter.this.write(col);
                    PDLWriter.this.write(" ");
                    PDLWriter.this.write(Column.getTypeName(col.getType()));
                    if (col.getSize() >= 0) {
                        PDLWriter.this.write("(" + col.getSize());
                        if (col.getScale() >= 0) {
                            PDLWriter.this.write(", " + col.getScale());
                        }
                        PDLWriter.this.write(")");
                    }
                }

                public void onJoinTo(JoinTo j) {
                    PDLWriter.this.write("join ");
                    PDLWriter.this.write(j.getKey().getColumns());
                    PDLWriter.this.write(" to ");
                    PDLWriter.this.write(j.getKey().getUniqueKey().getColumns());
                }

                public void onJoinFrom(JoinFrom j) {
                    PDLWriter.this.write("join ");
                    PDLWriter.this.write(j.getKey().getUniqueKey().getColumns());
                    PDLWriter.this.write(" to ");
                    PDLWriter.this.write(j.getKey().getColumns());
                }

                public void onJoinThrough(JoinThrough j) {
                    PDLWriter.this.write("join ");
                    PDLWriter.this.write(j.getFrom().getUniqueKey().getColumns());
                    PDLWriter.this.write(" to ");
                    PDLWriter.this.write(j.getFrom().getColumns());
                    PDLWriter.this.write(", join ");
                    PDLWriter.this.write(j.getTo().getColumns());
                    PDLWriter.this.write(" to ");
                    PDLWriter.this.write(j.getTo().getUniqueKey().getColumns());
                }

                public void onStatic(Static s) {
                    PDLWriter.this.write("<static>");
                }
            });
        }
        this.write(";");
    }

    public void writeAssociation(Property prop) {
        Role role = (Role)prop;
        Role rev = role.getReverse();
        if (rev == null) {
            throw new IllegalArgumentException("not a two way");
        }
        this.write("association {\n");
        this.write(role);
        this.write("\n");
        this.write(rev);
        this.write("\n}");
    }
}

