/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.ProtoException;
import com.redhat.persistence.common.CompoundKey;
import com.redhat.persistence.common.ParseException;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.common.SQL;
import com.redhat.persistence.common.SQLParser;
import com.redhat.persistence.common.SQLToken;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.oql.All;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.Get;
import com.redhat.persistence.oql.Literal;
import com.redhat.persistence.oql.QFrame;
import com.redhat.persistence.oql.Variable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Static
extends Expression {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/Static.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private SQL m_sql;
    private String[] m_columns;
    private boolean m_map;
    private Map m_bindings;
    private Expression m_scope;
    private List m_expressions = new ArrayList();
    private static final Collection s_functions = new HashSet();
    private static ThreadLocal s_parsers;

    private static final boolean isAllowedFunction(String s) {
        return s_functions.contains(s);
    }

    public Static(String sql) {
        this(sql, Collections.EMPTY_MAP);
    }

    public Static(String sql, Map bindings) {
        this(Static.parse(sql), null, true, bindings);
    }

    public Static(SQL sql, String[] columns, boolean map, Map bindings) {
        this(sql, columns, map, bindings, null);
    }

    /*
     * WARNING - void declaration
     */
    public Static(SQL sql, String[] columns, boolean map, Map bindings, Expression scope) {
        this.m_sql = sql;
        this.m_columns = columns;
        this.m_map = map;
        this.m_bindings = bindings;
        this.m_scope = scope == null ? this : scope;
        int size = Static.size(this.m_sql);
        for (SQLToken t = this.m_sql.getFirst(); t != null; t = t.getNext()) {
            void var9_9;
            Expression e;
            if (!Static.isExpression(t)) continue;
            String image = t.getImage();
            if (t.isBind()) {
                e = this.bind(image);
            } else if (t.isPath()) {
                All all = new All(image, this.m_bindings, this.m_scope, size != 1);
                e = Static.isAllowedFunction(image) || !this.m_map ? new Choice(all, image) : new Choice(all, this.path(image));
            } else {
                throw new IllegalStateException("don't know how to deal with token: " + t);
            }
            this.m_expressions.add(var9_9);
        }
    }

    private static boolean isExpression(SQLToken tok) {
        return tok.isBind() || tok.isPath();
    }

    private static SQL parse(String sql) {
        SQLParser p = (SQLParser)s_parsers.get();
        p.initialize(new StringReader(sql));
        try {
            p.sql();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return p.getSQL();
    }

    private Expression bind(String image) {
        return this.expression(Path.get(image), true);
    }

    private Expression path(String image) {
        return this.expression(Path.get(image), false);
    }

    private Expression expression(Path path, boolean isBind) {
        if (path.getParent() == null) {
            String name = path.getName();
            if (isBind) {
                final String key = name.substring(1);
                if (this.m_bindings.containsKey(key)) {
                    return new Literal(this.m_bindings.get(key)){

                        Object getBindKey(Generator gen) {
                            return new CompoundKey(gen.id(Static.this.m_scope), key);
                        }
                    };
                }
                throw new ProtoException("no " + key + " in " + this.m_bindings, false){};
            }
            return new Variable(name);
        }
        return new Get(this.expression(path.getParent(), isBind), path.getName());
    }

    private static int size(SQL sql) {
        int size = 0;
        block0: for (SQLToken t = sql.getFirst(); t != null; t = t.getNext()) {
            String image = t.getImage();
            for (int i = 0; i < image.length(); ++i) {
                if (Character.isWhitespace(image.charAt(i))) continue;
                ++size;
                continue block0;
            }
        }
        return size;
    }

    protected ObjectType getType() {
        return null;
    }

    protected boolean hasType() {
        return false;
    }

    void frame(Generator gen) {
        Expression e;
        boolean bool = gen.isBoolean(this) && this.m_expressions.size() == 1;
        Iterator it = this.m_expressions.iterator();
        while (it.hasNext()) {
            Expression e2 = (Expression)it.next();
            if (bool) {
                gen.addBoolean(e2);
            }
            e2.frame(gen);
            gen.addUses(this, gen.getUses(e2));
        }
        if (this.hasType()) {
            ObjectType type = this.getType();
            QFrame frame = gen.frame(this, type);
            frame.setValues(this.m_columns);
            frame.setTable(this);
        } else if (!gen.isBoolean(this) && this.m_expressions.size() == 1 && Static.size(this.m_sql) == 1 && gen.hasFrame(e = (Expression)this.m_expressions.get(0))) {
            QFrame child = gen.getFrame(e);
            QFrame frame = gen.frame(this, child.getType());
            frame.addChild(child);
            frame.setValues(child.getValues());
            frame.setMappings(child.getMappings());
        }
    }

    Code emit(Generator gen) {
        if (!this.hasType() && gen.hasFrame(this)) {
            return gen.getFrame(this).emit();
        }
        Code result = new Code();
        int index = 0;
        if (this.hasType()) {
            result = result.add("(");
        }
        for (SQLToken t = this.m_sql.getFirst(); t != null; t = t.getNext()) {
            if (Static.isExpression(t)) {
                Expression e = (Expression)this.m_expressions.get(index++);
                result = result.add(e.emit(gen));
                continue;
            }
            if (t.isRaw()) {
                String raw = t.getImage();
                result = result.add(raw.substring(4, raw.length() - 1));
                continue;
            }
            result = result.add(t.getImage());
        }
        if (this.hasType()) {
            result = result.add(")");
        }
        return result;
    }

    void hash(Generator gen) {
        gen.hash(this.m_sql);
        if (this.m_columns != null) {
            for (int i = 0; i < this.m_columns.length; ++i) {
                gen.hash(this.m_columns[i]);
            }
        }
        ArrayList keys = new ArrayList(this.m_bindings.keySet());
        Collections.sort(keys);
        Object id = gen.id(this);
        ArrayList vals = new ArrayList();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = this.m_bindings.get(key);
            vals.clear();
            Literal.convert(value, vals, gen.getRoot(), new CompoundKey(id, key));
            gen.hash(key);
            for (int j = 0; j < vals.size(); ++j) {
                Code c = (Code)vals.get(j);
                gen.hash(c.getSQL());
                gen.bind(c);
            }
        }
        gen.hash(this.m_map);
        gen.hash(this.getClass());
    }

    public String toString() {
        return "sql {" + this.m_sql + "}";
    }

    String summary() {
        return this.toString();
    }

    static {
        String[] functions2 = new String[]{"current_date", "current_timestamp", "upper", "lower", "trim", "substr", "length", "nvl"};
        for (int i = 0; i < functions2.length; ++i) {
            s_functions.add(functions2[i]);
        }
        s_parsers = new ThreadLocal(){

            protected Object initialValue() {
                return new SQLParser(new StringReader(""));
            }
        };
    }

    private class Choice
    extends Expression {
        private All m_all;
        private Expression m_expression;
        private String m_image;

        Choice(All all, Expression alternative) {
            this.m_all = all;
            this.m_expression = alternative;
        }

        Choice(All all, String alternative) {
            this.m_all = all;
            this.m_image = alternative;
        }

        void frame(Generator gen) {
            QFrame child = null;
            if (gen.hasType(this.m_all.getType())) {
                if (gen.isBoolean(this)) {
                    gen.addBoolean(this.m_all);
                }
                this.m_all.frame(gen);
                if (gen.hasFrame(this.m_all)) {
                    child = gen.getFrame(this.m_all);
                    gen.addUses(this, gen.getUses(this.m_all));
                }
            } else if (this.m_expression != null) {
                if (gen.isBoolean(this)) {
                    gen.addBoolean(this.m_expression);
                }
                this.m_expression.frame(gen);
                if (gen.hasFrame(this.m_expression)) {
                    child = gen.getFrame(this.m_expression);
                }
                gen.addUses(this, gen.getUses(this.m_expression));
            }
            if (child != null) {
                QFrame frame = gen.frame(this, child.getType());
                frame.addChild(child);
                frame.setValues(child.getValues());
                frame.setMappings(child.getMappings());
            }
        }

        Code emit(Generator gen) {
            if (gen.hasFrame(this)) {
                return gen.getFrame(this).emit();
            }
            if (gen.hasType(this.m_all.getType())) {
                return this.m_all.emit(gen);
            }
            if (this.m_expression != null) {
                return this.m_expression.emit(gen);
            }
            return new Code(this.m_image);
        }

        void hash(Generator gen) {
            throw new UnsupportedOperationException();
        }

        String summary() {
            return this.toString();
        }
    }
}

