/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.common.SQL;
import com.redhat.persistence.common.SQLToken;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.EquiSet;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.MultiMap;
import com.redhat.persistence.oql.QFrame;
import com.redhat.persistence.oql.QValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.primitives.ArrayCharList;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharList;
import org.apache.log4j.Logger;

class Generator {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/Generator.java#10 $ by $Author: mbooth $, $DateTime: 2004/05/28 09:51:17 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$oql$Generator == null ? (class$com$redhat$persistence$oql$Generator = Generator.class$("com.redhat.persistence.oql.Generator")) : class$com$redhat$persistence$oql$Generator));
    private List m_framepool = new ArrayList();
    private Map m_queries = new HashMap();
    private LinkedList m_stack = new LinkedList();
    private Set m_boolean = new HashSet();
    private MultiMap m_equalities = new MultiMap();
    private Set m_sufficient = new HashSet();
    private MultiMap m_uses = new MultiMap();
    private MultiMap m_null = new MultiMap();
    private MultiMap m_nonnull = new MultiMap();
    private Map m_substitutions = new HashMap();
    private EquiSet m_sharedframes = new EquiSet(this);
    private CharList m_hash = new ArrayCharList();
    private int m_hashCode = 0;
    private Map m_bindings = new HashMap();
    private Map m_ids = new HashMap();
    private Key m_key = new Key(this.m_hash, this.m_hashCode);
    int level = 0;
    private Root m_root;
    private List m_frames;
    private static final char TERMINAL = '\u0000';
    private Set m_ccolumns = new HashSet();
    private Set m_cframes = new HashSet();
    private List m_cconds = new ArrayList();
    static /* synthetic */ Class class$com$redhat$persistence$oql$Generator;

    Generator() {
    }

    void init(Root root) {
        this.m_root = root;
        this.m_frames = this.m_framepool.subList(0, 0);
        this.m_queries.clear();
        this.m_stack.clear();
        this.m_boolean.clear();
        this.m_equalities.clear();
        this.m_sufficient.clear();
        this.m_uses.clear();
        this.m_null.clear();
        this.m_nonnull.clear();
        this.m_substitutions.clear();
        this.m_sharedframes.clear();
        this.m_hash.clear();
        this.m_hashCode = 0;
        this.m_bindings.clear();
        this.m_ids.clear();
        this.level = 0;
    }

    Root getRoot() {
        return this.m_root;
    }

    CharList getHash() {
        return this.m_hash;
    }

    int getHashCode() {
        return this.m_hashCode;
    }

    Object getLookupKey() {
        this.m_key.setCode(this.m_hashCode);
        return this.m_key;
    }

    Object getStoreKey() {
        return new Key((CharList)new ArrayCharList((CharCollection)this.m_hash), this.m_hashCode);
    }

    Map getBindings() {
        return this.m_bindings;
    }

    private void appendHash(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.appendHash(str.charAt(i));
        }
    }

    private void appendHash(char c) {
        if (c == '\u0000') {
            this.m_hash.add('\u0000');
        }
        this.m_hashCode *= 31;
        this.m_hashCode += c;
        this.m_hash.add(c);
    }

    private void terminal() {
        this.m_hash.add('\u0000');
    }

    void hash(Class klass) {
        this.appendHash(klass.getName());
        this.terminal();
    }

    void hash(String str) {
        this.appendHash("s");
        this.appendHash(str);
        this.terminal();
    }

    void hash(ObjectType type) {
        this.appendHash("t");
        this.appendHash(Integer.toString(System.identityHashCode(type.getRoot())));
        this.terminal();
        this.appendHash(type.getQualifiedName());
        this.terminal();
    }

    void hash(boolean b) {
        this.appendHash("b");
        if (b) {
            this.appendHash("1");
        } else {
            this.appendHash("0");
        }
        this.terminal();
    }

    void hash(int i) {
        this.appendHash("i");
        this.appendHash(Integer.toString(i));
        this.terminal();
    }

    void hash(SQL sql) {
        this.appendHash("S");
        for (SQLToken t = sql.getFirst(); t != null; t = t.getNext()) {
            this.appendHash(t.getImage());
        }
        this.terminal();
    }

    Object id(Expression expr) {
        Object id = this.m_ids.get(expr);
        if (id == null) {
            id = new Integer(this.m_ids.size());
            this.m_ids.put(expr, id);
        }
        return id;
    }

    void bind(Code code) {
        List bindings = code.getBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            Code.Binding b = (Code.Binding)bindings.get(i);
            this.setBinding(b.getKey(), b.getValue());
        }
    }

    void setBinding(Object key, Object value) {
        this.m_bindings.put(key, value);
    }

    Object getBinding(Object key) {
        return this.m_bindings.get(key);
    }

    List getFrames() {
        return this.m_frames;
    }

    QFrame frame(Expression expr, ObjectType type) {
        int size = this.m_frames.size();
        if (size == this.m_framepool.size()) {
            this.m_framepool.add(new QFrame(this));
        }
        this.m_frames = this.m_framepool.subList(0, size + 1);
        QFrame result = (QFrame)this.m_frames.get(size);
        result.init(expr, type, this.peek());
        this.m_queries.put(expr, result);
        return result;
    }

    QFrame getFrame(Expression e) {
        QFrame result = (QFrame)this.m_queries.get(e);
        if (result == null) {
            throw new IllegalStateException("no qframe for expression: " + e);
        }
        return result;
    }

    boolean hasFrame(Expression e) {
        return this.m_queries.containsKey(e);
    }

    void push(QFrame frame) {
        this.m_stack.addFirst(frame);
    }

    QFrame peek() {
        if (this.m_stack.isEmpty()) {
            return null;
        }
        return (QFrame)this.m_stack.getFirst();
    }

    QFrame pop() {
        return (QFrame)this.m_stack.removeFirst();
    }

    QFrame resolve(String name) {
        Iterator it = this.m_stack.iterator();
        while (it.hasNext()) {
            QFrame frame = (QFrame)it.next();
            if (!frame.getType().hasProperty(name)) continue;
            return frame;
        }
        throw new IllegalArgumentException("unable to resolve variable: " + name + "\n" + this.getTrace());
    }

    String getTrace() {
        StringBuffer result = new StringBuffer();
        Iterator it = this.m_stack.iterator();
        while (it.hasNext()) {
            QFrame frame = (QFrame)it.next();
            result.append(frame.getType());
            if (!it.hasNext()) continue;
            result.append("  \n");
        }
        return result.toString();
    }

    boolean hasType(String name) {
        return this.m_root.getObjectType(name) != null;
    }

    ObjectType getType(String name) {
        ObjectType result = this.m_root.getObjectType(name);
        if (result == null) {
            throw new IllegalArgumentException("unable to resolve type: " + name);
        }
        return result;
    }

    void addBoolean(Expression expr) {
        this.m_boolean.add(expr);
    }

    boolean isBoolean(Expression expr) {
        return this.m_boolean.contains(expr);
    }

    List getEqualities(Expression expr) {
        return this.m_equalities.get(expr);
    }

    void addEquality(Expression expr, QValue a, QValue b) {
        this.m_equalities.add(expr, new Equality(a, b));
    }

    void addEqualities(Expression expr, List equalities) {
        this.m_equalities.addAll(expr, equalities);
    }

    boolean isSufficient(Expression expr) {
        return this.m_sufficient.contains(expr);
    }

    void addSufficient(Expression expr) {
        this.m_sufficient.add(expr);
    }

    List getUses(Expression expr) {
        return this.m_uses.get(expr);
    }

    void addUse(Expression expr, QValue v) {
        this.m_uses.add(expr, v);
    }

    void addUses(Expression expr, List values) {
        this.m_uses.addAll(expr, values);
    }

    List getNull(Expression expr) {
        return this.m_null.get(expr);
    }

    void addNull(Expression expr, QValue v) {
        this.m_null.add(expr, v);
    }

    void addNulls(Expression expr, List values) {
        this.m_null.addAll(expr, values);
    }

    List getNonNull(Expression expr) {
        return this.m_nonnull.get(expr);
    }

    void addNonNull(Expression expr, QValue v) {
        this.m_nonnull.add(expr, v);
    }

    void addNonNulls(Expression expr, List values) {
        this.m_nonnull.addAll(expr, values);
    }

    void setSubstitute(Expression expr, Expression substitute) {
        this.m_substitutions.put(expr, substitute);
    }

    Expression getSubstitute(Expression expr) {
        return (Expression)this.m_substitutions.get(expr);
    }

    EquiSet getSharedFrames() {
        return this.m_sharedframes;
    }

    QFrame getConstraining(QFrame frame) {
        this.m_cconds.clear();
        this.m_ccolumns.clear();
        this.m_cframes.clear();
        frame.addConditions(this.m_cconds);
        for (int i = 0; i < this.m_cconds.size(); ++i) {
            Expression e = (Expression)this.m_cconds.get(i);
            this.addConstraining(e, frame, this.m_ccolumns, this.m_cframes);
        }
        if (this.m_ccolumns.isEmpty() || !frame.isConstrained(this.m_ccolumns)) {
            return null;
        }
        return frame.getContainer();
    }

    private void addConstraining(Expression e, QFrame frame, Set columns, Set frames) {
        List equalities = this.getEqualities(e);
        for (int i = 0; i < equalities.size(); ++i) {
            QFrame ext;
            Equality eq = (Equality)equalities.get(i);
            QValue external = eq.getExternal(frame);
            if (external == null || (ext = external.getFrame()).getRoot().equals(frame.getRoot()) || frame.isSubframe(ext)) continue;
            QValue other = eq.getOther(external);
            columns.add(other.getColumn());
            frames.add(ext);
        }
    }

    boolean isConstrained(String table, Collection columns) {
        Table t = this.m_root.getTable(table);
        if (t == null) {
            return false;
        }
        Iterator it = t.getConstraints().iterator();
        block0: while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof UniqueKey)) continue;
            UniqueKey key = (UniqueKey)o;
            Column[] cols = key.getColumns();
            for (int i = 0; i < cols.length; ++i) {
                if (!columns.contains(cols[i].getName())) continue block0;
            }
            return true;
        }
        return false;
    }

    void equate(EquiSet equiset, Expression e) {
        List eqs = this.getEqualities(e);
        for (int i = 0; i < eqs.size(); ++i) {
            Equality eq = (Equality)eqs.get(i);
            equiset.equate(eq.getLeft(), eq.getRight());
        }
    }

    void split(QFrame frame, List equalities, List from, List to) {
        for (int i = 0; i < equalities.size(); ++i) {
            Equality eq = (Equality)equalities.get(i);
            QValue left = eq.getLeft();
            QValue right = eq.getRight();
            if (frame.contains(left) && frame.contains(right)) continue;
            if (frame.contains(left)) {
                from.add(left);
                to.add(right);
                continue;
            }
            if (!frame.contains(right)) continue;
            from.add(right);
            to.add(left);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Equality {
        private QValue m_left;
        private QValue m_right;

        Equality(QValue left, QValue right) {
            this.m_left = left;
            this.m_right = right;
        }

        QValue getLeft() {
            return this.m_left;
        }

        QValue getRight() {
            return this.m_right;
        }

        QValue getValue(QFrame frame) {
            if (this.m_left.getFrame().equals(frame)) {
                return this.m_left;
            }
            if (this.m_right.getFrame().equals(frame)) {
                return this.m_right;
            }
            return null;
        }

        QValue getExternal(QFrame frame) {
            QFrame root = frame.getRoot();
            if (this.m_left.getFrame().getRoot().equals(root)) {
                if (this.m_right.getFrame().getRoot().equals(root)) {
                    return null;
                }
                return this.m_right;
            }
            return this.m_left;
        }

        QValue getOther(QValue value) {
            if (this.m_left.equals(value)) {
                return this.m_right;
            }
            return this.m_left;
        }

        public String toString() {
            return "<equality " + this.m_left + " = " + this.m_right + ">";
        }
    }

    private static final class Key {
        private CharList m_hash;
        private int m_code;

        Key(CharList hash, int code) {
            this.m_hash = hash;
            this.m_code = code;
        }

        void setCode(int code) {
            this.m_code = code;
        }

        public int hashCode() {
            return this.m_code;
        }

        public boolean equals(Object o) {
            Key k = (Key)o;
            if (this.m_code != k.m_code) {
                return false;
            }
            return this.m_hash.equals(k.m_hash);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("{code: ").append(this.m_code);
            buf.append(";hash: ").append(this.m_hash.toString()).append('}');
            return buf.toString();
        }
    }
}

