/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.metadata.Alias;
import com.redhat.persistence.metadata.Link;
import com.redhat.persistence.metadata.Model;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Filter;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.LeftJoin;
import com.redhat.persistence.oql.QFrame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractJoin
extends Expression {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/AbstractJoin.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Expression m_left;
    private Expression m_right;

    AbstractJoin(Expression left, Expression right) {
        this.m_left = left;
        this.m_right = right;
    }

    AbstractJoin(Expression left, Expression right, Expression condition) {
        this(left, new Filter(right, condition));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void frame(Generator gen) {
        this.m_left.frame(gen);
        QFrame left = gen.getFrame(this.m_left);
        gen.push(left);
        try {
            this.m_right.frame(gen);
        }
        finally {
            gen.pop();
        }
        QFrame right = gen.getFrame(this.m_right);
        if (this instanceof LeftJoin) {
            right.setOuter(true);
        }
        QFrame frame = gen.frame(this, AbstractJoin.join(left.getType(), right.getType()));
        frame.addChild(left);
        frame.addChild(right);
        ArrayList values = new ArrayList();
        values.addAll(left.getValues());
        values.addAll(right.getValues());
        frame.setValues(values);
        frame.addMappings(left.getMappings());
        frame.addMappings(right.getMappings());
        gen.addUses(this, gen.getUses(this.m_left));
        gen.addUses(this, gen.getUses(this.m_right));
    }

    Code emit(Generator gen) {
        return gen.getFrame(this).emit();
    }

    void hash(Generator gen) {
        this.m_left.hash(gen);
        this.m_right.hash(gen);
        gen.hash(this.getClass());
    }

    public String toString() {
        return this.getJoinType() + "(" + this.m_left + ", " + this.m_right + ")";
    }

    abstract String getJoinType();

    String summary() {
        return this.getJoinType();
    }

    static ObjectType join(final ObjectType left, final ObjectType right) {
        Model anon = Model.getInstance("anonymous.join");
        ObjectType result = new ObjectType(anon, left.getQualifiedName() + "$" + right.getQualifiedName(), null){

            public String toString() {
                return left + " + " + right;
            }

            public List getKeyProperties() {
                ArrayList result = new ArrayList();
                result.addAll(this.getProperties());
                return result;
            }
        };
        AbstractJoin.addProperties(result, left);
        AbstractJoin.addProperties(result, right);
        return result;
    }

    private static void addProperties(ObjectType to, ObjectType from) {
        Iterator it = from.getProperties().iterator();
        while (it.hasNext()) {
            to.addProperty(AbstractJoin.copy((Property)it.next()));
        }
    }

    private static Property copy(Property prop) {
        final Property[] result = new Property[]{null};
        prop.dispatch(new Property.Switch(){

            public void onRole(Role role) {
                result[0] = new Role(role.getName(), role.getType(), role.isComponent(), role.isCollection(), role.isNullable());
            }

            public void onLink(Link link) {
                throw new Error("not implemented yet");
            }

            public void onAlias(Alias alias) {
                throw new Error("not implemented yet");
            }
        });
        return result[0];
    }
}

