/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.AddEvent;
import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.Cursor;
import com.redhat.persistence.DataSet;
import com.redhat.persistence.DeleteEvent;
import com.redhat.persistence.Engine;
import com.redhat.persistence.Event;
import com.redhat.persistence.EventProcessor;
import com.redhat.persistence.EventStream;
import com.redhat.persistence.Expander;
import com.redhat.persistence.FlushException;
import com.redhat.persistence.ObjectData;
import com.redhat.persistence.PersistentCollection;
import com.redhat.persistence.PersistentObjectSource;
import com.redhat.persistence.PropertyData;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.PropertyMap;
import com.redhat.persistence.QuerySource;
import com.redhat.persistence.RecordSet;
import com.redhat.persistence.RemoveEvent;
import com.redhat.persistence.SetEvent;
import com.redhat.persistence.Signature;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.Alias;
import com.redhat.persistence.metadata.Link;
import com.redhat.persistence.metadata.MetadataException;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.oql.All;
import com.redhat.persistence.oql.And;
import com.redhat.persistence.oql.BinaryCondition;
import com.redhat.persistence.oql.Define;
import com.redhat.persistence.oql.Equals;
import com.redhat.persistence.oql.Exists;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Filter;
import com.redhat.persistence.oql.Get;
import com.redhat.persistence.oql.Join;
import com.redhat.persistence.oql.Literal;
import com.redhat.persistence.oql.Variable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Session {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/Session.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$Session == null ? (class$com$redhat$persistence$Session = Session.class$("com.redhat.persistence.Session")) : class$com$redhat$persistence$Session));
    private static final PersistentObjectSource POS = new PersistentObjectSource();
    public static final String LINK_ASSOCIATION = "assoc";
    private final Root m_root;
    private final Engine m_engine;
    private final QuerySource m_qs;
    private HashMap m_odata = new HashMap();
    private EventStream m_events = new EventStream(this);
    private Set m_violations = new HashSet();
    private final Set m_beforeDelete = new HashSet();
    private final Set m_afterActivate = new HashSet();
    private final Set m_beforeFlush = new HashSet();
    private final Set m_afterFlush = new HashSet();
    private Event m_beforeFlushMarker = null;
    private static final Integer s_zero = new Integer(0);
    private static final ThreadLocal LEVEL = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };
    static /* synthetic */ Class class$com$redhat$persistence$Session;

    public Session(Root root, Engine engine, QuerySource source) {
        this.m_root = root;
        this.m_engine = engine;
        this.m_engine.setSession(this);
        this.m_qs = source;
        this.m_qs.setSession(this);
    }

    public Root getRoot() {
        return this.m_root;
    }

    Engine getEngine() {
        return this.m_engine;
    }

    public QuerySource getQuerySource() {
        return this.m_qs;
    }

    EventStream getEventStream() {
        return this.m_events;
    }

    public Object retrieve(PropertyMap keys) {
        Cursor c;
        ObjectData odata = this.getObjectData(keys);
        if (odata != null) {
            if (odata.isDeleted()) {
                return null;
            }
            ObjectType requested = keys.getObjectType();
            ObjectType current = this.getObjectType(odata.getObject());
            if (current.isSubtypeOf(requested)) {
                return odata.getObject();
            }
            if (!requested.isSubtypeOf(current)) {
                return null;
            }
        }
        if ((c = this.getDataSet(keys).getCursor()).next()) {
            Object result = c.get();
            if (c.next()) {
                throw new IllegalStateException("query returned more than one row");
            }
            return result;
        }
        return null;
    }

    public Object get(final Object obj, Property prop) {
        if (LOG.isDebugEnabled()) {
            Session.trace("get", new Object[]{obj, prop.getName()});
        }
        final Object[] result = new Object[]{null};
        if (!this.getObjectType(obj).hasKey()) {
            result[0] = this.getProperties(obj).get(prop);
        } else {
            prop.dispatch(new Property.Switch(){

                public void onRole(Role role) {
                    PropertyData pd = Session.this.fetchPropertyData(obj, role);
                    result[0] = pd.get();
                }

                public void onAlias(Alias alias) {
                    result[0] = Session.this.get(obj, alias.getTarget());
                }

                public void onLink(Link link) {
                    DataSet ds = Session.this.getDataSet(obj, link);
                    if (!link.isCollection()) {
                        Cursor c = ds.getCursor();
                        if (c.next()) {
                            result[0] = c.get(Session.LINK_ASSOCIATION);
                            if (c.next()) {
                                throw new IllegalStateException("Link query returned too many rows");
                            }
                        }
                    } else {
                        result[0] = POS.getPersistentCollection(Session.this, ds);
                    }
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            Session.untrace("get", result[0]);
        }
        return result[0];
    }

    public DataSet getDataSet(ObjectType type) {
        All objs = new All(type.getQualifiedName());
        Signature sig = new Signature(type);
        return new DataSet(this, sig, objs);
    }

    public DataSet getDataSet(PropertyMap keys) {
        ObjectType type = keys.getObjectType();
        Expression expr = new All(type.getQualifiedName());
        Signature sig = new Signature(type);
        ObjectMap map = type.getRoot().getObjectMap(type);
        List keyProps = map.getKeyProperties();
        BinaryCondition filter = null;
        Iterator it = keyProps.iterator();
        while (it.hasNext()) {
            Property keyProp = (Property)it.next();
            Object key = keys.get(keyProp);
            Equals propFilt = new Equals(new Variable(keyProp.getName()), new Literal(key));
            if (filter == null) {
                filter = propFilt;
                continue;
            }
            filter = new And(filter, propFilt);
        }
        expr = new Filter(expr, filter);
        return new DataSet(this, sig, expr);
    }

    public DataSet getDataSet(Object obj) {
        ObjectType type = this.getObjectType(obj);
        Signature sig = new Signature(type);
        Define objs = new Define(new All(type.getQualifiedName()), "this");
        Equals filter = new Equals(new Variable("this"), new Literal(obj));
        Get expr = new Get(new Filter(objs, filter), "this");
        return new DataSet(this, sig, expr);
    }

    public DataSet getDataSet(final Object obj, Property prop) {
        final DataSet[] result = new DataSet[1];
        prop.dispatch(new Property.Switch(){

            public void onRole(Role role) {
                result[0] = Session.this.getDataSet(obj, role);
            }

            public void onAlias(Alias alias) {
                throw new Error("not implemented yet");
            }

            public void onLink(Link link) {
                result[0] = Session.this.getDataSet(obj, link);
            }
        });
        return result[0];
    }

    private DataSet getDataSet(Object obj, Role role) {
        ObjectType propType = role.getType();
        DataSet ds = this.getDataSet(obj);
        if (propType.isKeyed()) {
            Signature sig = new Signature(propType);
            Expression expr = ds.getExpression();
            if (!role.isCollection()) {
                expr = new Filter(expr, new Exists(new Variable(role.getName())));
            }
            expr = new Get(expr, role.getName());
            return new DataSet(this, sig, expr);
        }
        ds.getSignature().addPath(role.getName());
        return ds;
    }

    private DataSet getDataSet(Object obj, Link link) {
        return this.getDataSet(obj, link, null);
    }

    private DataSet getDataSet(Object obj, Link link, Object value) {
        ObjectType targetType = link.getTo().getType();
        Define targets = new Define(new All(targetType.getQualifiedName()), LINK_ASSOCIATION);
        Define links = new Define(new All(link.getLinkType().getQualifiedName()), "link");
        Variable linkVar = new Variable("link");
        BinaryCondition cond = null;
        Iterator it = targetType.getKeyProperties().iterator();
        while (it.hasNext()) {
            Property key = (Property)it.next();
            String name = key.getName();
            Equals e = new Equals(new Get(new Variable(LINK_ASSOCIATION), name), new Get(new Get(linkVar, link.getTo().getName()), name));
            if (cond == null) {
                cond = e;
                continue;
            }
            cond = new And(e, cond);
        }
        Expression expr = new Join(targets, links, cond);
        Literal from = new Literal(obj);
        expr = new Filter(expr, new Equals(new Get(linkVar, link.getFrom().getName()), from));
        Signature sig = new Signature();
        sig.addSource(targetType, Path.get(LINK_ASSOCIATION));
        sig.addSource(link.getLinkType(), Path.get("link"));
        if (value != null) {
            Literal to = new Literal(value);
            expr = new Filter(expr, new Equals(new Variable(LINK_ASSOCIATION), to));
        }
        return new DataSet(this, sig, expr);
    }

    Object get(Object start, Path path) {
        Object value = path.getParent() == null ? start : this.get(start, path.getParent());
        ObjectType type = this.getObjectType(start);
        Property prop = type.getProperty(path.getName());
        if (prop == null) {
            throw new IllegalArgumentException(value + ": no such property: " + path.getName());
        }
        return this.get(start, prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Object obj) {
        try {
            if (LOG.isDebugEnabled()) {
                Session.trace("create", new Object[]{obj});
            }
            Expander e = new Expander(this);
            e.expand(new CreateEvent(this, obj));
            this.activate(e);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                Session.untrace("create");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Object obj) {
        try {
            if (LOG.isDebugEnabled()) {
                Session.trace("delete", new Object[]{obj});
            }
            if (this.isDeleted(obj)) {
                boolean bl = false;
                return bl;
            }
            Expander e = new Expander(this);
            e.expand(new DeleteEvent(this, obj));
            this.activate(e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                Session.untrace("delete");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(final Object obj, Property prop, final Object value) {
        try {
            if (LOG.isDebugEnabled()) {
                Session.trace("set", new Object[]{obj, prop, value});
            }
            final Expander e = new Expander(this);
            prop.dispatch(new Property.Switch(){

                public void onRole(Role role) {
                    e.expand(new SetEvent(Session.this, obj, role, value));
                }

                public void onAlias(Alias alias) {
                    e.expand(new SetEvent(Session.this, obj, alias.getTarget(), value));
                }

                public void onLink(Link link) {
                    Object oldValue = Session.this.get(obj, link);
                    PropertyMap pmap = new PropertyMap(link.getLinkType());
                    pmap.put(link.getFrom(), obj);
                    if (oldValue != null) {
                        pmap.put(link.getTo(), oldValue);
                        e.expand(new DeleteEvent(Session.this, Session.this.getObject(pmap)));
                    }
                    pmap.put(link.getTo(), value);
                    e.expand(new CreateEvent(Session.this, Session.this.getObject(pmap)));
                }
            });
            this.activate(e);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                Session.untrace("set");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object add(final Object obj, Property prop, final Object value) {
        final Object[] result = new Object[]{null};
        try {
            if (LOG.isDebugEnabled()) {
                Session.trace("add", new Object[]{obj, prop, value});
            }
            final Expander e = new Expander(this);
            prop.dispatch(new Property.Switch(){

                public void onRole(Role role) {
                    e.expand(new AddEvent(Session.this, obj, role, value));
                }

                public void onAlias(Alias alias) {
                    e.expand(new AddEvent(Session.this, obj, alias.getTarget(), value));
                }

                public void onLink(Link link) {
                    PropertyMap pmap = new PropertyMap(link.getLinkType());
                    pmap.put(link.getFrom(), obj);
                    pmap.put(link.getTo(), value);
                    result[0] = Session.this.getObject(pmap);
                    e.expand(new CreateEvent(Session.this, result[0]));
                }
            });
            this.activate(e);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (LOG.isDebugEnabled()) {
                Session.untrace("add", result[0]);
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            Session.untrace("add", result[0]);
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object obj, Property prop, Object value) {
        try {
            if (LOG.isDebugEnabled()) {
                Session.trace("remove", new Object[]{obj, prop, value});
            }
            Expander e = new Expander(this);
            this.remove(obj, prop, value, e);
            this.activate(e);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                Session.untrace("remove");
            }
        }
    }

    private void remove(final Object obj, Property prop, final Object value, final Expander e) {
        prop.dispatch(new Property.Switch(){

            public void onRole(Role role) {
                e.expand(new RemoveEvent(Session.this, obj, role, value));
            }

            public void onAlias(Alias alias) {
                e.expand(new RemoveEvent(Session.this, obj, alias.getTarget(), value));
            }

            public void onLink(Link link) {
                Cursor c = Session.this.getDataSet(obj, link, value).getCursor();
                while (c.next()) {
                    e.expand(new DeleteEvent(Session.this, c.get("link")));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Object obj, Property prop) {
        try {
            if (LOG.isDebugEnabled()) {
                Session.trace("clear", new Object[]{obj, prop});
            }
            Expander e = new Expander(this);
            PersistentCollection pc = (PersistentCollection)this.get(obj, prop);
            Cursor c = pc.getDataSet().getCursor();
            while (c.next()) {
                this.remove(obj, prop, c.get(), e);
            }
            this.activate(e);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                Session.untrace("clear");
            }
        }
    }

    public Object getObject(PropertyMap pmap) {
        Adapter ad = this.m_root.getAdapter(pmap.getObjectType());
        return ad.getObject(pmap.getObjectType(), pmap);
    }

    public ObjectType getObjectType(Object obj) {
        return this.getAdapter(obj).getObjectType(obj);
    }

    Adapter getAdapter(Object obj) {
        return this.m_root.getAdapter(obj.getClass());
    }

    public ObjectMap getObjectMap(Object obj) {
        ObjectType type = this.getAdapter(obj).getObjectType(obj);
        return type.getRoot().getObjectMap(type);
    }

    public PropertyMap getProperties(Object obj) {
        return this.getAdapter(obj).getProperties(obj);
    }

    public boolean isFlushed() {
        return this.m_events.size() == 0;
    }

    public boolean isNew(Object obj) {
        return this.hasObjectData(obj) && this.getObjectData(obj).isNew();
    }

    public boolean isDeleted(Object obj) {
        return this.hasObjectData(obj) && this.getObjectData(obj).isDeleted();
    }

    public boolean isModified(Object obj) {
        return this.hasObjectData(obj) && this.getObjectData(obj).isModified();
    }

    public boolean isFlushed(Object obj) {
        if (!this.hasObjectData(obj)) {
            return true;
        }
        ObjectData od = this.getObjectData(obj);
        return od.isFlushed();
    }

    public void assertFlushed(Object obj) {
        if (!this.isFlushed(obj)) {
            throw new FlushException(obj, this.m_violations);
        }
    }

    public boolean isFlushed(final Object obj, Property prop) {
        if (!this.hasObjectData(obj)) {
            return true;
        }
        final boolean[] result = new boolean[]{true};
        prop.dispatch(new Property.Switch(){

            public void onRole(Role r) {
                PropertyData pd = Session.this.getObjectData(obj).getPropertyData(r);
                result[0] = pd == null ? true : pd.isFlushed();
            }

            public void onAlias(Alias a) {
                result[0] = Session.this.isFlushed(obj, a.getTarget());
            }

            public void onLink(Link l) {
                result[0] = Session.this.isFlushed(obj, l.getFrom().getReverse());
            }
        });
        return result[0];
    }

    public boolean isPersisted(Object obj) {
        return this.hasObjectData(obj) && !this.getObjectData(obj).isInfantile();
    }

    private void process(Collection processors, Collection events) {
        Iterator it = processors.iterator();
        while (it.hasNext()) {
            EventProcessor ep = (EventProcessor)it.next();
            Iterator it2 = events.iterator();
            while (it2.hasNext()) {
                Event ev = (Event)it2.next();
                ep.write(ev);
            }
            ep.flush();
        }
    }

    private void computeFlushability() {
        Iterator it = this.m_events.iterator();
        while (it.hasNext()) {
            ((Event)it.next()).m_flushable = true;
        }
        LinkedList queue = new LinkedList();
        Iterator pds = this.m_violations.iterator();
        while (pds.hasNext()) {
            PropertyData pd = (PropertyData)pds.next();
            Iterator evs = pd.getDependentEvents();
            while (evs.hasNext()) {
                queue.add(evs.next());
            }
        }
        while (queue.size() != 0) {
            Event ev = (Event)queue.remove(0);
            if (!ev.m_flushable) continue;
            ev.m_flushable = false;
            Iterator evs = ev.getDependentEvents();
            while (evs.hasNext()) {
                queue.add(evs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            if (LOG.isDebugEnabled()) {
                Session.trace("flush", new Object[0]);
            }
            this.flushInternal();
        }
        finally {
            if (LOG.isDebugEnabled()) {
                Session.untrace("flush");
            }
        }
    }

    public void flushAll() {
        this.flush();
        if (!this.isFlushed()) {
            throw new FlushException(this.m_violations);
        }
    }

    private void flushInternal() {
        Event ev;
        boolean flushed = this.m_beforeFlushMarker != null;
        List events = this.m_events.getEvents();
        for (int i = 0; i < events.size(); ++i) {
            Event ev2 = (Event)events.get(i);
            if (flushed) {
                if (!this.m_beforeFlushMarker.equals(ev2)) continue;
                flushed = false;
                continue;
            }
            this.m_beforeFlushMarker = ev2;
            Iterator eps = this.m_beforeFlush.iterator();
            while (eps.hasNext()) {
                EventProcessor ep = (EventProcessor)eps.next();
                ep.write(ev2);
            }
        }
        Iterator it = this.m_beforeFlush.iterator();
        while (it.hasNext()) {
            EventProcessor ep = (EventProcessor)it.next();
            ep.flush();
        }
        LinkedList<Event> written = new LinkedList<Event>();
        Event prev = null;
        Iterator it2 = this.m_events.iterator();
        while (it2.hasNext()) {
            ev = (Event)it2.next();
            if (ev.m_flushable) {
                this.m_engine.write(ev);
                written.add(ev);
                it2.remove();
                if (!ev.equals(this.m_beforeFlushMarker)) continue;
                this.m_beforeFlushMarker = prev;
                continue;
            }
            prev = ev;
        }
        this.m_engine.flush();
        it2 = written.iterator();
        while (it2.hasNext()) {
            ev = (Event)it2.next();
            ev.sync();
        }
        this.computeFlushability();
        this.process(this.m_afterFlush, written);
        if (LOG.isInfoEnabled() && this.m_events.size() > 0) {
            LOG.info((Object)("unflushed: " + this.m_events.size()));
        }
        if (LOG.isDebugEnabled() && this.m_events.size() > 0) {
            LOG.debug((Object)("events: " + this.m_events.getEvents()));
            LOG.debug((Object)("violations: " + this.m_violations));
        }
    }

    private void clear(boolean isCommit) {
        this.m_odata.clear();
        this.m_events.clear();
        this.m_violations.clear();
        this.m_beforeFlushMarker = null;
        if (LOG.isDebugEnabled()) {
            Session.setLevel(0);
        }
        this.cleanUpEventProcessors(isCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        boolean success = false;
        try {
            this.flushAll();
            this.clear(true);
            this.m_engine.commit();
            success = true;
        }
        finally {
            if (!success) {
                this.clear(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testCommit() {
        boolean success = false;
        try {
            this.flushAll();
            this.clear(true);
            success = true;
        }
        finally {
            if (!success) {
                this.clear(false);
            }
        }
    }

    private void cleanUpEventProcessors(boolean isCommit) {
        EventProcessor ep;
        Iterator eps = this.m_afterActivate.iterator();
        while (eps.hasNext()) {
            ep = (EventProcessor)eps.next();
            ep.cleanUp(isCommit);
        }
        eps = this.m_beforeFlush.iterator();
        while (eps.hasNext()) {
            ep = (EventProcessor)eps.next();
            ep.cleanUp(isCommit);
        }
        eps = this.m_afterFlush.iterator();
        while (eps.hasNext()) {
            ep = (EventProcessor)eps.next();
            ep.cleanUp(isCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            this.m_engine.rollback();
        }
        finally {
            this.clear(false);
        }
    }

    void load(Object obj, Property prop, Object value) {
        PropertyData pd;
        ObjectData od;
        if (LOG.isDebugEnabled()) {
            Session.trace("load", new Object[]{obj, prop.getName(), value});
        }
        if ((od = this.getObjectData(obj)) == null) {
            od = new ObjectData(this, obj, ObjectData.NUBILE);
        }
        if ((pd = od.getPropertyData(prop)) == null) {
            pd = new PropertyData(od, prop, value);
        } else {
            pd.setValue(value);
        }
        if (LOG.isDebugEnabled()) {
            Session.untrace("load");
        }
    }

    private void activate(Expander e) {
        List pending = e.finish();
        if (e.didDelete()) {
            this.process(this.m_beforeDelete, pending);
        }
        ArrayList<Event> activated = new ArrayList<Event>();
        Iterator it = pending.iterator();
        while (it.hasNext()) {
            ObjectData pod;
            PropertyEvent pev;
            Object arg;
            ObjectData od;
            Event ev = (Event)it.next();
            if (e.didDelete() && ((od = this.getObjectData(ev.getObject())) != null && od.isDeleted() || ev instanceof PropertyEvent && (arg = (pev = (PropertyEvent)ev).getArgument()) != null && (pod = this.getObjectData(arg)) != null && pod.isDeleted())) continue;
            ev.activate();
            activated.add(ev);
        }
        this.computeFlushability();
        this.process(this.m_afterActivate, activated);
    }

    Object getSessionKey(PropertyMap pmap) {
        ObjectType ot = pmap.getObjectType();
        Adapter ad = this.m_root.getAdapter(ot);
        return ad.getSessionKey(ot, pmap);
    }

    Object getSessionKey(Object obj) {
        Adapter ad = this.getAdapter(obj);
        return ad.getSessionKey(obj);
    }

    public void releaseObject(Object obj) {
        ObjectData od = this.getObjectData(obj);
        if (od != null && od.getObject() == obj) {
            Adapter ad = this.getAdapter(obj);
            ObjectType type = ad.getObjectType(obj);
            Object newObj = ad.getObject(type, ad.getProperties(obj));
            this.use(newObj);
        }
    }

    void use(Object obj) {
        ObjectData odata;
        Adapter ad = this.getAdapter(obj);
        ObjectType type = ad.getObjectType(obj);
        if (type.isKeyed()) {
            ad.setSession(obj, this);
        }
        if ((odata = this.getObjectData(obj)) != null) {
            odata.setObject(obj);
        }
    }

    Object getObject(Object key) {
        if (this.m_odata.containsKey(key)) {
            return ((ObjectData)this.m_odata.get(key)).getObject();
        }
        return null;
    }

    boolean hasObjectData(Object obj) {
        return this.m_odata.containsKey(this.getSessionKey(obj));
    }

    ObjectData getObjectData(PropertyMap pmap) {
        return (ObjectData)this.m_odata.get(this.getSessionKey(pmap));
    }

    ObjectData getObjectData(Object obj) {
        return (ObjectData)this.m_odata.get(this.getSessionKey(obj));
    }

    void removeObjectData(Object obj) {
        this.m_odata.remove(this.getSessionKey(obj));
    }

    void addObjectData(ObjectData odata) {
        this.m_odata.put(this.getSessionKey(odata.getObject()), odata);
    }

    PropertyData getPropertyData(Object obj, Property prop) {
        ObjectData od = this.getObjectData(obj);
        if (od != null) {
            return od.getPropertyData(prop);
        }
        return null;
    }

    ObjectData fetchObjectData(Object obj) {
        ObjectData od;
        if (!this.hasObjectData(obj)) {
            RecordSet rs = this.getDataSet(obj).getCursor().execute();
            if (!rs.next()) {
                this.m_odata.put(obj, null);
            } else {
                do {
                    rs.load(this);
                } while (rs.next());
            }
        }
        if ((od = this.getObjectData(obj)) != null && od.isDeleted()) {
            return null;
        }
        return od;
    }

    PropertyData fetchPropertyData(Object obj, Property prop) {
        PropertyData pd;
        ObjectData od = this.fetchObjectData(obj);
        if (od == null) {
            throw new IllegalArgumentException("No such object: " + obj);
        }
        if (od.hasPropertyData(prop)) {
            pd = od.getPropertyData(prop);
        } else if (prop.isCollection()) {
            pd = new PropertyData(od, prop, POS.getPersistentCollection(this, this.getDataSet(obj, prop)));
        } else if (od.isInfantile()) {
            pd = new PropertyData(od, prop, null);
        } else {
            RecordSet rs = this.getDataSet(obj, prop).getCursor().execute();
            Map values = null;
            if (rs.next()) {
                values = rs.load(this);
                if (rs.next()) {
                    throw new IllegalStateException("Query returned too many rows");
                }
            }
            if (prop.getType().isKeyed()) {
                if (values == null) {
                    this.load(obj, prop, null);
                } else {
                    this.load(obj, prop, values.get(null));
                }
            } else if (values == null) {
                throw new MetadataException(prop.getRoot(), prop, "Query for: " + prop.getContainer() + "." + prop + " failed to return rows");
            }
            pd = od.getPropertyData(prop);
            if (pd == null) {
                throw new IllegalStateException("Query failed to retrieve property");
            }
        }
        return pd;
    }

    void addViolation(PropertyData pd) {
        this.m_violations.add(pd);
    }

    void removeViolation(PropertyData pd) {
        this.m_violations.remove(pd);
    }

    private void check(EventProcessor ep) {
        if (ep == null) {
            throw new IllegalArgumentException("null event processor");
        }
    }

    public void addBeforeDelete(EventProcessor ep) {
        this.check(ep);
        this.m_beforeDelete.add(ep);
    }

    public void addAfterActivate(EventProcessor ep) {
        this.check(ep);
        this.m_afterActivate.add(ep);
    }

    public void addBeforeFlush(EventProcessor ep) {
        this.check(ep);
        this.m_beforeFlush.add(ep);
    }

    public void addAfterFlush(EventProcessor ep) {
        this.check(ep);
        this.m_afterFlush.add(ep);
    }

    void dump() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.dump(pw);
        pw.flush();
        LOG.debug((Object)sw.toString());
    }

    void dump(PrintWriter out) {
        Iterator it = this.m_odata.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Object key = me.getKey();
            out.print(key);
            out.println(":");
            ObjectData od = (ObjectData)me.getValue();
            od.dump(out);
        }
    }

    static final int getLevel() {
        Integer level = (Integer)LEVEL.get();
        return level;
    }

    static final void setLevel(int level) {
        if (level < 0) {
            level = 0;
        }
        LEVEL.set(new Integer(level));
    }

    static final void trace(String method, Object[] args) {
        if (LOG.isDebugEnabled()) {
            int i;
            StringBuffer msg = new StringBuffer();
            int level = Session.getLevel();
            for (i = 0; i < level; ++i) {
                msg.append("  ");
            }
            msg.append(method);
            msg.append("(");
            for (i = 0; i < args.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(args[i]);
            }
            msg.append(") {");
            LOG.debug((Object)msg.toString());
            Session.setLevel(level + 1);
        }
    }

    static final void untrace(String method) {
        Session.untrace(method, null);
    }

    static final void untrace(String method, boolean result) {
        Session.untrace(method, result ? Boolean.TRUE : Boolean.FALSE);
    }

    static final void untrace(String method, Object result) {
        if (LOG.isDebugEnabled()) {
            Session.untrace(method, " -> " + result);
        }
    }

    static final void untrace(String method, String msg) {
        if (LOG.isDebugEnabled()) {
            int level = Session.getLevel();
            Session.setLevel(level - 1);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < level - 1; ++i) {
                buf.append("  ");
            }
            buf.append("} (");
            buf.append(method);
            buf.append(")");
            if (msg != null) {
                buf.append(msg);
            }
            LOG.debug((Object)buf.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

