/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.PropertyMap;
import com.redhat.persistence.Session;
import com.redhat.persistence.Signature;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class RecordSet {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/RecordSet.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$RecordSet == null ? (class$com$redhat$persistence$RecordSet = RecordSet.class$("com.redhat.persistence.RecordSet")) : class$com$redhat$persistence$RecordSet));
    private Signature m_signature;
    static /* synthetic */ Class class$com$redhat$persistence$RecordSet;

    protected RecordSet(Signature signature) {
        this.m_signature = signature;
    }

    protected Signature getSignature() {
        return this.m_signature;
    }

    boolean isFetched(Path path) {
        return this.m_signature.isFetched(path);
    }

    public abstract boolean next();

    public abstract Object get(Path var1);

    public abstract void close();

    Map load(Session ssn) {
        int before;
        Collection paths = this.m_signature.getPaths();
        LinkedList<Path> remaining = new LinkedList<Path>();
        Iterator it = paths.iterator();
        block0: while (it.hasNext()) {
            Path path = (Path)it.next();
            while (true) {
                if (!remaining.contains(path)) {
                    remaining.add(path);
                }
                if (this.m_signature.isSource(path)) continue block0;
                path = path.getParent();
            }
        }
        HashMap<Path, Object> values = new HashMap<Path, Object>();
        do {
            before = remaining.size();
            Iterator it2 = remaining.iterator();
            block3: while (it2.hasNext()) {
                Path p = (Path)it2.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("loading " + p));
                }
                ObjectType type = this.m_signature.getType(p);
                Adapter adapter = ssn.getRoot().getAdapter(type);
                List props = type.getImmediateProperties();
                if (props.size() == 0) {
                    values.put(p, this.get(p));
                    it2.remove();
                    continue;
                }
                PropertyMap pmap = new PropertyMap(type);
                Iterator iter = props.iterator();
                while (iter.hasNext()) {
                    Property prop = (Property)iter.next();
                    Path kp = Path.add(p, prop.getName());
                    if (values.containsKey(kp)) {
                        pmap.put(prop, values.get(kp));
                        continue;
                    }
                    if (!this.m_signature.isFetched(kp)) continue;
                    continue block3;
                }
                Object obj = null;
                if (!pmap.isNull()) {
                    Object previous = null;
                    if (type.isKeyed() && (previous = ssn.getObject(adapter.getSessionKey(type, pmap))) != null) {
                        ObjectType prevType = adapter.getObjectType(previous);
                        if (type.equals(prevType) || prevType.isSubtypeOf(type)) {
                            obj = previous;
                        } else if (!type.isSubtypeOf(prevType)) {
                            throw new IllegalStateException("object of wrong type in session " + type + " " + prevType);
                        }
                    }
                    if (obj == null && previous != (obj = adapter.getObject(type, pmap))) {
                        ssn.use(obj);
                    }
                }
                values.put(p, obj);
                it2.remove();
            }
        } while (remaining.size() < before);
        if (remaining.size() > 0) {
            throw new IllegalStateException("unable to load the following paths: " + remaining + "\nsignature: " + this.m_signature);
        }
        HashMap cursorValues = new HashMap();
        Iterator it3 = values.entrySet().iterator();
        while (it3.hasNext()) {
            Map.Entry me = it3.next();
            Path p = (Path)me.getKey();
            Object value = me.getValue();
            if (this.m_signature.isSource(p)) {
                cursorValues.put(p, value);
                continue;
            }
            Property prop = this.m_signature.getProperty(p);
            if (prop.getContainer().isKeyed() && !prop.isCollection()) {
                Object container = values.get(p.getParent());
                if (container == null) {
                    if (value == null) continue;
                    throw new IllegalStateException("container of " + p + " is null");
                }
                ssn.load(container, prop, value);
                continue;
            }
            cursorValues.put(p, value);
        }
        return cursorValues;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

