/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.util.Assert;
import com.arsdigita.util.ResourceManager;
import com.arsdigita.util.WrappedError;
import com.arsdigita.web.Debugger;
import com.arsdigita.xml.Document;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TransformationDebugger
extends Debugger {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/TransformationDebugger.java#12 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$TransformationDebugger == null ? (class$com$arsdigita$web$TransformationDebugger = TransformationDebugger.class$("com.arsdigita.web.TransformationDebugger")) : class$com$arsdigita$web$TransformationDebugger));
    private URL m_sheet;
    private List m_dependents;
    public static final String TRANSFORM_DEBUG_VALUE = "transform";
    static /* synthetic */ Class class$com$arsdigita$web$TransformationDebugger;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$List;

    public TransformationDebugger(Document original, Document source, URL sheet, List dependents) {
        Assert.exists(sheet, class$java$net$URL == null ? (class$java$net$URL = TransformationDebugger.class$("java.net.URL")) : class$java$net$URL);
        Assert.exists(sheet, class$java$util$List == null ? (class$java$util$List = TransformationDebugger.class$("java.util.List")) : class$java$util$List);
        this.m_sheet = sheet;
        this.m_dependents = dependents;
    }

    public TransformationDebugger(URL sheet, List dependents) {
        this(null, null, sheet, dependents);
    }

    public boolean isRequested(HttpServletRequest sreq) {
        String value = sreq.getParameter("debug");
        return value != null && value.indexOf(TRANSFORM_DEBUG_VALUE) != -1;
    }

    public String debug() {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("<h2>The Stylesheet files</h2>");
        buffer.append("<ul>");
        try {
            Iterator sources = this.m_dependents.iterator();
            File root = ResourceManager.getInstance().getWebappRoot();
            String base = root.toURL().toExternalForm();
            while (sources.hasNext()) {
                String path = sources.next().toString();
                if (path.startsWith(base)) {
                    path = path.substring(base.length());
                }
                buffer.append("<li><code><a href=\"" + path + "\">" + path + "</a></code></li>");
            }
        }
        catch (IOException ioe) {
            throw new WrappedError(ioe);
        }
        buffer.append("</ul>");
        return buffer.toString();
    }

    protected String getStylesheetContents() {
        try {
            String line;
            int offset;
            URLConnection con = this.m_sheet.openConnection();
            StringBuffer buffer = new StringBuffer();
            String contentType = con.getContentType();
            String encoding = "ISO-8859-1";
            int n = offset = contentType == null ? -1 : contentType.indexOf("charset=");
            if (offset != -1) {
                encoding = contentType.substring(offset + 8).trim();
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Received content type " + contentType));
            }
            InputStream is = con.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, encoding);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Process with character encoding " + isr.getEncoding()));
            }
            BufferedReader input = new BufferedReader(isr);
            while ((line = input.readLine()) != null) {
                buffer.append(line).append('\n');
            }
            input.close();
            return buffer.toString();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return "Stylesheet contents unavailable: " + ex.getMessage();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "Stylesheet contents unavailable: " + ex.getMessage();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

