/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.kernel.Kernel;
import com.arsdigita.persistence.AbstractTransactionListener;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Adapter;
import com.arsdigita.versioning.Constants;
import com.arsdigita.versioning.DevSupport;
import com.arsdigita.versioning.RollerBacker;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.Types;
import com.arsdigita.versioning.Versioning;
import com.arsdigita.versioning.Versions;
import com.arsdigita.web.BaseServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public final class VersioningServlet
extends BaseServlet {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$VersioningServlet == null ? (class$com$arsdigita$versioning$VersioningServlet = VersioningServlet.class$("com.arsdigita.versioning.VersioningServlet")) : class$com$arsdigita$versioning$VersioningServlet));
    private static final String CMD = "cmd";
    private static final String OID = "oid";
    private static final String TITLE = "title";
    private static final String JSP_DIR = "/packages/versioning/";
    static /* synthetic */ Class class$com$arsdigita$versioning$VersioningServlet;

    public void doService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!Versioning.getConfig().isDebugUIEnabled()) {
            throw new ServletException("this service is disabled");
        }
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.addTransactionListener(new AbstractTransactionListener(){

            public void beforeCommit(TransactionContext txn) {
                Assert.fail("uncommittable transaction");
            }
        });
        Kernel.getContext().getTransaction().setCommitRequested(false);
        String cmd = req.getParameter(CMD);
        if (cmd == null || "typeSearch".equals(cmd)) {
            this.mainPage(req, resp);
        } else if ("showTxns".equals(cmd)) {
            this.txnsPage(req, resp);
        } else if ("rollback".equals(cmd)) {
            this.rollbackPage(req, resp);
        } else if ("graph".equals(cmd)) {
            this.versioningGraphPage(req, resp);
        } else {
            throw new ServletException("unknown cmd=" + cmd);
        }
    }

    private RequestDispatcher getDispatcher(String path) {
        return this.getServletContext().getRequestDispatcher(path);
    }

    private void mainPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        VersionedObjectsImpl versionedObjects = new VersionedObjectsImpl(req.getParameter("objectType"));
        req.setAttribute(TITLE, (Object)"Versioning Log");
        req.setAttribute("versionedObjects", (Object)versionedObjects);
        this.getDispatcher("/packages/versioning/main.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void txnsPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serOID = VersioningServlet.getParam(req, OID);
        OID oid = (OID)Adapter.deserialize(serOID, Types.OID);
        String tagged = req.getParameter("tagged");
        TransactionCollection txnColl = null;
        txnColl = tagged != null && "yes".equals(tagged) ? Versions.getTaggedTransactions(oid) : Versions.getTransactions(oid);
        req.setAttribute(TITLE, (Object)"Transactions");
        req.setAttribute("txns", (Object)txnColl);
        req.setAttribute(OID, (Object)oid);
        req.setAttribute("encodedOID", (Object)URLEncoder.encode(serOID));
        this.getDispatcher("/packages/versioning/txns.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void rollbackPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        OID oid = (OID)Adapter.deserialize(VersioningServlet.getParam(req, OID), Types.OID);
        BigInteger txnID = new BigInteger(VersioningServlet.getParam(req, "txnID"));
        RollerBacker rb = new RollerBacker(oid, txnID);
        req.setAttribute("logger", (Object)rb);
        this.getDispatcher("/packages/versioning/rollback.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void versioningGraphPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String graphType = VersioningServlet.getParam(req, "graphType");
        req.setAttribute(TITLE, (Object)"Versioning Graph");
        GraphPrinterImpl printer = new GraphPrinterImpl(new DevSupport.NodeFilter(){

            public boolean test(String qName, boolean isReachable) {
                return isReachable && qName != null && qName.startsWith("com");
            }
        });
        req.setAttribute("graphPrinter", (Object)printer);
        this.getDispatcher("/packages/versioning/graph.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private static String getParam(HttpServletRequest req, String name) throws ServletException {
        String result = req.getParameter(name);
        if (result == null) {
            throw new ServletException(name + " was not supplied");
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class GraphPrinterImpl
    implements GraphPrinter {
        private final DevSupport.NodeFilter m_filter;
        private PrintWriter m_writer;

        GraphPrinterImpl(DevSupport.NodeFilter filter) {
            this.m_filter = filter;
        }

        public void setWriter(Writer writer) {
            this.m_writer = new PrintWriter(writer);
        }

        public void printGraph() {
            DevSupport.versioningGraphToDot(this.m_filter, this.m_writer);
        }
    }

    private static class VersionedObjectsImpl
    implements Constants,
    VersionedObjects {
        private List m_oids;
        private Iterator m_iter;
        private OID m_curOID;

        public VersionedObjectsImpl(String type) {
            DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.versioning.DataObjectChange");
            dc.addFilter("oid like '%" + type + "%'");
            HashSet<Object> oids = new HashSet<Object>();
            while (dc.next()) {
                oids.add(dc.get(VersioningServlet.OID));
            }
            this.m_oids = new ArrayList(oids);
            Collections.sort(this.m_oids);
            this.m_iter = this.m_oids.iterator();
        }

        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        public Object next() {
            String next = (String)this.m_iter.next();
            this.m_curOID = (OID)Adapter.deserialize(next, Types.OID);
            return next;
        }

        public int size() {
            return this.m_oids.size();
        }

        public OID getOID() {
            return this.m_curOID;
        }
    }

    public static interface GraphPrinter {
        public void setWriter(Writer var1);

        public void printGraph();
    }

    public static interface RollbackLogger {
        public OID getOID();

        public BigInteger getTxnID();

        public void setWriter(Writer var1);

        public void rollback();

        public void printException(Throwable var1) throws ServletException;
    }

    public static interface VersionedObjects {
        public OID getOID();

        public boolean hasNext();

        public Object next();

        public int size();
    }
}

