/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.parameter;

import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterError;
import com.arsdigita.util.parameter.StringParameter;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.oro.text.perl.Perl5Util;

public class EmailParameter
extends StringParameter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/parameter/EmailParameter.java#6 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Perl5Util s_perl = new Perl5Util();
    private static final String s_regex = "/^[^@<>\"\t ]+@[^@<>\".\t]+([.][^@<>\".\n ]+)+$/";

    public EmailParameter(String name) {
        super(name);
    }

    protected Object unmarshal(String value, ErrorList errors) {
        try {
            return new InternetAddress(value);
        }
        catch (AddressException ae) {
            errors.add(new ParameterError((Parameter)this, ae));
            return null;
        }
    }

    protected void doValidate(Object value, ErrorList errors) {
        super.doValidate(value, errors);
        InternetAddress email = (InternetAddress)value;
        if (!s_perl.match(s_regex, email.toString())) {
            ParameterError error = new ParameterError((Parameter)this, "The value is not a valid email address");
            errors.add(error);
        }
    }
}

