/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.csv;

import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterLoader;
import com.arsdigita.util.parameter.ParameterValue;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;

public final class CSVParameterLoader
implements ParameterLoader {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/csv/CSVParameterLoader.java#5 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private final LineNumberReader m_reader;
    private final Parameter[] m_params;
    private final HashMap m_line;
    private static final char ESCAPE = '\\';
    private static final char QUOTE = '\"';
    private static final char SEPARATOR = ',';

    public CSVParameterLoader(Reader reader, Parameter[] params) {
        this.m_reader = new LineNumberReader(reader);
        this.m_params = params;
        this.m_line = new HashMap(params.length);
    }

    public final String read(Parameter param, ErrorList errors) {
        return (String)this.m_line.get(param);
    }

    public final ParameterValue load(Parameter param) {
        ParameterValue value = new ParameterValue();
        value.setObject(param.read(this, value.getErrors()));
        value.getErrors().check();
        return value;
    }

    public final boolean next() {
        try {
            return this.internalNext();
        }
        catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }
    }

    private boolean internalNext() throws IOException {
        String line = this.m_reader.readLine();
        if (line == null) {
            return false;
        }
        String[] elems = this.parseLine(line);
        for (int i = 0; i < this.m_params.length; ++i) {
            if (i < elems.length) {
                this.m_line.put(this.m_params[i], elems[i]);
                continue;
            }
            this.m_line.put(this.m_params[i], null);
        }
        return true;
    }

    private char escape(char c) {
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
        }
        return c;
    }

    private String[] parseLine(String line) {
        int length = line.length();
        if (line.charAt(length - 1) == '\\') {
            throw new IllegalArgumentException(this.m_reader.getLineNumber() + ": last character is an escape character\n" + line);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer buf = new StringBuffer(length);
        int begin = -1;
        int end = 0;
        boolean quote = false;
        block9: for (int i = 0; i < length; ++i) {
            char c = line.charAt(i);
            if (quote) {
                switch (c) {
                    case '\"': {
                        quote = false;
                        break;
                    }
                    case '\\': {
                        buf.append(this.escape(line.charAt(++i)));
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
                end = buf.length();
                continue;
            }
            switch (c) {
                case ',': {
                    result.add(this.field(buf, begin, end));
                    buf = new StringBuffer(length);
                    begin = -1;
                    end = 0;
                    continue block9;
                }
                case '\\': {
                    if (begin < 0) {
                        begin = buf.length();
                    }
                    buf.append(this.escape(line.charAt(++i)));
                    end = buf.length();
                    continue block9;
                }
                case '\"': {
                    if (begin < 0) {
                        begin = buf.length();
                    }
                    quote = true;
                    end = buf.length();
                    continue block9;
                }
                default: {
                    if (begin < 0 && !Character.isWhitespace(c)) {
                        begin = buf.length();
                    }
                    buf.append(c);
                    if (Character.isWhitespace(c)) continue block9;
                    end = buf.length();
                }
            }
        }
        if (quote) {
            throw new IllegalArgumentException(this.m_reader.getLineNumber() + ": unterminated string\n" + line);
        }
        result.add(this.field(buf, begin, end));
        String[] fields = new String[result.size()];
        result.toArray(fields);
        return fields;
    }

    private String field(StringBuffer field, int begin, int end) {
        if (begin < 0) {
            return field.substring(0, end);
        }
        return field.substring(begin, end);
    }
}

