/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.StringUtils;

public class TypedText {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/TypedText.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_PREFORMATTED = "text/plain; format=preformatted";
    private String m_text;
    private String m_type;

    public TypedText(String text, String type) {
        this.m_text = text;
        this.m_type = type;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getHTMLText() {
        if (this.m_text == null) {
            return "";
        }
        if (this.m_type.equals(TEXT_HTML)) {
            return this.m_text;
        }
        if (this.m_type.equals(TEXT_PREFORMATTED)) {
            return "<pre>" + this.m_text + "</pre>";
        }
        if (this.m_type.equals(TEXT_PLAIN)) {
            return StringUtils.textToHtml(this.m_text);
        }
        return StringUtils.textToHtml(this.m_text);
    }

    public boolean equals(Object o) {
        if (o instanceof TypedText) {
            TypedText t = (TypedText)o;
            return this.getText().equals(t.getText()) && this.getType().equals(t.getType());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (null != this.m_text) {
            result = 37 * result + this.m_text.hashCode();
        }
        result = 37 * result + this.m_type.hashCode();
        return result;
    }
}

