/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.log4j.Logger;

public final class Reporter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/Reporter.java#5 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$Reporter == null ? (class$com$arsdigita$util$Reporter = Reporter.class$("com.arsdigita.util.Reporter")) : class$com$arsdigita$util$Reporter));
    private final Logger m_log;
    private final Object m_object;
    private BeanInfo m_info;
    static /* synthetic */ Class class$com$arsdigita$util$Reporter;
    static /* synthetic */ Class class$org$apache$log4j$Logger;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public Reporter(Logger log, Object object) {
        this(log, object, object.getClass());
    }

    public Reporter(Logger log, Object object, Class base) {
        Assert.exists(log, class$org$apache$log4j$Logger == null ? (class$org$apache$log4j$Logger = Reporter.class$("org.apache.log4j.Logger")) : class$org$apache$log4j$Logger);
        Assert.exists(object, class$java$lang$Object == null ? (class$java$lang$Object = Reporter.class$("java.lang.Object")) : class$java$lang$Object);
        this.m_log = log;
        this.m_object = object;
        if (this.m_log.isDebugEnabled()) {
            Class<?> special = this.m_object.getClass();
            Class general = base.getSuperclass();
            try {
                this.m_info = general == null ? Introspector.getBeanInfo(special) : Introspector.getBeanInfo(special, general);
            }
            catch (IntrospectionException ie) {
                throw new UncheckedWrapperException(ie);
            }
        }
    }

    public final void mutated(String property) {
        if (this.m_log.isDebugEnabled()) {
            Assert.exists(property, class$java$lang$String == null ? (class$java$lang$String = Reporter.class$("java.lang.String")) : class$java$lang$String);
            PropertyDescriptor[] props = this.m_info.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                PropertyDescriptor prop = props[i];
                if (!prop.getName().equals(property)) continue;
                Method method = prop.getReadMethod();
                if (method == null) break;
                this.m_log.debug((Object)(property + " set to " + this.literal(this.value(method)) + " on " + this.m_object));
                break;
            }
        }
    }

    public final void report() {
        if (this.m_log.isDebugEnabled()) {
            PropertyDescriptor[] props = this.m_info.getPropertyDescriptors();
            this.m_log.debug((Object)("-*- " + this.m_object + " -*-"));
            for (int i = 0; i < props.length; ++i) {
                Method method = props[i].getReadMethod();
                if (method == null) continue;
                this.m_log.debug((Object)this.print(method));
            }
        }
    }

    private String print(Method method) {
        Class<?> clacc = method.getReturnType();
        Package pakkage = clacc.getPackage();
        StringBuffer buffer = new StringBuffer(64);
        if (pakkage == null) {
            buffer.append(clacc.getName());
        } else {
            buffer.append(clacc.getName().substring(pakkage.getName().length() + 1));
        }
        buffer.append(" ");
        buffer.append(method.getName());
        int len = 30 - buffer.length();
        if (len > 0) {
            char[] spacer = new char[len];
            Arrays.fill(spacer, ' ');
            buffer.insert(0, spacer);
        }
        buffer.append("() -> ");
        buffer.append(this.literal(this.value(method)));
        return buffer.toString();
    }

    private String literal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        return object.toString();
    }

    private Object value(Method method) {
        try {
            return method.invoke(this.m_object, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            throw new UncheckedWrapperException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new UncheckedWrapperException(ite);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

