/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.sitemap;

import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.SplitPanel;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.ui.sitemap.SiteListing;
import com.arsdigita.ui.sitemap.SiteMapAdminPane;
import com.arsdigita.ui.util.GlobalizationUtil;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SiteMapDispatcher
extends BebopMapDispatcher {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/sitemap/SiteMapDispatcher.java#15 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$sitemap$SiteMapDispatcher == null ? (class$com$arsdigita$ui$sitemap$SiteMapDispatcher = SiteMapDispatcher.class$("com.arsdigita.ui.sitemap.SiteMapDispatcher")) : class$com$arsdigita$ui$sitemap$SiteMapDispatcher));
    static final String SEARCH_KEY = "search";
    static /* synthetic */ Class class$com$arsdigita$ui$sitemap$SiteMapDispatcher;

    public SiteMapDispatcher() {
        s_log.debug((Object)"Construct SiteMapDispatcher");
        HashMap<String, Page> m = new HashMap<String, Page>();
        m.put("", this.buildAdminPage());
        m.put("denied", this.buildDeniedPage());
        this.setMap(m);
    }

    public void dispatch(HttpServletRequest req, HttpServletResponse resp, RequestContext ctx) throws IOException, ServletException {
        String requestURI = Web.getContext().getRequestURL().getRequestURI();
        if (requestURI.endsWith("/denied")) {
            super.dispatch(req, resp, ctx);
            return;
        }
        UserContext userCtx = Web.getUserContext();
        if (!userCtx.isLoggedIn()) {
            throw new LoginSignal(req);
        }
        String processedURL = ctx.getProcessedURLPart();
        SiteNode node = SiteNode.getSiteNode(processedURL);
        User user = userCtx.getUser();
        if (user == null) {
            throw new RuntimeException("User does not exist");
        }
        PermissionDescriptor admin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, node, user);
        DispatcherHelper.cacheDisable(resp);
        if (!PermissionService.checkPermission(admin)) {
            URL url = URL.there(req, node.getURL() + "denied");
            throw new RedirectSignal(url, false);
        }
        super.dispatch(req, resp, ctx);
    }

    private Page buildDeniedPage() {
        Page p = PageFactory.buildPage("admin", new Label(new GlobalizedMessage("ui.admin.dispatcher.accessDenied", "com.arsdigita.ui.admin.AdminResources")));
        Label label = new Label(GlobalizationUtil.globalize("ui.sitemap.access_denied_to_sitemap"));
        label.setClassAttr("AccessDenied");
        p.add(label);
        p.lock();
        return p;
    }

    private Page buildAdminPage() {
        Page p = PageFactory.buildPage("admin", "Sitemap Administration");
        SiteListing listing = new SiteListing();
        listing.setClassAttr("navbar");
        SingleSelectionModel m = listing.getTree().getSelectionModel();
        SiteMapAdminPane details = new SiteMapAdminPane(m, listing.getCFGLink());
        BoxPanel box = new BoxPanel();
        box.setClassAttr("main");
        box.add(details);
        SplitPanel panel = new SplitPanel();
        panel.setClassAttr("sidebarNavPanel");
        panel.setLeftComponent(listing);
        panel.setRightComponent(box);
        p.add(panel);
        p.lock();
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

