/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ElementComponent;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.ui.login.ChangePasswordForm;
import com.arsdigita.ui.login.DynamicLink;
import com.arsdigita.ui.login.LoginHelper;
import com.arsdigita.ui.login.RecoverPasswordPanel;
import com.arsdigita.ui.login.UserEditForm;
import com.arsdigita.ui.login.UserInfo;
import com.arsdigita.ui.login.UserLogoutListener;
import com.arsdigita.ui.login.UserNewForm;
import com.arsdigita.ui.login.UserRegistrationForm;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.ReturnSignal;
import com.arsdigita.web.URL;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SubsiteDispatcher
extends BebopMapDispatcher {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/SubsiteDispatcher.java#15 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String APPLICATION_NAME = "login";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$ui$login$SubsiteDispatcher == null ? (class$com$arsdigita$ui$login$SubsiteDispatcher = SubsiteDispatcher.class$("com.arsdigita.ui.login.SubsiteDispatcher")) : class$com$arsdigita$ui$login$SubsiteDispatcher).getName());
    static final String SUBSITE_NS_URI = "http://www.arsdigita.com/subsite/1.0";
    static /* synthetic */ Class class$com$arsdigita$ui$login$SubsiteDispatcher;

    public SubsiteDispatcher() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String redirect = Initializer.getURL(Initializer.ROOT_PAGE_KEY);
        RedirectDispatcher root = new RedirectDispatcher(redirect);
        map.put("", root);
        map.put("index", root);
        this.put(map, Initializer.EDIT_PAGE_KEY, SubsiteDispatcher.buildSimplePage("login.userEditPage.title", new UserEditForm()));
        this.put(map, Initializer.LOGIN_PAGE_KEY, SubsiteDispatcher.buildSimplePage("login.userRegistrationForm.title", new UserRegistrationForm(Initializer.getAutoRegistrationOn())));
        if (Initializer.getAutoRegistrationOn()) {
            this.put(map, Initializer.NEWUSER_PAGE_KEY, SubsiteDispatcher.buildSimplePage("login.userNewForm.title", new UserNewForm()));
        }
        this.put(map, Initializer.LOGOUT_PAGE_KEY, SubsiteDispatcher.buildLogOutPage());
        this.put(map, Initializer.COOKIES_PAGE_KEY, SubsiteDispatcher.buildSimplePage("login.explainCookiesPage.title", new ElementComponent("subsite:explainPersistentCookies", SUBSITE_NS_URI)));
        this.put(map, Initializer.CHANGE_PAGE_KEY, SubsiteDispatcher.buildSimplePage("login.changePasswordPage.title", new ChangePasswordForm()));
        this.put(map, Initializer.RECOVER_PAGE_KEY, SubsiteDispatcher.buildSimplePage("login.recoverPasswordPage.title", new RecoverPasswordPanel()));
        Page workspace = SubsiteDispatcher.buildSimplePage("login.workspacePage.title", new UserInfo());
        this.put(map, Initializer.WORKSPACE_PAGE_KEY, workspace);
        this.put(map, Initializer.EXPIRED_PAGE_KEY, SubsiteDispatcher.buildExpiredPage());
        String url = Initializer.getURL(Initializer.WORKSPACE_PAGE_KEY);
        if (url.equals("pvt/")) {
            map.put("pvt/home", workspace);
        }
        this.setMap(map);
    }

    protected void preprocessRequest(HttpServletRequest req, HttpServletResponse resp, RequestContext ctx, String url) {
        if (url.equals(Initializer.getURL(Initializer.COOKIES_PAGE_KEY)) || url.equals(Initializer.getURL(Initializer.EXPIRED_PAGE_KEY)) || url.equals(Initializer.getURL(Initializer.RECOVER_PAGE_KEY))) {
            DispatcherHelper.cacheForWorld(resp);
        } else {
            DispatcherHelper.cacheDisable(resp);
        }
    }

    private void put(Map map, String key, Page page) {
        String url = Initializer.getURL(key);
        map.put(url, page);
        if (url.endsWith("/")) {
            map.put(url + "index", page);
            this.requireTrailingSlash(url.substring(0, url.length() - 1));
        }
    }

    private static Page buildSimplePage(String title, Component body) {
        Page page = PageFactory.buildPage(APPLICATION_NAME, new Label(LoginHelper.getMessage(title)));
        page.add(body);
        page.lock();
        return page;
    }

    private static Page buildExpiredPage() {
        Page page = PageFactory.buildPage(APPLICATION_NAME, new Label(LoginHelper.getMessage("login.loginExpiredPage.title")));
        page.add(new SimpleContainer(){
            {
                this.add(new Label(LoginHelper.getMessage("login.loginExpiredPage.before")));
                this.add(new DynamicLink("login.loginExpiredPage.link", Initializer.LOGIN_PAGE_KEY));
                this.add(new Label(LoginHelper.getMessage("login.loginExpiredPage.after")));
                this.add(new ElementComponent("subsite:explainLoginExpired", SubsiteDispatcher.SUBSITE_NS_URI));
            }
        });
        page.lock();
        return page;
    }

    private static Page buildLogOutPage() {
        Page page = PageFactory.buildPage(APPLICATION_NAME, new Label(LoginHelper.getMessage("Logout")));
        page.addActionListener(new UserLogoutListener());
        page.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                HttpServletRequest req = state.getRequest();
                String path = Initializer.getFullURL(Initializer.ROOT_PAGE_KEY, req);
                throw new ReturnSignal(req, URL.there(req, path));
            }
        });
        page.lock();
        return page;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RedirectDispatcher
    implements Dispatcher {
        private String m_path;

        public RedirectDispatcher(String path) {
            this.m_path = path;
        }

        public void dispatch(HttpServletRequest req, HttpServletResponse resp, RequestContext actx) throws IOException, ServletException {
            URL url = URL.there(req, "/" + this.m_path, new ParameterMap(req));
            throw new RedirectSignal(url, false);
        }
    }
}

