/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.admin.SearchAndListModel;
import com.arsdigita.ui.admin.Utilities;
import java.math.BigDecimal;

class GroupSearchAndListModel
implements SearchAndListModel {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/GroupSearchAndListModel.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private DataQuery m_query;
    private static final String GROUP_ID = "groupID";
    private static final String GROUP_NAME = "name";
    private static final String RETRIEVE_GROUPS = "com.arsdigita.kernel.RetrieveGroups";
    private BigDecimal m_excludedGroupID;

    GroupSearchAndListModel() {
    }

    public void setQuery(String query) {
        StringBuffer sb = new StringBuffer();
        sb.append("searchName like lower('%");
        sb.append(Utilities.prepare(query));
        sb.append("%')");
        Session session = SessionManager.getSession();
        this.m_query = session.retrieveQuery(RETRIEVE_GROUPS);
        this.m_query.addFilter(sb.toString());
        if (this.m_excludedGroupID != null) {
            this.m_query.addFilter("groupID != " + this.m_excludedGroupID);
        }
    }

    public void setExcludedGroupID(BigDecimal id) {
        this.m_excludedGroupID = id;
    }

    public String getKey() {
        return this.m_query == null ? null : this.m_query.get(GROUP_ID).toString();
    }

    public Object getElement() {
        return this.m_query == null ? null : this.m_query.get(GROUP_NAME);
    }

    public boolean next() {
        if (this.m_query == null) {
            return false;
        }
        boolean ret = this.m_query.next();
        if (!ret) {
            this.m_query = null;
        }
        return ret;
    }
}

