/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.developersupport.StackTraces;
import com.arsdigita.toolbox.ui.Cancellable;
import com.arsdigita.toolbox.ui.ComponentMap;
import com.arsdigita.toolbox.ui.NullComponent;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ModalPanel
extends ComponentMap {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ModalPanel.java#22 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$toolbox$ui$ModalPanel == null ? (class$com$arsdigita$toolbox$ui$ModalPanel = ModalPanel.class$("com.arsdigita.toolbox.ui.ModalPanel")) : class$com$arsdigita$toolbox$ui$ModalPanel));
    private final IndexStack m_stack = new IndexStack();
    private Component m_default = new NullComponent();
    static /* synthetic */ Class class$com$arsdigita$toolbox$ui$ModalPanel;
    static /* synthetic */ Class class$com$arsdigita$bebop$Component;

    public ModalPanel() {
        this.put("__null__", this.m_default);
    }

    public void register(Page page) {
        super.register(page);
        page.addComponentStateParam(this, this.m_stack);
        Iterator iter = this.children();
        while (iter.hasNext()) {
            page.setVisibleDefault((Component)iter.next(), false);
        }
        page.addActionListener(new VisibilityListener());
    }

    public final void generateXML(PageState state, Element parent) {
        this.top(state).setVisible(state, true);
        if (this.isVisible(state)) {
            this.top(state).generateXML(state, parent);
        }
    }

    public final void add(Component component) {
        Assert.unlocked(this);
        Assert.exists(component, class$com$arsdigita$bebop$Component == null ? (class$com$arsdigita$bebop$Component = ModalPanel.class$("com.arsdigita.bebop.Component")) : class$com$arsdigita$bebop$Component);
        this.put(component, component);
    }

    public void reset(PageState state) {
        super.reset(state);
        this.clear(state);
    }

    public final void clear(PageState state) {
        s_log.debug((Object)"Clearing the stack");
        this.m_stack.clear(state);
    }

    public final void push(PageState state, Component pushed) {
        if (Assert.isEnabled()) {
            Assert.exists(pushed, class$com$arsdigita$bebop$Component == null ? (class$com$arsdigita$bebop$Component = ModalPanel.class$("com.arsdigita.bebop.Component")) : class$com$arsdigita$bebop$Component);
            Assert.truth(this.containsKey(pushed), "Component " + pushed + " is not a child " + "of this container");
        }
        if (!pushed.equals(this.top(state))) {
            this.m_stack.push(state, state.getPage().stateIndex(pushed));
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Pushed " + this.top(state) + " visible"));
                s_log.debug((Object)("Stack is " + this.m_stack.toDebugString(state)));
                s_log.debug((Object)"Here", new Throwable());
            }
        }
    }

    public final void pop(PageState state) {
        if (this.m_stack.isEmpty(state)) {
            s_log.debug((Object)"The stack is empty; nothing was popped");
        } else {
            this.m_stack.pop(state);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Popped " + this.top(state) + " visible"));
                s_log.debug((Object)("Stack is " + this.m_stack.toDebugString(state)));
                s_log.debug((Object)"Here", new Throwable());
            }
        }
    }

    public final Component top(PageState state) {
        if (this.m_stack.isEmpty(state)) {
            return this.getDefault();
        }
        return state.getPage().getComponent(this.m_stack.top(state));
    }

    public final void setDefault(Component defaalt) {
        if (Assert.isEnabled()) {
            Assert.unlocked(this);
            Assert.exists(defaalt, class$com$arsdigita$bebop$Component == null ? (class$com$arsdigita$bebop$Component = ModalPanel.class$("com.arsdigita.bebop.Component")) : class$com$arsdigita$bebop$Component);
            Assert.truth(this.containsValue(defaalt), defaalt + " is not one of my children");
        }
        this.m_default = defaalt;
        s_log.debug((Object)("Default set to " + defaalt));
    }

    public final Component getDefault() {
        return this.m_default;
    }

    public final void connect(ActionLink orig, Component dest) {
        orig.addActionListener(new NavigationListener(dest));
    }

    public final void connect(Table orig, int column, Component dest) {
        orig.addTableActionListener(new TableNavigationListener(column, dest));
    }

    public final void connect(List orig, Component dest) {
        orig.addActionListener(new NavigationListener(dest));
    }

    public final void connect(Tree orig, Component dest) {
        orig.addActionListener(new NavigationListener(dest));
    }

    public final void connect(FormSection orig, Component dest) {
        orig.addProcessListener(new FormNavigationListener(dest));
    }

    public final void connect(FormSection origForm, Widget origWidget, Object value, Component dest) {
        origForm.addProcessListener(new WidgetNavigationListener(origWidget, value, dest));
    }

    public final void connect(ActionLink orig, FormSection dest) {
        this.connect(orig, (Component)dest);
        dest.addSubmissionListener(new CancelListener(dest));
    }

    public final void connect(Table orig, int column, FormSection dest) {
        this.connect(orig, column, (Component)dest);
        dest.addSubmissionListener(new CancelListener(dest, orig.getRowSelectionModel()));
    }

    public final void connect(List orig, FormSection dest) {
        this.connect(orig, (Component)dest);
        dest.addSubmissionListener(new CancelListener(dest, orig.getSelectionModel()));
    }

    public final void connect(Tree orig, FormSection dest) {
        this.connect(orig, (Component)dest);
        dest.addSubmissionListener(new CancelListener(dest, orig.getSelectionModel()));
    }

    public final void connect(FormSection orig, FormSection dest) {
        this.connect(orig, (Component)dest);
        dest.addSubmissionListener(new CancelListener(dest));
    }

    public final void connect(Form origForm, Widget origWidget, Object value, FormSection dest) {
        this.connect((FormSection)origForm, origWidget, value, (Component)dest);
        dest.addSubmissionListener(new CancelListener(dest));
    }

    public final void connect(FormSection orig) {
        orig.addProcessListener(new FinishListener());
    }

    public final void connect(FormSection orig, SingleSelectionModel model) {
        orig.addProcessListener(new FinishListener(model));
    }

    public final void resume(FormSection orig, Component dest) {
        orig.addProcessListener(new ResumeListener(dest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class IndexStack
    extends ArrayParameter {
        IndexStack() {
            super(new IntegerParameter("stack"));
        }

        final boolean isEmpty(PageState state) {
            Integer[] stack = (Integer[])state.getValue(this);
            return stack == null || stack.length == 0;
        }

        final void clear(PageState state) {
            state.setValue(this, null);
        }

        final int top(PageState state) {
            Integer[] stack = (Integer[])state.getValue(this);
            if (stack == null || stack.length == 0) {
                throw new IllegalStateException("The stack is empty");
            }
            return stack[stack.length - 1];
        }

        final void push(PageState state, int index) {
            Integer[] before = (Integer[])state.getValue(this);
            if (before == null || before.length == 0) {
                state.setValue(this, new Integer[]{new Integer(index)});
            } else {
                Integer[] after = new Integer[before.length + 1];
                for (int i = 0; i < before.length; ++i) {
                    after[i] = before[i];
                }
                after[before.length] = new Integer(index);
                state.setValue(this, after);
            }
        }

        final void pop(PageState state) {
            Integer[] before = (Integer[])state.getValue(this);
            if (before == null || before.length == 0) {
                throw new IllegalStateException("The stack is empty");
            }
            Integer[] after = new Integer[before.length - 1];
            for (int i = 0; i < after.length; ++i) {
                after[i] = before[i];
            }
            state.setValue(this, after);
        }

        final String toDebugString(PageState state) {
            StringBuffer buffer = new StringBuffer();
            Integer[] stack = (Integer[])state.getValue(this);
            if (stack == null || stack.length == 0) {
                return "[]";
            }
            for (int i = 0; i < stack.length; ++i) {
                buffer.append(",");
                buffer.append(stack[i]);
            }
            return "[" + buffer.toString().substring(1) + "] <- top";
        }
    }

    protected final class ResetListener
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            ModalPanel.this.reset(e.getPageState());
        }
    }

    protected final class ResumeListener
    implements FormProcessListener {
        private final Component m_target;

        public ResumeListener(Component target) {
            this.m_target = target;
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Resuming the pre-excursion state");
            }
            PageState state = e.getPageState();
            while (!ModalPanel.this.top(state).equals(this.m_target)) {
                ModalPanel.this.pop(state);
            }
        }
    }

    protected final class FinishListener
    implements FormProcessListener {
        private SingleSelectionModel m_model = null;

        public FinishListener() {
        }

        public FinishListener(SingleSelectionModel model) {
            this();
            this.m_model = model;
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Form processing went as planned and there is no subsequent step; reverting to pre-excursion state");
            }
            ModalPanel.this.pop(state);
            if (this.m_model != null) {
                this.m_model.clearSelection(state);
            }
        }
    }

    protected final class CancelListener
    implements FormSubmissionListener {
        private final Cancellable m_cancellable;
        private SingleSelectionModel m_model;

        public CancelListener(FormSection form) {
            Assert.assertNotNull(form, "FormSection form");
            if (form instanceof Cancellable) {
                this.m_cancellable = (Cancellable)((Object)form);
            } else {
                this.m_cancellable = null;
                s_log.warn((Object)("Form " + form + " does not " + "implement Cancellable."));
                StackTraces.log("The form was created at", form, s_log, "warn");
            }
        }

        public CancelListener(FormSection form, SingleSelectionModel model) {
            this(form);
            Assert.assertNotNull(model, "SingleSelectionModel model");
            this.m_model = model;
        }

        public final void submitted(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (this.m_cancellable != null && this.m_cancellable.isCancelled(state)) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Form processing is cancelled; reverting to pre-excursion state");
                }
                ModalPanel.this.pop(state);
                if (this.m_model != null) {
                    this.m_model.clearSelection(state);
                }
                throw new FormProcessException("cancelled");
            }
        }
    }

    protected final class WidgetNavigationListener
    implements FormProcessListener {
        private final Widget m_widget;
        private final Object m_value;
        private final Component m_target;

        public WidgetNavigationListener(Widget widget, Object value, Component target) {
            Assert.assertNotNull(widget, "Widget widget");
            Assert.assertNotNull(value, "String value");
            Assert.assertNotNull(target, "Component target");
            this.m_widget = widget;
            this.m_value = value;
            this.m_target = target;
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (this.m_value.equals(this.m_widget.getValue(state))) {
                ModalPanel.this.push(state, this.m_target);
            }
        }
    }

    protected final class FormNavigationListener
    implements FormProcessListener {
        private final Component m_target;

        public FormNavigationListener(Component target) {
            Assert.assertNotNull(target, "Component target");
            this.m_target = target;
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            ModalPanel.this.push(e.getPageState(), this.m_target);
        }
    }

    protected final class TableNavigationListener
    extends TableActionAdapter {
        private final int m_column;
        private final Component m_target;

        public TableNavigationListener(int column, Component target) {
            Assert.assertNotNull(target, "Component target");
            this.m_column = column;
            this.m_target = target;
        }

        public final void cellSelected(TableActionEvent e) {
            if (e.getColumn() == this.m_column) {
                ModalPanel.this.push(e.getPageState(), this.m_target);
            }
        }
    }

    protected final class NavigationListener
    implements ActionListener {
        private final Component m_target;

        public NavigationListener(Component target) {
            Assert.exists(target, class$com$arsdigita$bebop$Component == null ? (class$com$arsdigita$bebop$Component = ModalPanel.class$("com.arsdigita.bebop.Component")) : class$com$arsdigita$bebop$Component);
            this.m_target = target;
        }

        public final void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            Object source = e.getSource();
            if (!(source instanceof Tree) || ((Tree)source).isSelected(state)) {
                ModalPanel.this.push(state, this.m_target);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Navigating to " + this.m_target));
                }
            }
        }
    }

    private class VisibilityListener
    implements ActionListener {
        private VisibilityListener() {
        }

        public final void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            if (state.isVisibleOnPage(ModalPanel.this)) {
                Iterator iter = ModalPanel.this.children();
                while (iter.hasNext()) {
                    ((Component)iter.next()).setVisible(state, false);
                }
            }
        }
    }
}

