/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.EventListenerList;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.QueryEvent;
import com.arsdigita.toolbox.ui.QueryListener;
import com.arsdigita.util.Assert;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataTable
extends Table
implements PaginationModelBuilder {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/DataTable.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$toolbox$ui$DataTable == null ? (class$com$arsdigita$toolbox$ui$DataTable = DataTable.class$("com.arsdigita.toolbox.ui.DataTable")) : class$com$arsdigita$toolbox$ui$DataTable).getName());
    private DataQueryBuilder m_builder;
    private SingleSelectionModel m_orderModel;
    private StringParameter m_dirParam;
    private String m_resourceBundle;
    private RequestLocal m_querySize;
    private Paginator m_paginator;
    public static final String ORDER = "o";
    public static final String DIRECTION = "d";
    public static final String ASCENDING = "asc";
    public static final String DESCENDING = "desc";
    private EventListenerList m_queryListeners;
    static /* synthetic */ Class class$com$arsdigita$toolbox$ui$DataTable;
    static /* synthetic */ Class class$com$arsdigita$toolbox$ui$QueryListener;

    public DataTable(DataQueryBuilder builder, SingleSelectionModel orderModel, String resourceBundle) {
        super((TableModelBuilder)new DataBuilderAdapter(), new DataTableColumnModel());
        this.m_builder = builder;
        this.m_resourceBundle = resourceBundle;
        this.setOrderSelectionModel(orderModel);
        this.addTableActionListener(new DataTableActionListener());
        this.m_queryListeners = new EventListenerList();
        this.m_dirParam = new StringParameter(DIRECTION);
        this.m_dirParam.setDefaultValue(ASCENDING);
        this.getHeader().setDefaultRenderer(new GlobalizedHeaderCellRenderer());
        this.m_querySize = new RequestLocal();
        this.m_paginator = null;
        this.setClassAttr("dataTable");
    }

    public DataTable(DataQueryBuilder builder, SingleSelectionModel orderModel) {
        this(builder, orderModel, null);
    }

    public DataTable(DataQueryBuilder builder) {
        this(builder, new ParameterSingleSelectionModel(new StringParameter(ORDER)));
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam(this, this.getOrderSelectionModel().getStateParameter());
        p.addComponentStateParam(this, this.m_dirParam);
    }

    public void setDefaultOrder(String attribute) {
        Assert.assertNotLocked(this);
        this.getOrderSelectionModel().getStateParameter().setDefaultValue(attribute);
    }

    public String getDefaultOrder() {
        return (String)this.getOrderSelectionModel().getStateParameter().getDefaultValue();
    }

    public TableColumn addColumn(String label, String attribute, boolean isSortable, TableCellRenderer renderer) {
        return this.addColumn(label, attribute, isSortable, renderer, null);
    }

    public TableColumn addColumn(String label, String attribute, boolean isSortable, TableCellRenderer renderer, String orderAttribute) {
        DataTableColumnModel model = (DataTableColumnModel)this.getColumnModel();
        SortableTableColumn column = new SortableTableColumn(model.size(), label, attribute, isSortable, renderer);
        model.add(column, orderAttribute);
        if (isSortable && this.getDefaultOrder() == null) {
            this.setDefaultOrder(orderAttribute == null ? attribute : orderAttribute);
        }
        return column;
    }

    public TableColumn addColumn(String label, String attribute, boolean isSortable) {
        return this.addColumn(label, attribute, isSortable, new DefaultTableCellRenderer(false));
    }

    public TableColumn addColumn(String label, String attribute) {
        return this.addColumn(label, attribute, false);
    }

    public TableColumn addColumn(String label, TableCellRenderer renderer) {
        TableColumnModel m = this.getColumnModel();
        TableColumn c = new TableColumn(m.size(), label);
        c.setCellRenderer(renderer);
        c.setHeaderRenderer(new GlobalizedHeaderCellRenderer(false));
        m.add(c);
        return c;
    }

    public DataQueryBuilder getDataQueryBuilder() {
        return this.m_builder;
    }

    public void setDataQueryBuilder(DataQueryBuilder builder) {
        Assert.assertNotLocked(this);
        this.m_builder = builder;
    }

    public void setOrderSelectionModel(SingleSelectionModel orderModel) {
        Assert.assertNotLocked(this);
        this.m_orderModel = orderModel;
    }

    public SingleSelectionModel getOrderSelectionModel() {
        return this.m_orderModel;
    }

    public void addQueryListener(QueryListener l) {
        Assert.assertNotLocked(this);
        this.m_queryListeners.add(class$com$arsdigita$toolbox$ui$QueryListener == null ? (class$com$arsdigita$toolbox$ui$QueryListener = DataTable.class$("com.arsdigita.toolbox.ui.QueryListener")) : class$com$arsdigita$toolbox$ui$QueryListener, l);
    }

    public void removeQueryListener(QueryListener l) {
        Assert.assertNotLocked(this);
        this.m_queryListeners.remove(class$com$arsdigita$toolbox$ui$QueryListener == null ? (class$com$arsdigita$toolbox$ui$QueryListener = DataTable.class$("com.arsdigita.toolbox.ui.QueryListener")) : class$com$arsdigita$toolbox$ui$QueryListener, l);
    }

    protected void fireQueryPending(PageState state, DataQuery query) {
        Iterator i = this.m_queryListeners.getListenerIterator(class$com$arsdigita$toolbox$ui$QueryListener == null ? (class$com$arsdigita$toolbox$ui$QueryListener = DataTable.class$("com.arsdigita.toolbox.ui.QueryListener")) : class$com$arsdigita$toolbox$ui$QueryListener);
        QueryEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new QueryEvent(this, state, query);
            }
            ((QueryListener)i.next()).queryPending(e);
        }
    }

    public void setOrder(PageState s, String attr) {
        this.getOrderSelectionModel().setSelectedKey(s, attr);
    }

    public String getOrder(PageState s) {
        return (String)this.getOrderSelectionModel().getSelectedKey(s);
    }

    public String getOrderDirection(PageState s) {
        return (String)s.getValue(this.m_dirParam);
    }

    public void setOrderDirection(PageState s, String dir) {
        Assert.assertTrue(ASCENDING.equals(dir) || DESCENDING.equals(dir));
        s.setValue(this.m_dirParam, dir);
    }

    public String toggleOrderDirection(PageState s) {
        String dir = this.getOrderDirection(s);
        dir = ASCENDING.equals(dir) ? DESCENDING : ASCENDING;
        this.setOrderDirection(s, dir);
        return dir;
    }

    public DataQuery getDataQuery(PageState s) {
        return ((DataQueryTableModel)this.getTableModel(s)).getDataQuery();
    }

    public int getTotalSize(Paginator paginator, PageState s) {
        DataQuery q = this.getDataQuery(s);
        BigDecimal size = (BigDecimal)this.m_querySize.get(s);
        if (size == null) {
            size = new BigDecimal((double)q.size());
            this.m_querySize.set(s, (Object)size);
        }
        q.setRange(new Integer(paginator.getFirst(s)), new Integer(paginator.getLast(s) + 1));
        return size.intValue();
    }

    public final Paginator getPaginator() {
        return this.m_paginator;
    }

    public final void setPaginator(Paginator p) {
        Assert.assertNotLocked(this);
        this.m_paginator = p;
    }

    protected final RequestLocal getQuerySizeLocal() {
        return this.m_querySize;
    }

    public void lock() {
        this.m_builder.lock();
        super.lock();
    }

    public void generateExtraXMLAttributes(PageState s, Element element) {
        String dir;
        String key = this.getOrder(s);
        if (key != null) {
            element.addAttribute("order", Integer.toString(this.getColumnModel().getIndex(key)));
        }
        if ((dir = this.getOrderDirection(s)) != null) {
            element.addAttribute("direction", dir);
        }
    }

    public GlobalizedMessage globalize(String key) {
        return new GlobalizedMessage(key, this.m_resourceBundle);
    }

    public String getResourceBundle() {
        return this.m_resourceBundle;
    }

    public void setResourceBundle(String bundle) {
        Assert.assertNotLocked(this);
        this.m_resourceBundle = bundle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class DataTableColumnModel
    extends DefaultTableColumnModel {
        private Map m_columnKeys = new HashMap();

        protected DataTableColumnModel() {
        }

        public void add(TableColumn column, String columnKey) {
            super.add(column);
            this.setColumnKey(column, columnKey);
        }

        public void add(int columnIndex, TableColumn column, String columnKey) {
            super.add(columnIndex, column);
            this.setColumnKey(column, columnKey);
        }

        public String getColumnKey(TableColumn column) {
            return (String)this.m_columnKeys.get(column);
        }

        public String getKeyAt(int columnIndex) {
            return this.getColumnKey(this.get(columnIndex));
        }

        public void setColumnKey(TableColumn column, String columnKey) {
            this.m_columnKeys.put(column, columnKey);
        }

        public void setColumnKey(int columnIndex, String columnKey) {
            this.setColumnKey(this.get(columnIndex), columnKey);
        }

        public void remove(TableColumn column) {
            super.remove(column);
            this.m_columnKeys.remove(column);
        }
    }

    protected static class GlobalizedHeaderCellRenderer
    implements TableCellRenderer {
        private boolean m_active;

        public GlobalizedHeaderCellRenderer(boolean isActive) {
            this.m_active = isActive;
        }

        public GlobalizedHeaderCellRenderer() {
            this(true);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Label label;
            DataTable t = (DataTable)table;
            if (value == null) {
                label = new Label("&nbsp;", false);
            } else {
                String str = value.toString();
                label = t.getResourceBundle() != null ? new Label(t.globalize(str)) : new Label(str);
            }
            if (this.m_active) {
                return new ControlLink(label);
            }
            return label;
        }
    }

    protected static class DataQueryTableModel
    implements TableModel {
        private DataQuery m_data;
        private DataTableColumnModel m_cols;
        private String m_keyColumn;

        public DataQueryTableModel(DataTable t, DataQuery data, String keyColumn) {
            this.m_data = data;
            this.m_cols = (DataTableColumnModel)t.getColumnModel();
            this.m_keyColumn = keyColumn;
        }

        public int getColumnCount() {
            return this.m_cols.size();
        }

        public boolean nextRow() {
            return this.m_data.next();
        }

        public Object getElementAt(int columnIndex) {
            String key = (String)this.m_cols.get(columnIndex).getHeaderKey();
            if (key != null) {
                return this.m_data.get(key);
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            String key = this.m_cols.getKeyAt(columnIndex);
            if (key != null) {
                return this.m_data.get(key);
            }
            return this.m_data.get(this.m_keyColumn);
        }

        public DataQuery getDataQuery() {
            return this.m_data;
        }
    }

    protected static class DataBuilderAdapter
    extends LockableImpl
    implements TableModelBuilder {
        protected DataQuery createQuery(DataTable t, PageState s) {
            DataQuery d = t.getDataQueryBuilder().makeDataQuery(t, s);
            String o = t.getOrder(s);
            if (o != null) {
                String dir = t.getOrderDirection(s);
                if (dir != null) {
                    o = o + " " + dir;
                }
                d.addOrder(o);
            }
            t.fireQueryPending(s, d);
            if (t.getPaginator() != null) {
                if (t.getQuerySizeLocal().get(s) == null) {
                    t.getQuerySizeLocal().set(s, (Object)new BigDecimal((double)d.size()));
                }
                d.setRange(new Integer(t.getPaginator().getFirst(s)), new Integer(t.getPaginator().getLast(s) + 1));
            }
            return d;
        }

        public TableModel makeModel(Table table, PageState s) {
            DataTable t = (DataTable)table;
            DataQuery d = this.createQuery(t, s);
            if (d == null) {
                return Table.EMPTY_MODEL;
            }
            return new DataQueryTableModel(t, d, t.getDataQueryBuilder().getKeyColumn());
        }
    }

    private static class DataTableActionListener
    implements TableActionListener {
        private DataTableActionListener() {
        }

        public void cellSelected(TableActionEvent e) {
        }

        public void headSelected(TableActionEvent e) {
            PageState s = e.getPageState();
            DataTable t = (DataTable)e.getSource();
            int index = e.getColumn();
            SortableTableColumn c = (SortableTableColumn)t.getColumnModel().get(index);
            if (c != null && c.isSortable()) {
                DataTableColumnModel m = (DataTableColumnModel)t.getColumnModel();
                String oldOrder = t.getOrder(s);
                String newOrder = m.getColumnKey(c);
                if (newOrder == null) {
                    newOrder = (String)c.getHeaderKey();
                }
                if (oldOrder != null && oldOrder.equals(newOrder)) {
                    t.toggleOrderDirection(s);
                } else {
                    t.setOrder(s, newOrder);
                    t.setOrderDirection(s, DataTable.ASCENDING);
                }
            }
        }
    }

    public static class SortableTableColumn
    extends TableColumn {
        private boolean m_sortable;
        private SingleSelectionModel m_orderModel;

        public SortableTableColumn(int modelIndex, Object value, Object key, boolean isSortable, TableCellRenderer renderer) {
            super(modelIndex, value, key);
            this.setSortable(isSortable);
            this.setCellRenderer(renderer);
        }

        public void setSortable(boolean isSortable) {
            Assert.assertNotLocked(this);
            this.m_sortable = isSortable;
            this.setHeaderRenderer(new GlobalizedHeaderCellRenderer(isSortable));
        }

        public SingleSelectionModel getOrderSelectionModel() {
            return this.m_orderModel;
        }

        public boolean isSortable() {
            return this.m_sortable;
        }
    }
}

