/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.BevelBox;
import com.arsdigita.toolbox.rebop.FormattedText;
import com.arsdigita.toolbox.rebop.GenericButton;
import com.arsdigita.toolbox.rebop.GenericComponent;
import com.arsdigita.toolbox.rebop.GenericDrawable;
import com.arsdigita.toolbox.rebop.GenericImage;
import com.arsdigita.toolbox.rebop.GenericLabel;
import com.arsdigita.toolbox.rebop.GenericList;
import com.arsdigita.toolbox.rebop.GenericListItem;
import com.arsdigita.toolbox.rebop.StyledText;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class WidgetTestApplet
extends Applet {
    private GenericList m_sp = new GenericList();
    private GenericList m_messageArea = new GenericList();
    private GenericLabel m_statusLabel = new GenericLabel("status");
    private GenericComponent m_container = new GenericComponent();
    private boolean m_doubleBuffer = false;
    private boolean m_isApp = false;
    private GenericImage m_mainBackground = null;
    private GenericImage m_itemIcon = null;
    private GenericImage m_listBackground = null;
    private Image m_bgImage = null;
    private Image m_iconImage = null;
    private Image m_listBackgroundImage = null;
    private MediaTracker m_tracker = null;
    private TextField m_tf = new TextField();

    public WidgetTestApplet() {
        this(true);
    }

    public WidgetTestApplet(boolean doubleBuffer) {
        this.m_doubleBuffer = doubleBuffer;
        this.m_tracker = new MediaTracker(this);
        this.m_sp.setName("m_sp");
        this.m_container.setName("m_container");
    }

    public void setIsApp(boolean isApp) {
        this.m_isApp = isApp;
    }

    public void setIconImage(Image itemIcon) {
        this.m_iconImage = itemIcon;
        this.m_itemIcon = new GenericImage(itemIcon);
        if (null != itemIcon) {
            this.m_sp.setDefaultItemIcon(itemIcon);
        }
    }

    public void setBackgroundImage(Image mainBackground) {
        if (null == mainBackground) {
            this.m_container.setDrawable(new BevelBox(Color.orange, null, null, 0, false));
        } else {
            this.m_mainBackground = new GenericImage(mainBackground);
            this.m_container.setDrawable(this.m_mainBackground);
        }
    }

    public void setListBackgroundImage(Image listBackground) {
        this.m_listBackground = new GenericImage(listBackground);
        if (null != listBackground) {
            this.m_sp.setDrawable(this.m_listBackground);
        }
    }

    private Image loadImage(String imageSpec, boolean loadLocal) {
        Image img = null;
        AppletContext context = this.getAppletContext();
        URL newurl = null;
        try {
            String docbase = "file://localhost/home/gavin/develop/open/toolbox/build/classes";
            newurl = new URL(docbase + "/" + imageSpec);
            System.out.println("New URL: " + newurl);
            img = context.getImage(newurl);
            if (null != img) {
                return img;
            }
        }
        catch (MalformedURLException me) {
            me.printStackTrace();
        }
        URL docBase = this.getCodeBase();
        if (loadLocal) {
            Class<?> c = this.getClass();
            URL url = c.getResource(imageSpec.substring(imageSpec.lastIndexOf("/") + 1));
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            System.out.println("attempting to load: " + url);
            img = toolkit.getImage(url);
        } else {
            img = this.getImage(docBase, imageSpec);
        }
        if (null == img) {
            System.out.println("can't find image: " + imageSpec + " in " + docBase);
            return img;
        }
        int id = 1;
        this.m_tracker.addImage(img, id);
        try {
            this.m_tracker.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return img;
    }

    private Image alternateLoadImage(String imageSpec) {
        Image img = null;
        try {
            InputStream in = this.getClass().getResourceAsStream(imageSpec);
            if (in == null) {
                System.err.println("Image not found");
            } else {
                byte[] buffer = new byte[in.available()];
                in.read(buffer);
                img = this.getToolkit().createImage(buffer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return img;
    }

    public void init() {
        if (!this.m_isApp) {
            this.m_bgImage = this.getImage(this.getCodeBase(), this.getParameter("bgImage"));
            this.m_iconImage = this.getImage(this.getCodeBase(), this.getParameter("iconImage"));
            this.setIconImage(this.m_iconImage);
            this.setBackgroundImage(this.m_bgImage);
        }
        this.m_container.setSize(600, 400);
        this.setLayout(new BorderLayout());
        this.m_sp.setBounds(15, 15, 200, 175);
        this.m_sp.setMaxItems(50);
        this.m_sp.setDrawable(new BevelBox(null, Color.lightGray, Color.darkGray, 2, true));
        this.m_sp.setItemUpDrawable(null);
        this.m_sp.setItemOverDrawable(new BevelBox(null, Color.lightGray, Color.darkGray, 2, false));
        this.m_sp.setItemDownDrawable(new BevelBox(GenericListItem.DEFAULT_SELECTED_COLOR, null, null, 0, false));
        GenericButton iconButton = new GenericButton(this.m_iconImage, null, 0, 0);
        BevelBox whiteBevelUp = new BevelBox(Color.white, Color.lightGray, Color.gray, 2, false);
        BevelBox whiteBevelDown = new BevelBox(Color.white, Color.lightGray, Color.gray, 2, true);
        iconButton.setUpDrawable(whiteBevelUp);
        iconButton.setOverDrawable(whiteBevelUp);
        iconButton.setDownDrawable(whiteBevelDown);
        iconButton.setBounds(320, 10, 38, 38);
        GenericButton add = new GenericButton("add");
        add.setBounds(320, 60, 80, 30);
        BevelBox buttonUp = new BevelBox(null, Color.white, Color.black, 1, false);
        BevelBox buttonDown = new BevelBox(null, Color.white, Color.black, 2, true);
        BevelBox buttonOver = new BevelBox(null, Color.white, Color.black, 2, false);
        add.setUpDrawable(buttonUp);
        add.setOverDrawable(buttonOver);
        add.setDownDrawable(buttonDown);
        add.addActionListener(new ActionListener(){
            private int count = 0;

            public void actionPerformed(ActionEvent e) {
                WidgetTestApplet.this.m_sp.add("Person" + this.count + ":", "Text is " + this.count * 1000 + " words of babble and other nonsense", "UserData for list item " + this.count);
                ++this.count;
            }
        });
        GenericComponent testComposite = new GenericComponent();
        GenericComponent multiples = new GenericComponent();
        multiples.setLayout(new GridBagLayout());
        multiples.setDrawable(new BevelBox(Color.red, Color.white, Color.yellow, 4, true));
        GenericLabel lab = new GenericLabel("TEST");
        lab.setForeground(Color.green);
        multiples.add(lab);
        testComposite.setDrawable(multiples);
        testComposite.setBounds(320, 250, 80, 80);
        GenericLabel multiFontTest = new GenericLabel();
        FormattedText label = new FormattedText(null, Color.darkGray, "Now are\nthe times that try men's souls. ");
        FormattedText body = new FormattedText(null, Color.red, "And when in the world will this ever work?");
        StyledText stx = new StyledText();
        stx.addRun(label);
        stx.addRun(body);
        multiFontTest.setDrawable(stx);
        GenericButton labelTest = new GenericButton("wrap test");
        labelTest.setUpDrawable(buttonUp);
        labelTest.setOverDrawable(buttonOver);
        labelTest.setDownDrawable(buttonDown);
        labelTest.setBounds(400, 60, 100, 30);
        multiFontTest.setBounds(415, 250, 100, 100);
        GenericButton remove = new GenericButton("remove");
        remove.setUpDrawable(buttonUp);
        remove.setOverDrawable(buttonOver);
        remove.setDownDrawable(buttonDown);
        remove.setBounds(320, 120, 50, 30);
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WidgetTestApplet.this.m_sp.remove(WidgetTestApplet.this.m_sp.getSelectedIndex());
            }
        });
        this.m_sp.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                System.out.println("Item: " + e);
                Object di = e.getItem();
                if (null == di) {
                    di = "";
                }
                WidgetTestApplet.this.m_statusLabel.setName(di.toString());
                WidgetTestApplet.this.m_statusLabel.repaint();
            }
        });
        this.m_statusLabel.setBounds(320, 200, 100, 30);
        GenericButton db = new GenericButton("Double Buffer");
        db.setToggleButton(true);
        db.setUpDrawable(buttonUp);
        db.setOverDrawable(buttonOver);
        db.setDownDrawable(buttonDown);
        db.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WidgetTestApplet.this.m_container.setDoubleBuffered(!WidgetTestApplet.this.m_container.getDoubleBuffered());
            }
        });
        db.setBounds(320, 150, 50, 30);
        GenericListItem wrapLabel = new GenericListItem(null, "Test", "This is a test", null);
        wrapLabel.setBounds(450, 200, 150, 30);
        this.m_tf.setBounds(450, 300, 150, 30);
        this.m_tf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextField field = (TextField)e.getSource();
                WidgetTestApplet.this.m_sp.add("User Text: ", field.getText(), null);
            }
        });
        this.m_tf.setFont(new Font("SansSerif", 0, 12));
        this.m_messageArea.setFont(new Font("SansSerif", 0, 12));
        this.m_messageArea.setDrawable(new BevelBox(Color.white, Color.lightGray, Color.darkGray, 2, true));
        GenericDrawable bb = null;
        this.m_messageArea.setItemUpDrawable(bb);
        this.m_messageArea.setItemOverDrawable(bb);
        this.m_messageArea.setItemDownDrawable(bb);
        this.m_messageArea.setLabelColor(Color.blue);
        this.m_messageArea.setRolloverLabelColor(Color.blue);
        this.m_messageArea.setSelectedLabelColor(Color.blue);
        this.m_messageArea.setTextColor(Color.black);
        this.m_messageArea.setSelectedTextColor(Color.black);
        this.m_messageArea.setRolloverTextColor(Color.black);
        this.m_messageArea.setDoubleBuffered(true);
        this.m_messageArea.setBounds(15, 195, 200, 175);
        GenericButton add2 = new GenericButton("add2");
        add2.setUpDrawable(buttonUp);
        add2.setOverDrawable(buttonOver);
        add2.setDownDrawable(buttonDown);
        add2.setBounds(400, 60, 100, 30);
        add2.addActionListener(new ActionListener(){
            private int count2 = 0;

            public void actionPerformed(ActionEvent e) {
                WidgetTestApplet.this.m_messageArea.add("Sample" + this.count2 + ":", "Text is " + this.count2 * 100, null);
                ++this.count2;
            }
        });
        this.m_container.setLayout(null);
        this.m_container.add(this.m_sp);
        this.m_container.add(iconButton);
        this.m_container.add(add);
        this.m_container.add(remove);
        this.m_container.add(this.m_statusLabel);
        this.m_container.add(wrapLabel);
        this.m_container.add(db);
        this.m_container.add(multiFontTest);
        this.m_container.add(testComposite);
        this.m_container.add(add2);
        this.m_container.setDoubleBuffered(this.m_doubleBuffer);
        multiples.setBounds(0, 0, testComposite.getBounds().width, testComposite.getBounds().height);
        GenericComponent labelContainer = new GenericComponent();
        labelContainer.setBounds(320, 250, 200, 200);
        labelContainer.setLayout(new FlowLayout(0, 2, 2));
        labelContainer.add(new GenericLabel("One"));
        labelContainer.add(new GenericLabel("This is longer"));
        labelContainer.add(new GenericLabel("Shortish"));
        this.m_container.add(labelContainer);
        this.setLayout(null);
        this.add((Component)this.m_container, "Center");
        this.doLayout();
        multiples.setVisible(false);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        if (args.length > 0 && "true".equals(args[0])) {
            GenericComponent.setDebugPaint(true);
        }
        boolean db = false;
        if (args.length > 1 && args[1].equals("true")) {
            db = true;
        }
        boolean isApplet = false;
        if (args.length > 2 && args[2].equals("true")) {
            isApplet = true;
        }
        WidgetTestApplet applet = new WidgetTestApplet(db);
        applet.setIsApp(isApplet);
        Image icon = applet.getToolkit().createImage("./ignore.gif");
        Image mainBackground = applet.getToolkit().createImage("./bg.jpg");
        MediaTracker tracker = new MediaTracker(applet);
        tracker.addImage(icon, 0);
        tracker.addImage(mainBackground, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        f.setLayout(new BorderLayout());
        f.add((Component)applet, "Center");
        f.setSize(600, 400);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        applet.setIconImage(icon);
        applet.init();
        applet.setBackgroundImage(mainBackground);
        f.show();
    }
}

