/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.FormattedText;
import com.arsdigita.toolbox.rebop.GenericButton;
import com.arsdigita.toolbox.rebop.GenericDrawable;
import com.arsdigita.toolbox.rebop.StyledText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;

public class GenericListItem
extends GenericButton {
    public static final Color DEFAULT_UNSELECTED_COLOR = Color.white;
    public static final Color DEFAULT_SELECTED_COLOR = new Color(3417);
    private int m_currentIndex = -1;
    private Font m_currentFont = null;
    private Color m_textColor = Color.black;
    private Color m_selectedTextColor = Color.white;
    private Color m_rolloverTextColor = Color.blue;
    private Object m_userData = null;

    public GenericListItem() {
        this(null, "", "", null);
    }

    public GenericListItem(Image icon, String label, String text, Object userData) {
        this(icon, label, text, userData, null, null, null);
    }

    public GenericListItem(Image icon, String label, String text, Object userData, GenericDrawable upDrawable, GenericDrawable downDrawable, GenericDrawable overDrawable) {
        super.init(icon, label);
        this.setText(text);
        this.setUserData(userData);
        this.getLabel().setXOffset(0);
        this.getLabel().setYOffset(0);
        this.setUpDrawable(upDrawable);
        this.setDownDrawable(downDrawable);
        this.setOverDrawable(overDrawable);
        this.updateDrawable();
    }

    protected void updateDrawable() {
        if (this.m_selected) {
            this.setDrawable(this.m_downDrawable);
        } else if (this.m_mouseOver) {
            this.setDrawable(this.m_overDrawable);
        } else {
            this.setDrawable(this.m_upDrawable);
        }
    }

    protected LayoutManager getDefaultLayout() {
        return new FlowLayout(0, 2, 2);
    }

    public void setText(String text) {
        StyledText stx = this.getLabel().getStyledText();
        FormattedText ft = stx.getFormattedTextAt(1);
        if (null == ft) {
            ft = new FormattedText(this.m_currentFont, this.getCurrentTextColor(), text);
            stx.setFormattedTextAt(1, ft);
        } else {
            ft.setString(text);
        }
        this.updateLabelSize();
    }

    public void setUserData(Object userData) {
        this.m_userData = userData;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public String getLabelString() {
        StyledText stx = this.getLabel().getStyledText();
        FormattedText label = stx.getFormattedTextAt(0);
        String dLabel = "";
        if (null != label) {
            dLabel = label.getString();
        }
        return dLabel;
    }

    public void setLabelString(String newLabel) {
    }

    public String getText() {
        StyledText stx = this.getLabel().getStyledText();
        String dText = "";
        FormattedText text = stx.getFormattedTextAt(1);
        if (null != text) {
            dText = text.getString();
        }
        return dText;
    }

    public String toString() {
        return this.getLabelString() + " " + this.getBounds();
    }

    public Dimension getPreferredSize() {
        Dimension superSize = super.getPreferredSize();
        return new Dimension(this.getSize().width, superSize.height);
    }

    private FormattedText getFormattedText() {
        StyledText stx = this.getLabel().getStyledText();
        FormattedText ft = stx.getFormattedTextAt(1);
        return ft;
    }

    public void setTextColor(Color color) {
        this.m_textColor = color;
    }

    public void setSelectedTextColor(Color color) {
        this.m_selectedTextColor = color;
    }

    public void setRolloverTextColor(Color color) {
        this.m_rolloverTextColor = color;
    }

    protected void updateColors() {
        super.updateColors();
        FormattedText ft = this.getFormattedText();
        if (null != ft && null != this.getCurrentTextColor()) {
            ft.setColor(this.getCurrentTextColor());
        }
    }

    protected Color getCurrentTextColor() {
        if (this.getSelected()) {
            return this.m_selectedTextColor;
        }
        if (this.getMouseOver()) {
            return this.m_rolloverTextColor;
        }
        return this.m_textColor;
    }

    public int getCurrentIndex() {
        return this.m_currentIndex;
    }

    public void setCurrentIndex(int index) {
        this.m_currentIndex = index;
    }

    public void mousePressed(MouseEvent e) {
        this.setSelected(true);
        this.updateColors();
        this.updateDrawable();
        this.repaint();
        ActionEvent ae = new ActionEvent(this, 501, "mousePressed");
        this.processActionEvent(ae);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateColors();
        this.updateDrawable();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void validate() {
        this.validateTree();
        super.validate();
    }
}

