/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.templating;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.templating.PatternGenerator;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.web.Web;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class URLPatternGenerator
implements PatternGenerator {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$templating$URLPatternGenerator == null ? (class$com$arsdigita$templating$URLPatternGenerator = URLPatternGenerator.class$("com.arsdigita.templating.URLPatternGenerator")) : class$com$arsdigita$templating$URLPatternGenerator));
    private static final String DEFAULT_URL_MATCH = "index";
    static /* synthetic */ Class class$com$arsdigita$templating$URLPatternGenerator;
    static /* synthetic */ Class class$com$arsdigita$kernel$SiteNode;

    public String[] generateValues(String key, HttpServletRequest req) {
        int i;
        String path = this.getPath();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Substituting values for url " + path));
        }
        int dotIndex = path.lastIndexOf(".");
        int slashIndex = path.lastIndexOf("/");
        if (dotIndex > -1 && dotIndex > slashIndex) {
            path = path.substring(0, dotIndex);
        }
        if (path != null && path.endsWith("/index")) {
            path = path.substring(0, path.length() - DEFAULT_URL_MATCH.length());
        }
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path != null && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path == null) {
            path = "";
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Normalized path is '" + path + "'"));
        }
        String[] bits = StringUtils.split(path, '/');
        if (s_log.isDebugEnabled()) {
            for (i = 0; i < bits.length; ++i) {
                s_log.debug((Object)(" -> '" + bits[i] + "'"));
            }
        }
        for (i = 1; i < bits.length; ++i) {
            bits[i] = bits[i - 1] + "-" + bits[i];
        }
        String[] reverseBits = new String[bits.length + 1];
        int i2 = bits.length - 1;
        int j = 0;
        while (i2 > -1) {
            reverseBits[j] = bits[i2];
            --i2;
            ++j;
        }
        reverseBits[reverseBits.length - 1] = DEFAULT_URL_MATCH;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"After concatenation & reversing");
            for (i2 = 0; i2 < reverseBits.length; ++i2) {
                s_log.debug((Object)(" -> '" + reverseBits[i2] + "'"));
            }
        }
        return reverseBits;
    }

    private String getPath() {
        String base = this.getBasePath();
        String url = Web.getContext().getRequestURL().getPathInfo();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Base is " + base + " url is " + url));
        }
        Assert.truth(url.startsWith(base), "URL " + url + " starts with " + base);
        return url.substring(base.length() - 1);
    }

    private String getBasePath() {
        SiteNodeRequestContext ctx = (SiteNodeRequestContext)DispatcherHelper.getRequestContext(Web.getRequest());
        SiteNode node = ctx.getSiteNode();
        Assert.exists(node, class$com$arsdigita$kernel$SiteNode == null ? (class$com$arsdigita$kernel$SiteNode = URLPatternGenerator.class$("com.arsdigita.kernel.SiteNode")) : class$com$arsdigita$kernel$SiteNode);
        return node.getURL();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

